/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.driver.DriverContext;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.CountMergeOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.LevelTimeSeriesCountOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.TimeSeriesCountOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CountMergeOperatorTest {
    private static final String COUNT_MERGE_OPERATOR_TEST_SG = "root.CountMergeOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, COUNT_MERGE_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeSeriesCountOperator() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            OperatorContext operatorContext = fragmentInstanceContext.addOperatorContext(1, planNodeId, TimeSeriesCountOperator.class.getSimpleName());
            PartialPath partialPath = new PartialPath(COUNT_MERGE_OPERATOR_TEST_SG);
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(LocalConfigNode.getInstance().getBelongedSchemaRegionId(partialPath));
            operatorContext.getInstanceContext().setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion));
            TimeSeriesCountOperator timeSeriesCountOperator = new TimeSeriesCountOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), partialPath, true, null, null, false, Collections.emptyMap());
            TsBlock tsBlock = null;
            while (timeSeriesCountOperator.hasNext()) {
                tsBlock = timeSeriesCountOperator.next();
            }
            Assert.assertNotNull(tsBlock);
            Assert.assertEquals((long)100L, (long)tsBlock.getColumn(0).getLong(0));
            TimeSeriesCountOperator timeSeriesCountOperator2 = new TimeSeriesCountOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), new PartialPath("root.CountMergeOperatorTest.device1.*"), false, null, null, false, Collections.emptyMap());
            tsBlock = timeSeriesCountOperator2.next();
            Assert.assertFalse((boolean)timeSeriesCountOperator2.hasNext());
            Assert.assertTrue((boolean)timeSeriesCountOperator2.isFinished());
            Assert.assertEquals((long)10L, (long)tsBlock.getColumn(0).getLong(0));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountMergeOperator() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            OperatorContext operatorContext = fragmentInstanceContext.addOperatorContext(1, planNodeId, LevelTimeSeriesCountOperator.class.getSimpleName());
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(LocalConfigNode.getInstance().getBelongedSchemaRegionId(new PartialPath(COUNT_MERGE_OPERATOR_TEST_SG)));
            operatorContext.getInstanceContext().setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion));
            LevelTimeSeriesCountOperator timeSeriesCountOperator1 = new LevelTimeSeriesCountOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), new PartialPath(COUNT_MERGE_OPERATOR_TEST_SG), true, 2, null, null, false);
            LevelTimeSeriesCountOperator timeSeriesCountOperator2 = new LevelTimeSeriesCountOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), new PartialPath("root.CountMergeOperatorTest.device2"), true, 2, null, null, false);
            CountMergeOperator countMergeOperator = new CountMergeOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), Arrays.asList(timeSeriesCountOperator1, timeSeriesCountOperator2));
            TsBlock tsBlock = null;
            Assert.assertTrue((boolean)countMergeOperator.isBlocked().isDone());
            while (countMergeOperator.hasNext()) {
                tsBlock = countMergeOperator.next();
                if (tsBlock == null) continue;
                Assert.assertFalse((boolean)countMergeOperator.hasNext());
            }
            Assert.assertNotNull(tsBlock);
            for (int i = 0; i < 10; ++i) {
                String path = tsBlock.getColumn(0).getBinary(i).getStringValue();
                Assert.assertTrue((boolean)path.startsWith("root.CountMergeOperatorTest.device"));
                if (path.equals("root.CountMergeOperatorTest.device2")) {
                    Assert.assertEquals((long)20L, (long)tsBlock.getColumn(1).getLong(i));
                    continue;
                }
                Assert.assertEquals((long)10L, (long)tsBlock.getColumn(1).getLong(i));
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

