/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.join.TimeJoinOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.DescTimeComparator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeJoinOperatorTest {
    private static final String TIME_JOIN_OPERATOR_TEST_SG = "root.TimeJoinOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, TIME_JOIN_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest1() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            MeasurementPath measurementPath1 = new MeasurementPath("root.TimeJoinOperatorTest.device0.sensor0", TSDataType.INT32);
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            allSensors.add("sensor1");
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            fragmentInstanceContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            fragmentInstanceContext.addOperatorContext(3, new PlanNodeId("3"), TimeJoinOperator.class.getSimpleName());
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator(planNodeId1, (PartialPath)measurementPath1, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, true);
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath2 = new MeasurementPath("root.TimeJoinOperatorTest.device0.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator(planNodeId2, (PartialPath)measurementPath2, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), null, null, true);
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            TimeJoinOperator timeJoinOperator = new TimeJoinOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), Arrays.asList(seriesScanOperator1, seriesScanOperator2), Ordering.ASC, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)new AscTimeComparator())), (TimeComparator)new AscTimeComparator());
            int count = 0;
            while (timeJoinOperator.hasNext()) {
                TsBlock tsBlock = timeJoinOperator.next();
                Assert.assertEquals((long)2L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(1) instanceof IntColumn));
                int i = 0;
                while (i < tsBlock.getPositionCount()) {
                    Assert.assertEquals((long)count, (long)tsBlock.getTimeByIndex(i));
                    if ((long)count < 200L) {
                        Assert.assertEquals((long)(20000L + (long)count), (long)tsBlock.getColumn(0).getInt(i));
                        Assert.assertEquals((long)(20000L + (long)count), (long)tsBlock.getColumn(1).getInt(i));
                    } else if ((long)count < 260L || (long)count >= 300L && (long)count < 380L || (long)count >= 400L) {
                        Assert.assertEquals((long)(10000L + (long)count), (long)tsBlock.getColumn(0).getInt(i));
                        Assert.assertEquals((long)(10000L + (long)count), (long)tsBlock.getColumn(1).getInt(i));
                    } else {
                        Assert.assertEquals((long)count, (long)tsBlock.getColumn(0).getInt(i));
                        Assert.assertEquals((long)count, (long)tsBlock.getColumn(1).getInt(i));
                    }
                    ++i;
                    ++count;
                }
            }
            Assert.assertEquals((long)500L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest2() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            MeasurementPath measurementPath1 = new MeasurementPath("root.TimeJoinOperatorTest.device0.sensor0", TSDataType.INT32);
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            allSensors.add("sensor1");
            allSensors.add("error_sensor");
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            fragmentInstanceContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            fragmentInstanceContext.addOperatorContext(3, planNodeId3, SeriesScanOperator.class.getSimpleName());
            fragmentInstanceContext.addOperatorContext(4, new PlanNodeId("4"), TimeJoinOperator.class.getSimpleName());
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator(planNodeId1, (PartialPath)measurementPath1, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, true);
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath2 = new MeasurementPath("root.TimeJoinOperatorTest.device0.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator(planNodeId2, (PartialPath)measurementPath2, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), null, null, true);
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath3 = new MeasurementPath("root.TimeJoinOperatorTest.device0.error_sensor", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator3 = new SeriesScanOperator(planNodeId3, (PartialPath)measurementPath3, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), null, null, true);
            seriesScanOperator3.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator3.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            TimeJoinOperator timeJoinOperator = new TimeJoinOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(3), Arrays.asList(seriesScanOperator1, seriesScanOperator2, seriesScanOperator3), Ordering.ASC, Arrays.asList(TSDataType.INT32, TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(2, 0), (TimeComparator)new AscTimeComparator())), (TimeComparator)new AscTimeComparator());
            int count = 0;
            while (timeJoinOperator.hasNext()) {
                TsBlock tsBlock = timeJoinOperator.next();
                Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(1) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(2) instanceof RunLengthEncodedColumn));
                int i = 0;
                while (i < tsBlock.getPositionCount()) {
                    Assert.assertEquals((long)count, (long)tsBlock.getTimeByIndex(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    if ((long)count < 200L) {
                        Assert.assertEquals((long)(20000L + (long)count), (long)tsBlock.getColumn(0).getInt(i));
                        Assert.assertEquals((long)(20000L + (long)count), (long)tsBlock.getColumn(1).getInt(i));
                    } else if ((long)count < 260L || (long)count >= 300L && (long)count < 380L || (long)count >= 400L) {
                        Assert.assertEquals((long)(10000L + (long)count), (long)tsBlock.getColumn(0).getInt(i));
                        Assert.assertEquals((long)(10000L + (long)count), (long)tsBlock.getColumn(1).getInt(i));
                    } else {
                        Assert.assertEquals((long)count, (long)tsBlock.getColumn(0).getInt(i));
                        Assert.assertEquals((long)count, (long)tsBlock.getColumn(1).getInt(i));
                    }
                    ++i;
                    ++count;
                }
            }
            Assert.assertEquals((long)500L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest3() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            MeasurementPath measurementPath1 = new MeasurementPath("root.TimeJoinOperatorTest.device0.sensor0", TSDataType.INT32);
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            allSensors.add("sensor1");
            allSensors.add("error_sensor");
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            fragmentInstanceContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            fragmentInstanceContext.addOperatorContext(3, planNodeId3, SeriesScanOperator.class.getSimpleName());
            fragmentInstanceContext.addOperatorContext(4, new PlanNodeId("4"), TimeJoinOperator.class.getSimpleName());
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator(planNodeId1, (PartialPath)measurementPath1, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, false);
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath2 = new MeasurementPath("root.TimeJoinOperatorTest.device0.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator(planNodeId2, (PartialPath)measurementPath2, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), null, null, false);
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath3 = new MeasurementPath("root.TimeJoinOperatorTest.device0.error_sensor", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator3 = new SeriesScanOperator(planNodeId3, (PartialPath)measurementPath3, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), null, null, true);
            seriesScanOperator3.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator3.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            TimeJoinOperator timeJoinOperator = new TimeJoinOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(3), Arrays.asList(seriesScanOperator1, seriesScanOperator2, seriesScanOperator3), Ordering.DESC, Arrays.asList(TSDataType.INT32, TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(2, 0), (TimeComparator)new DescTimeComparator())), (TimeComparator)new DescTimeComparator());
            int count = 499;
            while (timeJoinOperator.hasNext()) {
                TsBlock tsBlock = timeJoinOperator.next();
                Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(1) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(2) instanceof RunLengthEncodedColumn));
                int i = 0;
                while (i < tsBlock.getPositionCount()) {
                    Assert.assertEquals((long)count, (long)tsBlock.getTimeByIndex(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    if ((long)count < 200L) {
                        Assert.assertEquals((long)(20000L + (long)count), (long)tsBlock.getColumn(0).getInt(i));
                        Assert.assertEquals((long)(20000L + (long)count), (long)tsBlock.getColumn(1).getInt(i));
                    } else if ((long)count < 260L || (long)count >= 300L && (long)count < 380L || (long)count >= 400L) {
                        Assert.assertEquals((long)(10000L + (long)count), (long)tsBlock.getColumn(0).getInt(i));
                        Assert.assertEquals((long)(10000L + (long)count), (long)tsBlock.getColumn(1).getInt(i));
                    } else {
                        Assert.assertEquals((long)count, (long)tsBlock.getColumn(0).getInt(i));
                        Assert.assertEquals((long)count, (long)tsBlock.getColumn(1).getInt(i));
                    }
                    ++i;
                    --count;
                }
            }
            Assert.assertEquals((long)-1L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

