/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.AggregationOperatorTest;
import org.apache.iotdb.db.mpp.execution.operator.AggregationUtil;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.RawDataAggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.TimeJoinOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RawDataAggregationOperatorTest {
    private static final String AGGREGATION_OPERATOR_TEST_SG = "root.RawDataAggregationOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private ExecutorService instanceNotificationExecutor;

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, AGGREGATION_OPERATOR_TEST_SG);
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        this.instanceNotificationExecutor.shutdown();
    }

    @Test
    public void aggregateRawDataTest1() throws IllegalPathException {
        ArrayList<AggregationType> aggregationTypes = new ArrayList<AggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < 2; ++i) {
            aggregationTypes.add(AggregationType.COUNT);
            aggregationTypes.add(AggregationType.SUM);
            aggregationTypes.add(AggregationType.MIN_TIME);
            aggregationTypes.add(AggregationType.MAX_TIME);
            aggregationTypes.add(AggregationType.MAX_VALUE);
            aggregationTypes.add(AggregationType.MIN_VALUE);
            for (int j = 0; j < 6; ++j) {
                ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
                inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
                inputLocations.add(inputLocationForOneAggregator);
            }
        }
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations);
        int count = 0;
        while (rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            for (int i = 0; i < 2; ++i) {
                Assert.assertEquals((long)500L, (long)resultTsBlock.getColumn(6 * i).getLong(0));
                Assert.assertEquals((double)6524750.0, (double)resultTsBlock.getColumn(6 * i + 1).getDouble(0), (double)1.0E-4);
                Assert.assertEquals((long)0L, (long)resultTsBlock.getColumn(6 * i + 2).getLong(0));
                Assert.assertEquals((long)499L, (long)resultTsBlock.getColumn(6 * i + 3).getLong(0));
                Assert.assertEquals((long)20199L, (long)resultTsBlock.getColumn(6 * i + 4).getInt(0));
                Assert.assertEquals((long)260L, (long)resultTsBlock.getColumn(6 * i + 5).getInt(0));
            }
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void aggregateRawDataTest2() throws IllegalPathException {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        ArrayList<AggregationType> aggregationTypes = new ArrayList<AggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(AggregationType.AVG);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(AggregationType.FIRST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(AggregationType.LAST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations);
        int count = 0;
        while (rawDataAggregationOperator.hasNext()) {
            int i2;
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            for (i2 = 0; i2 < 2; ++i2) {
                Assert.assertEquals((double)13049.5, (double)resultTsBlock.getColumn(i2).getDouble(0), (double)0.001);
            }
            for (i2 = 2; i2 < 4; ++i2) {
                Assert.assertEquals((long)20000L, (long)resultTsBlock.getColumn(i2).getInt(0));
            }
            for (i2 = 4; i2 < 6; ++i2) {
                Assert.assertEquals((long)10499L, (long)resultTsBlock.getColumn(i2).getInt(0));
            }
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void groupByRawDataTest1() throws IllegalPathException {
        int[][] result = new int[][]{{100, 100, 100, 99}, {2004950, 2014950, 624950, 834551}, {0, 100, 200, 300}, {99, 199, 299, 398}, {20099, 20199, 10259, 10379}, {20000, 20100, 260, 380}};
        ArrayList<AggregationType> aggregationTypes = new ArrayList<AggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < 2; ++i) {
            aggregationTypes.add(AggregationType.COUNT);
            aggregationTypes.add(AggregationType.SUM);
            aggregationTypes.add(AggregationType.MIN_TIME);
            aggregationTypes.add(AggregationType.MAX_TIME);
            aggregationTypes.add(AggregationType.MAX_VALUE);
            aggregationTypes.add(AggregationType.MIN_VALUE);
            for (int j = 0; j < 6; ++j) {
                ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
                inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
                inputLocations.add(inputLocationForOneAggregator);
            }
        }
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 399L, 100L, 100L, true);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, groupByTimeParameter, inputLocations);
        int count = 0;
        while (rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                Assert.assertEquals((long)(100 * count), (long)resultTsBlock.getTimeColumn().getLong(row));
                for (int i = 0; i < 2; ++i) {
                    Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(6 * i).getLong(row));
                    Assert.assertEquals((double)result[1][count], (double)resultTsBlock.getColumn(6 * i + 1).getDouble(row), (double)1.0E-4);
                    Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(6 * i + 2).getLong(row));
                    Assert.assertEquals((long)result[3][count], (long)resultTsBlock.getColumn(6 * i + 3).getLong(row));
                    Assert.assertEquals((long)result[4][count], (long)resultTsBlock.getColumn(6 * i + 4).getInt(row));
                    Assert.assertEquals((long)result[5][count], (long)resultTsBlock.getColumn(6 * i + 5).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test
    public void groupByRawDataTest2() throws IllegalPathException {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        double[][] result = new double[][]{{20049.5, 20149.5, 6249.5, 8429.808}, {20000.0, 20100.0, 10200.0, 10300.0}, {20099.0, 20199.0, 299.0, 398.0}};
        ArrayList<AggregationType> aggregationTypes = new ArrayList<AggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(AggregationType.AVG);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(AggregationType.FIRST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(AggregationType.LAST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 399L, 100L, 100L, true);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, groupByTimeParameter, inputLocations);
        int count = 0;
        while (rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                int i2;
                Assert.assertEquals((long)(100 * count), (long)resultTsBlock.getTimeColumn().getLong(row));
                for (i2 = 0; i2 < 2; ++i2) {
                    Assert.assertEquals((double)result[0][count], (double)resultTsBlock.getColumn(i2).getDouble(row), (double)0.001);
                }
                for (i2 = 2; i2 < 4; ++i2) {
                    Assert.assertEquals((long)((int)result[1][count]), (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                for (i2 = 4; i2 < 6; ++i2) {
                    Assert.assertEquals((long)((int)result[2][count]), (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    private RawDataAggregationOperator initRawDataAggregationOperator(List<AggregationType> aggregationTypes, GroupByTimeParameter groupByTimeParameter, List<List<InputLocation[]>> inputLocations) throws IllegalPathException {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        MeasurementPath measurementPath1 = new MeasurementPath("root.RawDataAggregationOperatorTest.device0.sensor0", TSDataType.INT32);
        HashSet<String> allSensors = new HashSet<String>();
        allSensors.add("sensor0");
        allSensors.add("sensor1");
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        PlanNodeId planNodeId1 = new PlanNodeId("1");
        fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
        PlanNodeId planNodeId2 = new PlanNodeId("2");
        fragmentInstanceContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
        fragmentInstanceContext.addOperatorContext(3, new PlanNodeId("3"), TimeJoinOperator.class.getSimpleName());
        fragmentInstanceContext.addOperatorContext(4, new PlanNodeId("4"), RawDataAggregationOperatorTest.class.getSimpleName());
        fragmentInstanceContext.getOperatorContexts().forEach(operatorContext -> operatorContext.setMaxRunTime(AggregationOperatorTest.TEST_TIME_SLICE));
        SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator(planNodeId1, (PartialPath)measurementPath1, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, true);
        seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
        MeasurementPath measurementPath2 = new MeasurementPath("root.RawDataAggregationOperatorTest.device0.sensor1", TSDataType.INT32);
        SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator(planNodeId2, (PartialPath)measurementPath2, allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), null, null, true);
        seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
        TimeJoinOperator timeJoinOperator = new TimeJoinOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), Arrays.asList(seriesScanOperator1, seriesScanOperator2), Ordering.ASC, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)new AscTimeComparator())), (TimeComparator)new AscTimeComparator());
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        List accumulators = AccumulatorFactory.createAccumulators(aggregationTypes, (TSDataType)TSDataType.INT32, (boolean)true);
        for (int i = 0; i < accumulators.size(); ++i) {
            aggregators.add(new Aggregator((Accumulator)accumulators.get(i), AggregationStep.SINGLE, inputLocations.get(i)));
        }
        return new RawDataAggregationOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(3), aggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)true), (Operator)timeJoinOperator, true, (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
    }
}

