/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.DeviceViewOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeviceViewOperatorTest {
    private static final String DEVICE_MERGE_OPERATOR_TEST_SG = "root.DeviceViewOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, DEVICE_MERGE_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    @Test
    public void deviceMergeOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            fragmentInstanceContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            fragmentInstanceContext.addOperatorContext(3, new PlanNodeId("3"), DeviceViewOperatorTest.class.getSimpleName());
            MeasurementPath measurementPath1 = new MeasurementPath("root.DeviceViewOperatorTest.device0.sensor0", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator(planNodeId1, (PartialPath)measurementPath1, Collections.singleton("sensor0"), TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, true);
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath2 = new MeasurementPath("root.DeviceViewOperatorTest.device1.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator(planNodeId2, (PartialPath)measurementPath2, Collections.singleton("sensor1"), TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), null, null, true);
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext().setMaxRunTime(new Duration(500.0, TimeUnit.MILLISECONDS));
            ArrayList<String> devices = new ArrayList<String>();
            devices.add("root.DeviceViewOperatorTest.device0");
            devices.add("root.DeviceViewOperatorTest.device1");
            ArrayList<SeriesScanOperator> deviceOperators = new ArrayList<SeriesScanOperator>();
            deviceOperators.add(seriesScanOperator1);
            deviceOperators.add(seriesScanOperator2);
            ArrayList<List<Integer>> deviceColumnIndex = new ArrayList<List<Integer>>();
            deviceColumnIndex.add(Collections.singletonList(1));
            deviceColumnIndex.add(Collections.singletonList(2));
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            dataTypes.add(TSDataType.TEXT);
            dataTypes.add(TSDataType.INT32);
            dataTypes.add(TSDataType.INT32);
            DeviceViewOperator deviceViewOperator = new DeviceViewOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), devices, deviceOperators, deviceColumnIndex, dataTypes);
            int count = 0;
            while (deviceViewOperator.hasNext()) {
                TsBlock tsBlock = deviceViewOperator.next();
                if (tsBlock == null) continue;
                Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
                int i = 0;
                while (i < tsBlock.getPositionCount()) {
                    long expectedTime = count % 500;
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getTimeByIndex(i));
                    Assert.assertEquals((Object)(count < 500 ? "root.DeviceViewOperatorTest.device0" : "root.DeviceViewOperatorTest.device1"), (Object)tsBlock.getColumn(0).getBinary(i).getStringValue());
                    if (expectedTime < 200L) {
                        if (!tsBlock.getColumn(1).isNull(i)) {
                            Assert.assertEquals((long)(20000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                            Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                        } else {
                            Assert.assertEquals((long)(20000L + expectedTime), (long)tsBlock.getColumn(2).getInt(i));
                        }
                    } else if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
                        if (!tsBlock.getColumn(1).isNull(i)) {
                            Assert.assertEquals((long)(10000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                            Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                        } else {
                            Assert.assertEquals((long)(10000L + expectedTime), (long)tsBlock.getColumn(2).getInt(i));
                        }
                    } else if (!tsBlock.getColumn(1).isNull(i)) {
                        Assert.assertEquals((long)expectedTime, (long)tsBlock.getColumn(1).getInt(i));
                        Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    } else {
                        Assert.assertEquals((long)expectedTime, (long)tsBlock.getColumn(2).getInt(i));
                    }
                    ++i;
                    ++count;
                }
            }
            Assert.assertEquals((long)1000L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

