/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.exchange.ISinkHandle;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class StubSinkHandle
implements ISinkHandle {
    private final ListenableFuture<Void> NOT_BLOCKED = Futures.immediateVoidFuture();
    private final List<TsBlock> tsBlocks = new ArrayList<TsBlock>();
    private final FragmentInstanceContext instanceContext;
    private boolean closed = false;

    public StubSinkHandle(FragmentInstanceContext instanceContext) {
        this.instanceContext = instanceContext;
    }

    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return null;
    }

    public long getBufferRetainedSizeInBytes() {
        return 0L;
    }

    public ListenableFuture<?> isFull() {
        return this.NOT_BLOCKED;
    }

    public void send(TsBlock tsBlock) {
        this.tsBlocks.add(tsBlock);
    }

    public void send(int partition, List<TsBlock> tsBlocks) {
        this.tsBlocks.addAll(tsBlocks);
    }

    public void setNoMoreTsBlocks() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.instanceContext.transitionToFlushing();
    }

    public boolean isAborted() {
        return this.closed;
    }

    public boolean isFinished() {
        return false;
    }

    public void abort() {
        this.closed = true;
        this.tsBlocks.clear();
    }

    public void close() {
        this.closed = true;
        this.tsBlocks.clear();
    }

    public List<TsBlock> getTsBlocks() {
        return this.tsBlocks;
    }
}

