/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange;

import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.mpp.execution.exchange.ISinkHandle;
import org.apache.iotdb.db.mpp.execution.exchange.ISourceHandle;
import org.apache.iotdb.db.mpp.execution.exchange.LocalSinkHandle;
import org.apache.iotdb.db.mpp.execution.exchange.LocalSourceHandle;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.exchange.TsBlockSerdeFactory;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.memory.LocalMemoryManager;
import org.apache.iotdb.db.mpp.execution.memory.MemoryPool;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MPPDataExchangeManagerTest {
    @Test
    public void testCreateLocalSinkHandle() {
        TFragmentInstanceId localFragmentInstanceId = new TFragmentInstanceId("q0", 1, "0");
        TFragmentInstanceId remoteFragmentInstanceId = new TFragmentInstanceId("q0", 0, "0");
        String remotePlanNodeId = "exchange_0";
        FragmentInstanceContext mockFragmentInstanceContext = (FragmentInstanceContext)Mockito.mock(FragmentInstanceContext.class);
        LocalMemoryManager mockLocalMemoryManager = (LocalMemoryManager)Mockito.mock(LocalMemoryManager.class);
        MemoryPool spyMemoryPool = (MemoryPool)Mockito.spy((Object)new MemoryPool("test", 10240L, 5120L));
        Mockito.when((Object)mockLocalMemoryManager.getQueryPool()).thenReturn((Object)spyMemoryPool);
        MPPDataExchangeManager mppDataExchangeManager = new MPPDataExchangeManager(mockLocalMemoryManager, (Supplier)new TsBlockSerdeFactory(), Executors.newSingleThreadExecutor(), new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.SyncDataNodeMPPDataExchangeServiceClientPoolFactory()));
        ISinkHandle localSinkHandle = mppDataExchangeManager.createLocalSinkHandle(localFragmentInstanceId, remoteFragmentInstanceId, "exchange_0", mockFragmentInstanceContext);
        Assert.assertTrue((boolean)(localSinkHandle instanceof LocalSinkHandle));
        ISourceHandle localSourceHandle = mppDataExchangeManager.createLocalSourceHandle(remoteFragmentInstanceId, "exchange_0", localFragmentInstanceId, t -> {});
        Assert.assertTrue((boolean)(localSourceHandle instanceof LocalSourceHandle));
        Assert.assertEquals((Object)((LocalSinkHandle)localSinkHandle).getSharedTsBlockQueue(), (Object)((LocalSourceHandle)localSourceHandle).getSharedTsBlockQueue());
    }

    @Test
    public void testCreateLocalSourceHandle() {
        TFragmentInstanceId remoteFragmentInstanceId = new TFragmentInstanceId("q0", 1, "0");
        TFragmentInstanceId localFragmentInstanceId = new TFragmentInstanceId("q0", 0, "0");
        String localPlanNodeId = "exchange_0";
        FragmentInstanceContext mockFragmentInstanceContext = (FragmentInstanceContext)Mockito.mock(FragmentInstanceContext.class);
        LocalMemoryManager mockLocalMemoryManager = (LocalMemoryManager)Mockito.mock(LocalMemoryManager.class);
        MemoryPool spyMemoryPool = (MemoryPool)Mockito.spy((Object)new MemoryPool("test", 10240L, 5120L));
        Mockito.when((Object)mockLocalMemoryManager.getQueryPool()).thenReturn((Object)spyMemoryPool);
        MPPDataExchangeManager mppDataExchangeManager = new MPPDataExchangeManager(mockLocalMemoryManager, (Supplier)new TsBlockSerdeFactory(), Executors.newSingleThreadExecutor(), new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.SyncDataNodeMPPDataExchangeServiceClientPoolFactory()));
        ISourceHandle localSourceHandle = mppDataExchangeManager.createLocalSourceHandle(localFragmentInstanceId, "exchange_0", remoteFragmentInstanceId, t -> {});
        Assert.assertTrue((boolean)(localSourceHandle instanceof LocalSourceHandle));
        ISinkHandle localSinkHandle = mppDataExchangeManager.createLocalSinkHandle(remoteFragmentInstanceId, localFragmentInstanceId, "exchange_0", mockFragmentInstanceContext);
        Assert.assertTrue((boolean)(localSinkHandle instanceof LocalSinkHandle));
        Assert.assertEquals((Object)((LocalSinkHandle)localSinkHandle).getSharedTsBlockQueue(), (Object)((LocalSourceHandle)localSourceHandle).getSharedTsBlockQueue());
    }
}

