/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import java.util.ArrayList;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.db.mpp.execution.operator.window.TimeWindow;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AccumulatorTest {
    private TsBlock rawData;
    private Statistics statistics;
    private TimeRange defaultTimeRange = new TimeRange(0L, Long.MAX_VALUE);
    private TimeWindow timeWindow = new TimeWindow(this.defaultTimeRange);

    @Before
    public void setUp() {
        this.initInputTsBlock();
    }

    private void initInputTsBlock() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        dataTypes.add(TSDataType.DOUBLE);
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(dataTypes);
        TimeColumnBuilder timeColumnBuilder = tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders = tsBlockBuilder.getValueColumnBuilders();
        for (int i = 0; i < 100; ++i) {
            timeColumnBuilder.writeLong((long)i);
            columnBuilders[0].writeDouble((double)i * 1.0);
            tsBlockBuilder.declarePosition();
        }
        this.rawData = tsBlockBuilder.build();
        this.statistics = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        this.statistics.update(100L, 100.0);
    }

    public Column[] getControlTimeAndValueColumn(IWindow curWindow, int columnIndex) {
        Column[] columns = new Column[]{curWindow.getControlColumn(this.rawData), this.rawData.getTimeColumn(), this.rawData.getColumn(columnIndex)};
        return columns;
    }

    @Test
    public void avgAccumulatorTest() {
        Accumulator avgAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.AVG, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)avgAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)avgAccumulator.getIntermediateType()[1]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)avgAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new LongColumnBuilder(null, 1), new DoubleColumnBuilder(null, 1)};
        avgAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        Assert.assertTrue((boolean)intermediateResult[1].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        avgAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        avgAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        Assert.assertFalse((boolean)avgAccumulator.hasFinalResult());
        intermediateResult[0] = new LongColumnBuilder(null, 1);
        intermediateResult[1] = new DoubleColumnBuilder(null, 1);
        avgAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)100L, (long)intermediateResult[0].build().getLong(0));
        Assert.assertEquals((double)4950.0, (double)intermediateResult[1].build().getDouble(0), (double)0.001);
        avgAccumulator.addIntermediate(new Column[]{intermediateResult[0].build(), intermediateResult[1].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        avgAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)49.5, (double)finalResult.build().getDouble(0), (double)0.001);
        avgAccumulator.reset();
        avgAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        avgAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void countAccumulatorTest() {
        Accumulator countAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.COUNT, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)countAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)countAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new LongColumnBuilder(null, 1)};
        countAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)0L, (long)intermediateResult[0].build().getLong(0));
        LongColumnBuilder finalResult = new LongColumnBuilder(null, 1);
        countAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)0L, (long)finalResult.build().getLong(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        countAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        Assert.assertFalse((boolean)countAccumulator.hasFinalResult());
        intermediateResult[0] = new LongColumnBuilder(null, 1);
        countAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)100L, (long)intermediateResult[0].build().getLong(0));
        countAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new LongColumnBuilder(null, 1);
        countAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)200L, (long)finalResult.build().getLong(0));
        countAccumulator.reset();
        countAccumulator.addStatistics(this.statistics);
        finalResult = new LongColumnBuilder(null, 1);
        countAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)1L, (long)finalResult.build().getLong(0));
    }

    @Test
    public void extremeAccumulatorTest() {
        Accumulator extremeAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.EXTREME, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1)};
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        extremeAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        Assert.assertFalse((boolean)extremeAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)99.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        extremeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)99.0, (double)finalResult.build().getDouble(0), (double)0.001);
        extremeAccumulator.reset();
        extremeAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void firstValueAccumulatorTest() {
        Accumulator firstValueAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.FIRST_VALUE, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)firstValueAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)firstValueAccumulator.getIntermediateType()[1]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)firstValueAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1), new LongColumnBuilder(null, 1)};
        firstValueAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        Assert.assertTrue((boolean)intermediateResult[1].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        firstValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        firstValueAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        Assert.assertTrue((boolean)firstValueAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        intermediateResult[1] = new LongColumnBuilder(null, 1);
        firstValueAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)0.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        Assert.assertEquals((long)0L, (long)intermediateResult[1].build().getLong(0));
        firstValueAccumulator.addIntermediate(new Column[]{intermediateResult[0].build(), intermediateResult[1].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        firstValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)0.0, (double)finalResult.build().getDouble(0), (double)0.001);
        firstValueAccumulator.reset();
        firstValueAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        firstValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void lastValueAccumulatorTest() {
        Accumulator lastValueAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.LAST_VALUE, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)lastValueAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)lastValueAccumulator.getIntermediateType()[1]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)lastValueAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1), new LongColumnBuilder(null, 1)};
        lastValueAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        Assert.assertTrue((boolean)intermediateResult[1].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        lastValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        lastValueAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        intermediateResult[1] = new LongColumnBuilder(null, 1);
        lastValueAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)99.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        Assert.assertEquals((long)99L, (long)intermediateResult[1].build().getLong(0));
        lastValueAccumulator.addIntermediate(new Column[]{intermediateResult[0].build(), intermediateResult[1].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        lastValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)99.0, (double)finalResult.build().getDouble(0), (double)0.001);
        lastValueAccumulator.reset();
        lastValueAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        lastValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void maxTimeAccumulatorTest() {
        Accumulator maxTimeAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.MAX_TIME, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)maxTimeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)maxTimeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new LongColumnBuilder(null, 1)};
        maxTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        LongColumnBuilder finalResult = new LongColumnBuilder(null, 1);
        maxTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        maxTimeAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        Assert.assertFalse((boolean)maxTimeAccumulator.hasFinalResult());
        intermediateResult[0] = new LongColumnBuilder(null, 1);
        maxTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)99L, (long)intermediateResult[0].build().getLong(0));
        maxTimeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new LongColumnBuilder(null, 1);
        maxTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)99L, (long)finalResult.build().getLong(0));
        maxTimeAccumulator.reset();
        maxTimeAccumulator.addStatistics(this.statistics);
        finalResult = new LongColumnBuilder(null, 1);
        maxTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)100L, (long)finalResult.build().getLong(0));
    }

    @Test
    public void minTimeAccumulatorTest() {
        Accumulator minTimeAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.MIN_TIME, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)minTimeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)minTimeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new LongColumnBuilder(null, 1)};
        minTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        LongColumnBuilder finalResult = new LongColumnBuilder(null, 1);
        minTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        minTimeAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        Assert.assertTrue((boolean)minTimeAccumulator.hasFinalResult());
        intermediateResult[0] = new LongColumnBuilder(null, 1);
        minTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)0L, (long)intermediateResult[0].build().getLong(0));
        minTimeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new LongColumnBuilder(null, 1);
        minTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)0L, (long)finalResult.build().getLong(0));
        minTimeAccumulator.reset();
        minTimeAccumulator.addStatistics(this.statistics);
        finalResult = new LongColumnBuilder(null, 1);
        minTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)100L, (long)finalResult.build().getLong(0));
    }

    @Test
    public void maxValueAccumulatorTest() {
        Accumulator extremeAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.MAX_VALUE, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1)};
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        extremeAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        Assert.assertFalse((boolean)extremeAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)99.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        extremeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)99.0, (double)finalResult.build().getDouble(0), (double)0.001);
        extremeAccumulator.reset();
        extremeAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void minValueAccumulatorTest() {
        Accumulator extremeAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.MIN_VALUE, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1)};
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        extremeAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        Assert.assertFalse((boolean)extremeAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)0.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        extremeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)0.0, (double)finalResult.build().getDouble(0), (double)0.001);
        extremeAccumulator.reset();
        extremeAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void sumAccumulatorTest() {
        Accumulator sumAccumulator = AccumulatorFactory.createAccumulator((AggregationType)AggregationType.SUM, (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)sumAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)sumAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1)};
        sumAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        sumAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] controlTimeAndValueColumn = this.getControlTimeAndValueColumn((IWindow)this.timeWindow, 0);
        sumAccumulator.addInput(controlTimeAndValueColumn, (IWindow)this.timeWindow);
        Assert.assertFalse((boolean)sumAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        sumAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)4950.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        sumAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        sumAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)9900.0, (double)finalResult.build().getDouble(0), (double)0.001);
        sumAccumulator.reset();
        sumAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        sumAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }
}

