/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.ActivateTemplateInClusterPlanImpl;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.CreateTimeSeriesPlanImpl;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.DeactivateTemplatePlanImpl;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.PreDeactivateTemplatePlanImpl;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.RollbackPreDeactivateTemplatePlanImpl;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IRollbackPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class SchemaRegionBasicTest {
    IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    boolean isClusterMode;

    @Before
    public void setUp() {
        this.isClusterMode = this.config.isClusterMode();
        this.config.setClusterMode(true);
        IoTDB.configManager.init();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        this.config.setClusterMode(this.isClusterMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRatisModeSnapshot() throws Exception {
        String schemaRegionConsensusProtocolClass = this.config.getSchemaRegionConsensusProtocolClass();
        this.config.setSchemaRegionConsensusProtocolClass("org.apache.iotdb.consensus.ratis.RatisConsensus");
        try {
            PartialPath storageGroup = new PartialPath("root.sg");
            SchemaRegionId schemaRegionId = new SchemaRegionId(0);
            SchemaEngine.getInstance().createSchemaRegion(storageGroup, schemaRegionId);
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
            File mLogFile = SystemFileFactory.INSTANCE.getFile(schemaRegion.getStorageGroupFullPath() + File.separator + schemaRegion.getSchemaRegionId().getId(), "mlog.bin");
            Assert.assertFalse((boolean)mLogFile.exists());
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tag-key", "tag-value");
            schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlan(new PartialPath("root.sg.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null, tags, null, null), -1L);
            File snapshotDir = new File(this.config.getSchemaDir() + File.separator + "snapshot");
            snapshotDir.mkdir();
            schemaRegion.createSnapshot(snapshotDir);
            schemaRegion.loadSnapshot(snapshotDir);
            Pair result = schemaRegion.showTimeseries(new ShowTimeSeriesPlan(new PartialPath("root.sg.**"), false, "tag-key", "tag-value", 0, 0, false), null);
            ShowTimeSeriesResult seriesResult = (ShowTimeSeriesResult)((List)result.left).get(0);
            Assert.assertEquals((Object)new PartialPath("root.sg.d1.s1").getFullPath(), (Object)seriesResult.getName());
            Map resultTagMap = seriesResult.getTag();
            Assert.assertEquals((long)1L, (long)resultTagMap.size());
            Assert.assertEquals((Object)"tag-value", resultTagMap.get("tag-key"));
            IoTDB.configManager.clear();
            IoTDB.configManager.init();
            SchemaEngine.getInstance().createSchemaRegion(storageGroup, schemaRegionId);
            ISchemaRegion newSchemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
            newSchemaRegion.loadSnapshot(snapshotDir);
            result = newSchemaRegion.showTimeseries(new ShowTimeSeriesPlan(new PartialPath("root.sg.**"), false, "tag-key", "tag-value", 0, 0, false), null);
            seriesResult = (ShowTimeSeriesResult)((List)result.left).get(0);
            Assert.assertEquals((Object)new PartialPath("root.sg.d1.s1").getFullPath(), (Object)seriesResult.getName());
            resultTagMap = seriesResult.getTag();
            Assert.assertEquals((long)1L, (long)resultTagMap.size());
            Assert.assertEquals((Object)"tag-value", resultTagMap.get("tag-key"));
        }
        finally {
            this.config.setSchemaRegionConsensusProtocolClass(schemaRegionConsensusProtocolClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testSnapshotPerformance() throws Exception {
        String schemaRegionConsensusProtocolClass = this.config.getSchemaRegionConsensusProtocolClass();
        this.config.setSchemaRegionConsensusProtocolClass("org.apache.iotdb.consensus.ratis.RatisConsensus");
        try {
            PartialPath storageGroup = new PartialPath("root.sg");
            SchemaRegionId schemaRegionId = new SchemaRegionId(0);
            SchemaEngine.getInstance().createSchemaRegion(storageGroup, schemaRegionId);
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tag-key", "tag-value");
            long time = System.currentTimeMillis();
            for (int i = 0; i < 1000; ++i) {
                for (int j = 0; j < 1000; ++j) {
                    schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlan(new PartialPath("root.sg.d" + i + ".s" + j), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null, tags, null, null), -1L);
                }
            }
            System.out.println("Timeseries creation costs " + (System.currentTimeMillis() - time) + "ms.");
            File snapshotDir = new File(this.config.getSchemaDir() + File.separator + "snapshot");
            snapshotDir.mkdir();
            schemaRegion.createSnapshot(snapshotDir);
            schemaRegion.loadSnapshot(snapshotDir);
        }
        finally {
            this.config.setSchemaRegionConsensusProtocolClass(schemaRegionConsensusProtocolClass);
        }
    }

    @Test
    public void testFetchSchema() throws Exception {
        PartialPath storageGroup = new PartialPath("root.sg");
        SchemaRegionId schemaRegionId = new SchemaRegionId(0);
        SchemaEngine.getInstance().createSchemaRegion(storageGroup, schemaRegionId);
        ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt01.status"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt01.temperature"), TSDataType.FLOAT, TSEncoding.RLE, CompressionType.GZIP, null, (Map)new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
                this.put("tag2", "t2");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
                this.put("attr2", "a2");
            }
        }, "temp"), -1L);
        List schemas = schemaRegion.fetchSchema(new PartialPath("root.sg.wf01.wt01.*"), Collections.EMPTY_MAP, true);
        Assert.assertEquals((long)schemas.size(), (long)2L);
        for (MeasurementPath measurementPath : schemas) {
            if (measurementPath.getFullPath().equals("root.sg.wf01.wt01.status")) {
                Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)measurementPath.getMeasurementAlias()));
                Assert.assertEquals((long)0L, (long)measurementPath.getTagMap().size());
                Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)measurementPath.getMeasurementSchema().getType());
                Assert.assertEquals((Object)TSEncoding.PLAIN, (Object)measurementPath.getMeasurementSchema().getEncodingType());
                Assert.assertEquals((Object)CompressionType.SNAPPY, (Object)measurementPath.getMeasurementSchema().getCompressor());
                continue;
            }
            if (measurementPath.getFullPath().equals("root.sg.wf01.wt01.temperature")) {
                Assert.assertEquals((Object)"", (Object)measurementPath.getMeasurementAlias());
                Assert.assertEquals((long)2L, (long)measurementPath.getTagMap().size());
                Assert.assertEquals((Object)TSDataType.FLOAT, (Object)measurementPath.getMeasurementSchema().getType());
                Assert.assertEquals((Object)TSEncoding.RLE, (Object)measurementPath.getMeasurementSchema().getEncodingType());
                Assert.assertEquals((Object)CompressionType.GZIP, (Object)measurementPath.getMeasurementSchema().getCompressor());
                continue;
            }
            Assert.fail((String)("Unexpected MeasurementPath " + measurementPath));
        }
        schemas = schemaRegion.fetchSchema(new PartialPath("root.sg.wf01.wt01.temp"), Collections.EMPTY_MAP, false);
        Assert.assertEquals((long)schemas.size(), (long)1L);
        Assert.assertEquals((Object)"root.sg.wf01.wt01.temperature", (Object)((MeasurementPath)schemas.get(0)).getFullPath());
        Assert.assertEquals((Object)"temp", (Object)((MeasurementPath)schemas.get(0)).getMeasurementAlias());
        Assert.assertNull((Object)((MeasurementPath)schemas.get(0)).getTagMap());
        Assert.assertEquals((Object)TSDataType.FLOAT, (Object)((MeasurementPath)schemas.get(0)).getMeasurementSchema().getType());
        Assert.assertEquals((Object)TSEncoding.RLE, (Object)((MeasurementPath)schemas.get(0)).getMeasurementSchema().getEncodingType());
        Assert.assertEquals((Object)CompressionType.GZIP, (Object)((MeasurementPath)schemas.get(0)).getMeasurementSchema().getCompressor());
    }

    @Test
    public void testCheckMeasurementExistence() throws Exception {
        PartialPath storageGroup = new PartialPath("root.sg");
        SchemaRegionId schemaRegionId = new SchemaRegionId(0);
        SchemaEngine.getInstance().createSchemaRegion(storageGroup, schemaRegionId);
        ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt01.status"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt01.v1.s1"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt01.temperature"), TSDataType.FLOAT, TSEncoding.RLE, CompressionType.GZIP, null, (Map)new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
                this.put("tag2", "t2");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
                this.put("attr2", "a2");
            }
        }, "temp"), -1L);
        Map res1 = schemaRegion.checkMeasurementExistence(new PartialPath("root.sg.wf01.wt01"), IntStream.range(0, 5).mapToObj(i -> "s" + i).collect(Collectors.toList()), IntStream.range(0, 5).mapToObj(i -> "alias" + i).collect(Collectors.toList()));
        Assert.assertEquals((long)0L, (long)res1.size());
        Map res2 = schemaRegion.checkMeasurementExistence(new PartialPath("root.sg.wf01"), Collections.singletonList("wt01"), Collections.singletonList("alias1"));
        Assert.assertEquals((long)0L, (long)res2.size());
        Map res3 = schemaRegion.checkMeasurementExistence(new PartialPath("root.sg.wf01.wt01"), Arrays.asList("status", "s1", "v1"), Arrays.asList("", "temp", ""));
        Assert.assertEquals((long)3L, (long)res3.size());
        Assert.assertTrue((boolean)(res3.get(0) instanceof MeasurementAlreadyExistException));
        Assert.assertTrue((boolean)(res3.get(1) instanceof AliasAlreadyExistException));
        Assert.assertTrue((boolean)(res3.get(2) instanceof PathAlreadyExistException));
    }

    @Test
    public void testConstructSchemaBlackList() throws Exception {
        PartialPath storageGroup = new PartialPath("root.sg");
        SchemaRegionId schemaRegionId = new SchemaRegionId(0);
        SchemaEngine.getInstance().createSchemaRegion(storageGroup, schemaRegionId);
        ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt01.status"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt02.status"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt01.temperature"), TSDataType.FLOAT, TSEncoding.RLE, CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf02.wt01.temperature"), TSDataType.FLOAT, TSEncoding.RLE, CompressionType.SNAPPY, null, null, null, null), -1L);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.wf01.wt01.*"));
        patternTree.appendPathPattern(new PartialPath("root.sg.wf01.*.status"));
        patternTree.appendPathPattern(new PartialPath("root.sg.wf02.wt01.temperature"));
        patternTree.constructTree();
        Assert.assertTrue((schemaRegion.constructSchemaBlackList(patternTree) >= 3L ? 1 : 0) != 0);
        Assert.assertEquals(new HashSet<PartialPath>(Arrays.asList(new PartialPath("root.sg.wf01.wt01.*"), new PartialPath("root.sg.wf01.wt02.status"), new PartialPath("root.sg.wf01.wt01.status"), new PartialPath("root.sg.wf02.wt01.temperature"))), (Object)schemaRegion.fetchSchemaBlackList(patternTree));
        PathPatternTree rollbackTree = new PathPatternTree();
        rollbackTree.appendPathPattern(new PartialPath("root.sg.wf02.wt01.temperature"));
        rollbackTree.constructTree();
        schemaRegion.rollbackSchemaBlackList(rollbackTree);
        Assert.assertEquals(new HashSet<PartialPath>(Arrays.asList(new PartialPath("root.sg.wf01.wt01.*"), new PartialPath("root.sg.wf01.wt02.status"), new PartialPath("root.sg.wf01.wt01.status"))), (Object)schemaRegion.fetchSchemaBlackList(patternTree));
        schemaRegion.deleteTimeseriesInBlackList(patternTree);
        List schemas = schemaRegion.fetchSchema(new PartialPath("root.**"), Collections.EMPTY_MAP, false);
        Assert.assertEquals((long)1L, (long)schemas.size());
        Assert.assertEquals((Object)"root.sg.wf02.wt01.temperature", (Object)((MeasurementPath)schemas.get(0)).getFullPath());
    }

    @Test
    public void testActivateSchemaTemplate() throws Exception {
        PartialPath storageGroup = new PartialPath("root.sg");
        SchemaRegionId schemaRegionId = new SchemaRegionId(0);
        SchemaEngine.getInstance().createSchemaRegion(storageGroup, schemaRegionId);
        ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt01.status"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null), -1L);
        int templateId = 1;
        Template template = new Template(new CreateSchemaTemplateStatement("t1", (String[][])new String[][]{{"s1"}, {"s2"}}, (TSDataType[][])new TSDataType[][]{{TSDataType.DOUBLE}, {TSDataType.INT32}}, (TSEncoding[][])new TSEncoding[][]{{TSEncoding.RLE}, {TSEncoding.RLE}}, (CompressionType[][])new CompressionType[][]{{CompressionType.SNAPPY}, {CompressionType.SNAPPY}}));
        template.setId(templateId);
        schemaRegion.activateSchemaTemplate((IActivateTemplateInClusterPlan)new ActivateTemplateInClusterPlanImpl(new PartialPath("root.sg.wf01.wt01"), 3, templateId), template);
        schemaRegion.activateSchemaTemplate((IActivateTemplateInClusterPlan)new ActivateTemplateInClusterPlanImpl(new PartialPath("root.sg.wf02"), 2, templateId), template);
        HashSet<String> expectedPaths = new HashSet<String>(Arrays.asList("root.sg.wf01.wt01", "root.sg.wf02"));
        HashSet pathsUsingTemplate = new HashSet(schemaRegion.getPathsUsingTemplate(new PartialPath("root.**"), templateId));
        Assert.assertEquals(expectedPaths, pathsUsingTemplate);
        PathPatternTree allPatternTree = new PathPatternTree();
        allPatternTree.appendPathPattern(new PartialPath("root.**"));
        allPatternTree.constructTree();
        Assert.assertEquals((long)2L, (long)schemaRegion.countPathsUsingTemplate(templateId, allPatternTree));
        PathPatternTree wf01PatternTree = new PathPatternTree();
        wf01PatternTree.appendPathPattern(new PartialPath("root.sg.wf01.*"));
        wf01PatternTree.constructTree();
        Assert.assertEquals((long)1L, (long)schemaRegion.countPathsUsingTemplate(templateId, wf01PatternTree));
        Assert.assertEquals((Object)"root.sg.wf01.wt01", schemaRegion.getPathsUsingTemplate(new PartialPath("root.sg.wf01.*"), templateId).get(0));
        PathPatternTree wf02PatternTree = new PathPatternTree();
        wf02PatternTree.appendPathPattern(new PartialPath("root.sg.wf02"));
        wf02PatternTree.constructTree();
        Assert.assertEquals((long)1L, (long)schemaRegion.countPathsUsingTemplate(templateId, wf02PatternTree));
        Assert.assertEquals((Object)"root.sg.wf02", schemaRegion.getPathsUsingTemplate(new PartialPath("root.sg.wf02"), templateId).get(0));
    }

    @Test
    public void testDeactivateTemplate() throws Exception {
        PartialPath storageGroup = new PartialPath("root.sg");
        SchemaRegionId schemaRegionId = new SchemaRegionId(0);
        SchemaEngine.getInstance().createSchemaRegion(storageGroup, schemaRegionId);
        ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)new CreateTimeSeriesPlanImpl(new PartialPath("root.sg.wf01.wt01.status"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null), -1L);
        int templateId = 1;
        Template template = new Template(new CreateSchemaTemplateStatement("t1", (String[][])new String[][]{{"s1"}, {"s2"}}, (TSDataType[][])new TSDataType[][]{{TSDataType.DOUBLE}, {TSDataType.INT32}}, (TSEncoding[][])new TSEncoding[][]{{TSEncoding.RLE}, {TSEncoding.RLE}}, (CompressionType[][])new CompressionType[][]{{CompressionType.SNAPPY}, {CompressionType.SNAPPY}}));
        template.setId(templateId);
        schemaRegion.activateSchemaTemplate((IActivateTemplateInClusterPlan)new ActivateTemplateInClusterPlanImpl(new PartialPath("root.sg.wf01.wt01"), 3, templateId), template);
        schemaRegion.activateSchemaTemplate((IActivateTemplateInClusterPlan)new ActivateTemplateInClusterPlanImpl(new PartialPath("root.sg.wf02"), 2, templateId), template);
        HashMap<PartialPath, List<Integer>> allDeviceTemplateMap = new HashMap<PartialPath, List<Integer>>();
        allDeviceTemplateMap.put(new PartialPath("root.**"), Collections.singletonList(templateId));
        schemaRegion.constructSchemaBlackListWithTemplate((IPreDeactivateTemplatePlan)new PreDeactivateTemplatePlanImpl(allDeviceTemplateMap));
        HashMap<PartialPath, List<Integer>> wf02TemplateMap = new HashMap<PartialPath, List<Integer>>();
        wf02TemplateMap.put(new PartialPath("root.sg.wf02"), Collections.singletonList(templateId));
        schemaRegion.rollbackSchemaBlackListWithTemplate((IRollbackPreDeactivateTemplatePlan)new RollbackPreDeactivateTemplatePlanImpl(wf02TemplateMap));
        schemaRegion.deactivateTemplateInBlackList((IDeactivateTemplatePlan)new DeactivateTemplatePlanImpl(allDeviceTemplateMap));
        List<String> expectedPaths = Collections.singletonList("root.sg.wf02");
        List pathsUsingTemplate = schemaRegion.getPathsUsingTemplate(new PartialPath("root.**"), templateId);
        Assert.assertEquals(expectedPaths, (Object)pathsUsingTemplate);
        PathPatternTree allPatternTree = new PathPatternTree();
        allPatternTree.appendPathPattern(new PartialPath("root.**"));
        allPatternTree.constructTree();
        Assert.assertEquals((long)1L, (long)schemaRegion.countPathsUsingTemplate(templateId, allPatternTree));
    }
}

