/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.plan;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.plan.schemaregion.SchemaRegionPlanType;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.SchemaRegionPlanDeserializer;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IAutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IChangeAliasPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IChangeTagOffsetPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IDeleteTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IRollbackPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplateInClusterPlan;
import org.apache.iotdb.db.qp.physical.sys.AutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.PreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.RollbackPreDeleteTimeSeriesPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class SchemaRegionPlanCompatibilityTest {
    private static final SchemaRegionPlanDeserializer DESERIALIZER = new SchemaRegionPlanDeserializer();
    private static final ByteBuffer BUFFER = ByteBuffer.allocate(1024);

    private static int serializeToBuffer(PhysicalPlan oldPlan) {
        BUFFER.clear();
        oldPlan.serialize(BUFFER);
        int position = BUFFER.position();
        BUFFER.flip();
        return position;
    }

    private static <T> T deserializeFromBuffer() {
        return (T)DESERIALIZER.deserialize(BUFFER);
    }

    private static int getCurrentBufferPosition() {
        return BUFFER.position();
    }

    @Test
    public void testPlanTypeCompatibility() {
        String[] typeNames;
        for (String typeName : typeNames = new String[]{"CREATE_TIMESERIES", "DELETE_TIMESERIES", "CHANGE_TAG_OFFSET", "CHANGE_ALIAS", "AUTO_CREATE_DEVICE_MNODE", "CREATE_ALIGNED_TIMESERIES", "ACTIVATE_TEMPLATE_IN_CLUSTER", "PRE_DELETE_TIMESERIES_IN_CLUSTER", "ROLLBACK_PRE_DELETE_TIMESERIES"}) {
            Assert.assertEquals((long)SchemaRegionPlanType.valueOf((String)typeName).getPlanType(), (long)PhysicalPlan.PhysicalPlanType.valueOf((String)typeName).ordinal());
        }
    }

    @Test
    public void testActivateTemplateInClusterPlanSerializationCompatibility() throws IllegalPathException {
        ActivateTemplateInClusterPlan oldPlan = new ActivateTemplateInClusterPlan();
        oldPlan.setActivatePath(new PartialPath("root.sg.d"));
        oldPlan.setTemplateSetLevel(1);
        oldPlan.setAligned(true);
        oldPlan.setTemplateId(1);
        int position = SchemaRegionPlanCompatibilityTest.serializeToBuffer((PhysicalPlan)oldPlan);
        IActivateTemplateInClusterPlan newPlan = (IActivateTemplateInClusterPlan)SchemaRegionPlanCompatibilityTest.deserializeFromBuffer();
        Assert.assertEquals((Object)oldPlan.getActivatePath(), (Object)newPlan.getActivatePath());
        Assert.assertEquals((long)oldPlan.getTemplateSetLevel(), (long)newPlan.getTemplateSetLevel());
        Assert.assertEquals((long)oldPlan.getTemplateId(), (long)newPlan.getTemplateId());
        Assert.assertEquals((Object)oldPlan.isAligned(), (Object)newPlan.isAligned());
        Assert.assertEquals((long)position, (long)SchemaRegionPlanCompatibilityTest.getCurrentBufferPosition());
    }

    @Test
    public void testAutoCreateDeviceMNodePlanSerializationCompatibility() throws IllegalPathException {
        AutoCreateDeviceMNodePlan oldPlan = new AutoCreateDeviceMNodePlan();
        oldPlan.setPath(new PartialPath("root.sg.d"));
        int position = SchemaRegionPlanCompatibilityTest.serializeToBuffer((PhysicalPlan)oldPlan);
        IAutoCreateDeviceMNodePlan newPlan = (IAutoCreateDeviceMNodePlan)SchemaRegionPlanCompatibilityTest.deserializeFromBuffer();
        Assert.assertEquals((Object)oldPlan.getPath(), (Object)newPlan.getPath());
        Assert.assertEquals((long)position, (long)SchemaRegionPlanCompatibilityTest.getCurrentBufferPosition());
    }

    @Test
    public void testChangeAliasPlanSerializationCompatibility() throws IllegalPathException {
        ChangeAliasPlan oldPlan = new ChangeAliasPlan();
        oldPlan.setPath(new PartialPath("root.sg.d.s"));
        oldPlan.setAlias("alias");
        int position = SchemaRegionPlanCompatibilityTest.serializeToBuffer((PhysicalPlan)oldPlan);
        IChangeAliasPlan newPlan = (IChangeAliasPlan)SchemaRegionPlanCompatibilityTest.deserializeFromBuffer();
        Assert.assertEquals((Object)oldPlan.getPath(), (Object)newPlan.getPath());
        Assert.assertEquals((Object)oldPlan.getAlias(), (Object)newPlan.getAlias());
        Assert.assertEquals((long)position, (long)SchemaRegionPlanCompatibilityTest.getCurrentBufferPosition());
    }

    @Test
    public void testChangeTagOffsetPlanSerializationCompatibility() throws IllegalPathException {
        ChangeTagOffsetPlan oldPlan = new ChangeTagOffsetPlan();
        oldPlan.setPath(new PartialPath("root.sg.d.s"));
        oldPlan.setOffset(10L);
        int position = SchemaRegionPlanCompatibilityTest.serializeToBuffer((PhysicalPlan)oldPlan);
        IChangeTagOffsetPlan newPlan = (IChangeTagOffsetPlan)SchemaRegionPlanCompatibilityTest.deserializeFromBuffer();
        Assert.assertEquals((Object)oldPlan.getPath(), (Object)newPlan.getPath());
        Assert.assertEquals((long)oldPlan.getOffset(), (long)newPlan.getOffset());
        Assert.assertEquals((long)position, (long)SchemaRegionPlanCompatibilityTest.getCurrentBufferPosition());
    }

    @Test
    public void testCreateAlignedTimeSeriesPlanSerializationCompatibility() throws IllegalPathException {
        CreateAlignedTimeSeriesPlan oldPlan = new CreateAlignedTimeSeriesPlan();
        oldPlan.setDevicePath(new PartialPath("root.sg.d"));
        oldPlan.setMeasurements(Arrays.asList("s1", "s2"));
        oldPlan.setDataTypes(Arrays.asList(TSDataType.INT32, TSDataType.FLOAT));
        oldPlan.setEncodings(Arrays.asList(TSEncoding.GORILLA, TSEncoding.BITMAP));
        oldPlan.setCompressors(Arrays.asList(CompressionType.SNAPPY, CompressionType.GZIP));
        oldPlan.setAliasList(Arrays.asList("status", "temperature"));
        HashMap<String, String> tagMap = new HashMap<String, String>();
        tagMap.put("tag-key", "tag-value");
        oldPlan.setTagsList(Arrays.asList(null, tagMap));
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("attribute-key", "attribute-value");
        oldPlan.setAttributesList(Arrays.asList(attributeMap, null));
        oldPlan.setTagOffsets(Arrays.asList(10L, 20L));
        int position = SchemaRegionPlanCompatibilityTest.serializeToBuffer((PhysicalPlan)oldPlan);
        ICreateAlignedTimeSeriesPlan newPlan = (ICreateAlignedTimeSeriesPlan)SchemaRegionPlanCompatibilityTest.deserializeFromBuffer();
        Assert.assertEquals((Object)oldPlan.getDevicePath(), (Object)newPlan.getDevicePath());
        Assert.assertEquals((Object)oldPlan.getMeasurements(), (Object)newPlan.getMeasurements());
        Assert.assertEquals((Object)oldPlan.getDataTypes(), (Object)newPlan.getDataTypes());
        Assert.assertEquals((Object)oldPlan.getEncodings(), (Object)newPlan.getEncodings());
        Assert.assertEquals((Object)oldPlan.getCompressors(), (Object)newPlan.getCompressors());
        Assert.assertEquals((Object)oldPlan.getAliasList(), (Object)newPlan.getAliasList());
        Assert.assertEquals((Object)oldPlan.getTagsList(), (Object)newPlan.getTagsList());
        Assert.assertEquals((Object)oldPlan.getAttributesList(), (Object)newPlan.getAttributesList());
        Assert.assertEquals((Object)oldPlan.getTagOffsets(), (Object)newPlan.getTagOffsets());
        Assert.assertEquals((long)position, (long)SchemaRegionPlanCompatibilityTest.getCurrentBufferPosition());
    }

    @Test
    public void testCreateTimeSeriesPlanSerializationCompatibility() throws IllegalPathException {
        CreateTimeSeriesPlan oldPlan = new CreateTimeSeriesPlan();
        oldPlan.setPath(new PartialPath("root.sg.d.s"));
        oldPlan.setDataType(TSDataType.DOUBLE);
        oldPlan.setEncoding(TSEncoding.FREQ);
        oldPlan.setCompressor(CompressionType.UNCOMPRESSED);
        oldPlan.setAlias(null);
        HashMap<String, String> tagMap = new HashMap<String, String>();
        tagMap.put("tag-key", "tag-value");
        oldPlan.setTags(tagMap);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("attribute-key", "attribute-value");
        oldPlan.setAttributes(attributeMap);
        oldPlan.setTagOffset(30L);
        int position = SchemaRegionPlanCompatibilityTest.serializeToBuffer((PhysicalPlan)oldPlan);
        ICreateTimeSeriesPlan newPlan = (ICreateTimeSeriesPlan)SchemaRegionPlanCompatibilityTest.deserializeFromBuffer();
        Assert.assertEquals((Object)oldPlan.getPath(), (Object)newPlan.getPath());
        Assert.assertEquals((Object)oldPlan.getDataType(), (Object)newPlan.getDataType());
        Assert.assertEquals((Object)oldPlan.getEncoding(), (Object)newPlan.getEncoding());
        Assert.assertEquals((Object)oldPlan.getCompressor(), (Object)newPlan.getCompressor());
        Assert.assertEquals((Object)oldPlan.getAlias(), (Object)newPlan.getAlias());
        Assert.assertEquals((Object)oldPlan.getTags(), (Object)newPlan.getTags());
        Assert.assertEquals((Object)oldPlan.getAttributes(), (Object)newPlan.getAttributes());
        Assert.assertEquals((long)oldPlan.getTagOffset(), (long)newPlan.getTagOffset());
        Assert.assertEquals((long)position, (long)SchemaRegionPlanCompatibilityTest.getCurrentBufferPosition());
    }

    @Test
    public void testDeleteTimeSeriesPlanSerializationCompatibility() throws IllegalPathException {
        DeleteTimeSeriesPlan oldPlan = new DeleteTimeSeriesPlan();
        oldPlan.setDeletePathList(Arrays.asList(new PartialPath("root.sg.*.s"), new PartialPath("root.**.d.s")));
        int position = SchemaRegionPlanCompatibilityTest.serializeToBuffer((PhysicalPlan)oldPlan);
        IDeleteTimeSeriesPlan newPlan = (IDeleteTimeSeriesPlan)SchemaRegionPlanCompatibilityTest.deserializeFromBuffer();
        Assert.assertEquals((Object)oldPlan.getDeletePathList(), (Object)newPlan.getDeletePathList());
        Assert.assertEquals((long)position, (long)SchemaRegionPlanCompatibilityTest.getCurrentBufferPosition());
    }

    @Test
    public void testPreDeleteTimeSeriesSerializationCompatibility() throws IllegalPathException {
        PreDeleteTimeSeriesPlan oldPlan = new PreDeleteTimeSeriesPlan();
        oldPlan.setPath(new PartialPath("root.**.s"));
        int position = SchemaRegionPlanCompatibilityTest.serializeToBuffer((PhysicalPlan)oldPlan);
        IPreDeleteTimeSeriesPlan newPlan = (IPreDeleteTimeSeriesPlan)SchemaRegionPlanCompatibilityTest.deserializeFromBuffer();
        Assert.assertEquals((Object)oldPlan.getPath(), (Object)newPlan.getPath());
        Assert.assertEquals((long)position, (long)SchemaRegionPlanCompatibilityTest.getCurrentBufferPosition());
    }

    @Test
    public void testRollbackPreDeleteTimeSeriesSerializationCompatibility() throws IllegalPathException {
        RollbackPreDeleteTimeSeriesPlan oldPlan = new RollbackPreDeleteTimeSeriesPlan();
        oldPlan.setPath(new PartialPath("root.sg.**"));
        int position = SchemaRegionPlanCompatibilityTest.serializeToBuffer((PhysicalPlan)oldPlan);
        IRollbackPreDeleteTimeSeriesPlan newPlan = (IRollbackPreDeleteTimeSeriesPlan)SchemaRegionPlanCompatibilityTest.deserializeFromBuffer();
        Assert.assertEquals((Object)oldPlan.getPath(), (Object)newPlan.getPath());
        Assert.assertEquals((long)position, (long)SchemaRegionPlanCompatibilityTest.getCurrentBufferPosition());
    }
}

