/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.path;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.metadata.path.PatternTreeMapFactory;
import org.junit.Assert;
import org.junit.Test;

public class PatternTreeMapTest {
    @Test
    public void stringAppendPatternTreeMapTest() throws IllegalPathException {
        PatternTreeMap patternTreeMap = PatternTreeMapFactory.getTriggerPatternTreeMap();
        patternTreeMap.append(new PartialPath("root.sg1.d1.s1"), (Object)"A");
        patternTreeMap.append(new PartialPath("root.**.s1"), (Object)"B");
        patternTreeMap.append(new PartialPath("root.sg1.*.s1"), (Object)"C");
        patternTreeMap.append(new PartialPath("root.sg1.d1.s1"), (Object)"D");
        patternTreeMap.append(new PartialPath("root.sg1.**"), (Object)"E");
        patternTreeMap.append(new PartialPath("root.sg1.**.s2"), (Object)"F");
        patternTreeMap.append(new PartialPath("root.**.d1.*"), (Object)"G");
        patternTreeMap.append(new PartialPath("root.**.d1.**"), (Object)"H");
        patternTreeMap.append(new PartialPath("root.*.d1.**"), (Object)"I");
        patternTreeMap.append(new PartialPath("root.**"), (Object)"J");
        patternTreeMap.append(new PartialPath("root.**.**"), (Object)"K");
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg1.d1.s1"), Arrays.asList("A", "B", "C", "D", "E", "G", "H", "I", "J", "K"));
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg2.s1"), Arrays.asList("B", "J", "K"));
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg1.d1.s2"), Arrays.asList("E", "F", "G", "H", "I", "J", "K"));
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg1.d1.v1.s1"), Arrays.asList("B", "E", "H", "I", "J", "K"));
        this.checkOverlappedByDeviceMeasurements(patternTreeMap, new PartialPath("root.sg1.d1"), Arrays.asList("s1", "s2"), Arrays.asList(Arrays.asList("A", "B", "C", "D", "E", "G", "H", "I", "J", "K"), Arrays.asList("E", "F", "G", "H", "I", "J", "K")));
        this.checkOverlappedByDeviceMeasurements(patternTreeMap, new PartialPath("root.sg1.d2"), Arrays.asList("s1", "s2"), Arrays.asList(Arrays.asList("B", "C", "E", "J", "K"), Arrays.asList("E", "F", "J", "K")));
        patternTreeMap.delete(new PartialPath("root.**.d1.*"), (Object)"G");
        patternTreeMap.delete(new PartialPath("root.sg1.d1.s1"), (Object)"D");
        patternTreeMap.delete(new PartialPath("root.**"), (Object)"J");
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg1.d1.s1"), Arrays.asList("A", "B", "C", "E", "H", "I", "K"));
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg1.d1.s2"), Arrays.asList("E", "F", "H", "I", "K"));
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg1.d1.v1.s1"), Arrays.asList("B", "E", "H", "I", "K"));
        this.checkOverlappedByDeviceMeasurements(patternTreeMap, new PartialPath("root.sg1.d1"), Arrays.asList("s1", "s2"), Arrays.asList(Arrays.asList("A", "B", "C", "E", "H", "I", "K"), Arrays.asList("E", "F", "H", "I", "K")));
        this.checkOverlappedByDeviceMeasurements(patternTreeMap, new PartialPath("root.sg1.d2"), Arrays.asList("s1", "s2"), Arrays.asList(Arrays.asList("B", "C", "E", "K"), Arrays.asList("E", "F", "K")));
        this.checkOverlappedByDeviceMeasurements(patternTreeMap, new PartialPath("root.sg1.v1.d1"), Arrays.asList("s1", "s2"), Arrays.asList(Arrays.asList("B", "E", "H", "K"), Arrays.asList("E", "F", "H", "K")));
    }

    @Test
    public void modificationPatternTreeMapTest() throws IllegalPathException {
        PatternTreeMap patternTreeMap = PatternTreeMapFactory.getModsPatternTreeMap();
        patternTreeMap.append(new PartialPath("root.sg1.d1.s1"), (Object)new Deletion(new PartialPath("root.sg1.d1.s1"), 1L, 1L, 3L));
        patternTreeMap.append(new PartialPath("root.sg1.d1.s1"), (Object)new Deletion(new PartialPath("root.sg1.d1.s1"), 1L, 6L, 10L));
        patternTreeMap.append(new PartialPath("root.**.s1"), (Object)new Deletion(new PartialPath("root.**.s1"), 5L, 10L, 100L));
        patternTreeMap.append(new PartialPath("root.**.s1"), (Object)new Deletion(new PartialPath("root.**.s1"), 10L, 100L, 200L));
        patternTreeMap.append(new PartialPath("root.**"), (Object)new Deletion(new PartialPath("root.**"), 5L, 10L, 100L));
        patternTreeMap.append(new PartialPath("root.**"), (Object)new Deletion(new PartialPath("root.**"), 5L, 10L, 100L));
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg1.d1.s1"), Arrays.asList(new Deletion(new PartialPath("root.sg1.d1.s1"), 1L, 1L, 3L), new Deletion(new PartialPath("root.sg1.d1.s1"), 1L, 6L, 10L), new Deletion(new PartialPath("root.**.s1"), 5L, 10L, 100L), new Deletion(new PartialPath("root.**.s1"), 10L, 100L, 200L), new Deletion(new PartialPath("root.**"), 5L, 10L, 100L)));
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg1.d2.s1"), Arrays.asList(new Deletion(new PartialPath("root.**.s1"), 5L, 10L, 100L), new Deletion(new PartialPath("root.**.s1"), 10L, 100L, 200L), new Deletion(new PartialPath("root.**"), 5L, 10L, 100L)));
        this.checkOverlapped(patternTreeMap, new PartialPath("root.sg1.d1.s2"), Collections.singletonList(new Deletion(new PartialPath("root.**"), 5L, 10L, 100L)));
    }

    private <T> void checkOverlapped(PatternTreeMap<T, ?> patternTreeMap, PartialPath partialPath, List<T> expectedList) {
        HashSet resultSet = new HashSet(patternTreeMap.getOverlapped(partialPath));
        Assert.assertEquals((long)expectedList.size(), (long)resultSet.size());
        for (T o : expectedList) {
            Assert.assertTrue((boolean)resultSet.contains(o));
        }
    }

    private <T> void checkOverlappedByDeviceMeasurements(PatternTreeMap<T, ?> patternTreeMap, PartialPath devicePath, List<String> measurements, List<List<T>> expectedList) {
        List actualList = patternTreeMap.getOverlapped(devicePath, measurements);
        Assert.assertEquals((long)expectedList.size(), (long)actualList.size());
        for (int i = 0; i < measurements.size(); ++i) {
            List<T> expectedSubList = expectedList.get(i);
            HashSet actualSubSet = new HashSet((Collection)actualList.get(i));
            Assert.assertEquals((long)expectedSubList.size(), (long)actualSubSet.size());
            for (T o : expectedSubList) {
                Assert.assertTrue((boolean)actualSubSet.contains(o));
            }
        }
    }
}

