/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegmentedPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.RecordUtils;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaPage;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaPageTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void flatTreeInsert() throws IOException, MetadataException {
        ISegmentedPage page = ISchemaPage.initSegmentedPage((ByteBuffer)ByteBuffer.allocate(16384), (int)0);
        IMNode root = this.virtualFlatMTree(15);
        block2: for (int i = 0; i < 7; ++i) {
            page.getAsSegmentedPage().allocNewSegment(SchemaFileConfig.SEG_SIZE_LST[0]);
            int cnt = 0;
            for (IMNode child : root.getChildren().values()) {
                ++cnt;
                try {
                    page.getAsSegmentedPage().write((short)i, child.getName(), RecordUtils.node2Buffer((IMNode)child));
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                }
                if (cnt <= i) continue;
                continue block2;
            }
        }
        ByteBuffer newBuf = ByteBuffer.allocate(16384);
        page.syncPageBuffer();
        page.getPageBuffer(newBuf);
        SchemaPage newPage = ISchemaPage.loadSchemaPage((ByteBuffer)newBuf);
        Assert.assertEquals((Object)newPage.inspect(), (Object)page.inspect());
        System.out.println(newPage.inspect());
    }

    @Test
    public void essentialPageTest() throws MetadataException, IOException {
        ByteBuffer buf = ByteBuffer.allocate(16384);
        ISegmentedPage page = ISchemaPage.initSegmentedPage((ByteBuffer)buf, (int)0);
        page.getAsSegmentedPage().allocNewSegment((short)500);
        Assert.assertFalse((page.getAsInternalPage() != null ? 1 : 0) != 0);
        page.getAsSegmentedPage().deleteSegment((short)0);
        page = ISchemaPage.initInternalPage((ByteBuffer)buf, (int)0, (int)0);
        Assert.assertTrue((page.getAsInternalPage() != null ? 1 : 0) != 0);
        page.getAsInternalPage().insertRecord("aaa", (Object)256);
        page.getAsInternalPage().setNextSegAddress(999L);
        page.syncPageBuffer();
        SchemaPage nPage = ISchemaPage.loadSchemaPage((ByteBuffer)buf);
        Assert.assertTrue((nPage.getAsInternalPage() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)999L, (long)nPage.getAsInternalPage().getNextSegAddress());
        Assert.assertEquals((long)256L, (long)((Integer)nPage.getAsInternalPage().getRecordByKey("aab")).intValue());
    }

    private IMNode virtualFlatMTree(int childSize) {
        EntityMNode internalNode = new EntityMNode(null, "vRoot1");
        for (int idx = 0; idx < childSize; ++idx) {
            String measurementId = "mid" + idx;
            MeasurementSchema schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            IMeasurementMNode mNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)internalNode.getAsEntityMNode(), (String)measurementId, (IMeasurementSchema)schema, (String)(measurementId + "als"));
            internalNode.addChild((IMNode)mNode);
        }
        return internalNode;
    }

    public void print(Object o) {
        System.out.println(o);
    }

    private void printBuffer(ByteBuffer buf) {
        int lim = buf.limit();
        ByteBuffer bufRep = buf.slice();
        for (int pos = buf.position(); pos < lim; ++pos) {
            System.out.print(buf.get(pos));
            System.out.print(" ");
        }
        System.out.println("");
    }
}

