/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MNodeUtils;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupEntityMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.RecordUtils;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.WrappedSegment;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaFileTest {
    private static final int TEST_SCHEMA_REGION_ID = 0;

    @Before
    public void setUp() {
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Schema_File.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    @Test
    public void essentialTestSchemaFile() throws IOException, MetadataException {
        ISchemaFile sf = SchemaFile.initSchemaFile((String)"root.test.vRoot1", (int)0);
        StorageGroupEntityMNode newSGNode = new StorageGroupEntityMNode(null, "newSG", 10000L);
        sf.updateStorageGroupNode((IStorageGroupMNode)newSGNode);
        IMNode root = SchemaFileTest.virtualTriangleMTree(5, "root.test");
        IMNode int0 = root.getChild("int0");
        IMNode int1 = root.getChild("int0").getChild("int1");
        IMNode int4 = root.getChild("int0").getChild("int1").getChild("int2").getChild("int3").getChild("int4");
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)int0).getNewChildBuffer().put("mint1", SchemaFileTest.getMeasurementNode(int0, "mint1", "alas"));
        Iterator<IMNode> ite = SchemaFileTest.getTreeBFT(root);
        while (ite.hasNext()) {
            IMNode curNode = ite.next();
            if (curNode.isMeasurement()) continue;
            sf.writeMNode(curNode);
        }
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)int0).getNewChildBuffer().clear();
        SchemaFileTest.addNodeToUpdateBuffer(int0, SchemaFileTest.getMeasurementNode(int0, "mint1", "alas99999"));
        sf.writeMNode(int0);
        Assert.assertEquals((Object)"alas99999", (Object)sf.getChildNode(int0, "mint1").getAsMeasurementMNode().getAlias());
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)int1).getNewChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)int1).appendMNode(SchemaFileTest.getMeasurementNode(int1, "int1newM", "alas"));
        sf.writeMNode(int1);
        Assert.assertEquals((Object)"alas", (Object)sf.getChildNode(int1, "int1newM").getAsMeasurementMNode().getAlias());
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)int4).getNewChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)int4).getNewChildBuffer().put("AAAAA", SchemaFileTest.getMeasurementNode(int4, "AAAAA", "alas"));
        sf.writeMNode(int4);
        Assert.assertEquals((Object)"alas", (Object)sf.getChildNode(int4, "AAAAA").getAsMeasurementMNode().getAlias());
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)int4).getUpdatedChildBuffer().clear();
        SchemaFileTest.addNodeToUpdateBuffer(int4, SchemaFileTest.getMeasurementNode(int4, "AAAAA", "BBBBBB"));
        sf.writeMNode(int4);
        Assert.assertEquals((Object)"BBBBBB", (Object)sf.getChildNode(int4, "AAAAA").getAsMeasurementMNode().getAlias());
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)int4).getUpdatedChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)int4).getUpdatedChildBuffer().put("finalM191", SchemaFileTest.getMeasurementNode(int4, "finalM191", "ALLLLLLLLLLLLLLLLLLLLfinalM191"));
        sf.writeMNode(int4);
        Assert.assertEquals((Object)"ALLLLLLLLLLLLLLLLLLLLfinalM191", (Object)sf.getChildNode(int4, "finalM191").getAsMeasurementMNode().getAlias());
        sf.close();
        ISchemaFile nsf = SchemaFile.loadSchemaFile((String)"root.test.vRoot1", (int)0);
        Assert.assertEquals((Object)"alas99999", (Object)nsf.getChildNode(int0, "mint1").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"alas", (Object)nsf.getChildNode(int1, "int1newM").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"BBBBBB", (Object)nsf.getChildNode(int4, "AAAAA").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"ALLLLLLLLLLLLLLLLLLLLfinalM191", (Object)nsf.getChildNode(int4, "finalM191").getAsMeasurementMNode().getAlias());
        nsf.close();
    }

    @Test
    public void testVerticalTree() throws MetadataException, IOException {
        ISchemaFile sf = SchemaFile.initSchemaFile((String)"root.sgvt.vt", (int)0);
        StorageGroupEntityMNode sgNode = new StorageGroupEntityMNode(null, "sg", 11111L);
        sf.updateStorageGroupNode((IStorageGroupMNode)sgNode);
        IMNode root = SchemaFileTest.getVerticalTree(100, "VT");
        Iterator<IMNode> ite = SchemaFileTest.getTreeBFT(root);
        while (ite.hasNext()) {
            sf.writeMNode(ite.next());
        }
        IMNode vt1 = this.getNode(root, "root.VT_0.VT_1");
        IMNode vt4 = this.getNode(root, "root.VT_0.VT_1.VT_2.VT_3.VT_4");
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)vt1).getNewChildBuffer().clear();
        SchemaFileTest.addMeasurementChild(vt1, "newM");
        sf.writeMNode(vt1);
        IMNode vt0 = this.getNode(root, "root.VT_0");
        Assert.assertEquals((long)ICachedMNodeContainer.getCachedMNodeContainer((IMNode)vt1).getSegmentAddress(), (long)RecordUtils.getRecordSegAddr((ByteBuffer)SchemaFileTest.getSegment(sf, ICachedMNodeContainer.getCachedMNodeContainer((IMNode)vt0).getSegmentAddress()).getRecord("VT_1")));
        Assert.assertEquals((long)2L, (long)SchemaFileTest.getSegment(sf, ICachedMNodeContainer.getCachedMNodeContainer((IMNode)vt1).getSegmentAddress()).getKeyOffsetList().size());
        sf.close();
        ISchemaFile nsf = SchemaFile.loadSchemaFile((String)"root.sgvt.vt", (int)0);
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)vt1).getNewChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)vt4).getNewChildBuffer().clear();
        HashSet<String> newNodes = new HashSet<String>();
        for (int i = 0; i < 15; ++i) {
            SchemaFileTest.addMeasurementChild(vt1, "r1_" + i);
            SchemaFileTest.addMeasurementChild(vt4, "r4_" + i);
            newNodes.add("r1_" + i);
            newNodes.add("r4_" + i);
        }
        nsf.writeMNode(vt1);
        nsf.writeMNode(vt4);
        nsf.close();
        nsf = SchemaFile.loadSchemaFile((String)"root.sgvt.vt", (int)0);
        Iterator vt1Children = nsf.getChildren(vt1);
        Iterator vt4Children = nsf.getChildren(vt4);
        while (vt1Children.hasNext()) {
            newNodes.remove(((IMNode)vt1Children.next()).getName());
        }
        while (vt4Children.hasNext()) {
            newNodes.remove(((IMNode)vt4Children.next()).getName());
        }
        Assert.assertTrue((boolean)newNodes.isEmpty());
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)vt1).getNewChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)vt4).getNewChildBuffer().clear();
        for (int i = 0; i < 660; ++i) {
            SchemaFileTest.addMeasurementChild(vt1, "2r1_" + i);
            SchemaFileTest.addMeasurementChild(vt4, "2r4_" + i);
            newNodes.add("2r1_" + i);
            newNodes.add("2r4_" + i);
        }
        nsf.writeMNode(vt1);
        nsf.writeMNode(vt4);
        Assert.assertEquals((long)11111L, (long)nsf.init().getAsStorageGroupMNode().getDataTTL());
        nsf.close();
    }

    @Test
    public void testFaltTree() throws MetadataException, IOException {
        ISchemaFile sf = SchemaFile.initSchemaFile((String)"root.test.vRoot1", (int)0);
        Iterator<IMNode> ite = SchemaFileTest.getTreeBFT(SchemaFileTest.getFlatTree(50000, "aa"));
        while (ite.hasNext()) {
            IMNode cur = ite.next();
            if (cur.isMeasurement()) continue;
            sf.writeMNode(cur);
        }
        InternalMNode node = new InternalMNode(null, "a");
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)node).setSegmentAddress(0L);
        List<Integer> tryReadList = Arrays.asList(199, 1999, 2999, 3999, 4999, 5999);
        for (Integer rid : tryReadList) {
            IMNode target = sf.getChildNode((IMNode)node, "aa" + rid);
            Assert.assertEquals((Object)("aa" + rid + "als"), (Object)target.getAsMeasurementMNode().getAlias());
        }
        sf.close();
    }

    @Test
    public void testGetChildren() throws MetadataException, IOException {
        this.essentialTestSchemaFile();
        InternalMNode node = new InternalMNode(null, "test");
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)node).setSegmentAddress(SchemaFile.getGlobalIndex((int)2, (short)0));
        ISchemaFile sf = SchemaFile.loadSchemaFile((String)"root.test.vRoot1", (int)0);
        Iterator res = sf.getChildren((IMNode)node);
        int cnt = 0;
        while (res.hasNext()) {
            res.next();
            ++cnt;
        }
        sf.close();
        Assert.assertEquals((long)1002L, (long)cnt);
    }

    @Test
    public void test200KMeasurement() throws MetadataException, IOException {
        int i = 200000;
        StorageGroupMNode sgNode = new StorageGroupMNode(null, "sgRoot", 11111111L);
        ISchemaFile sf = SchemaFile.initSchemaFile((String)sgNode.getName(), (int)0);
        for (int j = 20; j >= 0; --j) {
            EntityMNode aDevice = new EntityMNode((IMNode)sgNode, "dev_" + j);
            sgNode.addChild((IMNode)aDevice);
        }
        sf.writeMNode((IMNode)sgNode);
        IMNode dev = (IMNode)sgNode.getChildren().get((Object)"dev_2");
        while (i >= 0) {
            IMNode meas = SchemaFileTest.getMeasurementNode(dev, "m_" + i, "ma_" + i);
            dev.addChild(meas);
            --i;
        }
        sf.writeMNode(dev);
        Assert.assertEquals((Object)"ma_199406", (Object)sf.getChildNode(dev, "m_199406").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"m_1995", (Object)sf.getChildNode(dev, "ma_1995").getName());
        sf.delete(dev);
        Assert.assertNull((Object)sf.getChildNode((IMNode)sgNode, "dev_2"));
        sf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test10KDevices() throws MetadataException, IOException {
        int i;
        StorageGroupMNode sgNode = new StorageGroupMNode(null, "sgRoot", 11111111L);
        for (i = 1000; i >= 0; --i) {
            InternalMNode aDevice = new InternalMNode((IMNode)sgNode, "dev_" + i);
            sgNode.addChild((IMNode)aDevice);
        }
        Iterator<IMNode> orderedTree = SchemaFileTest.getTreeBFT((IMNode)sgNode);
        ISchemaFile sf = SchemaFile.initSchemaFile((String)sgNode.getName(), (int)0);
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)sgNode).setSegmentAddress(0L);
        IMNode node = null;
        try {
            while (orderedTree.hasNext()) {
                node = orderedTree.next();
                if (node.isMeasurement()) continue;
                sf.writeMNode(node);
            }
            for (i = 1000; i >= 0; --i) {
                long addr = SchemaFileTest.getSegAddrInContainer(sgNode.getChild("dev_" + i));
                EntityMNode aDevice = new EntityMNode((IMNode)sgNode, "dev_" + i);
                sgNode.deleteChild(aDevice.getName());
                sgNode.addChild((IMNode)aDevice);
                SchemaFileTest.moveToUpdateBuffer((IMNode)sgNode, "dev_" + i);
                ICachedMNodeContainer.getCachedMNodeContainer((IMNode)aDevice).setSegmentAddress(addr);
            }
            orderedTree = SchemaFileTest.getTreeBFT((IMNode)sgNode);
            while (orderedTree.hasNext()) {
                node = orderedTree.next();
                if (node.isMeasurement()) continue;
                sf.writeMNode(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(node.getName());
        }
        finally {
            sf.close();
        }
        for (Object etn : sgNode.getChildren().values()) {
            for (int j = 10; j >= 0; --j) {
                SchemaFileTest.addMeasurementChild((IMNode)etn, String.format("mtc_%d_%d", i, j));
            }
        }
        orderedTree = SchemaFileTest.getTreeBFT((IMNode)sgNode);
        sf = SchemaFile.loadSchemaFile((String)sgNode.getName(), (int)0);
        try {
            while (orderedTree.hasNext()) {
                node = orderedTree.next();
                if (node.isMeasurement() || node.isStorageGroup()) continue;
                sf.writeMNode(node);
                ICachedMNodeContainer.getCachedMNodeContainer((IMNode)node).getNewChildBuffer().clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(node.getName());
        }
        finally {
            sf.close();
        }
        HashSet<String> resName = new HashSet<String>();
        for (IMNode etn : sgNode.getChildren().values()) {
            for (int j = 1000; j >= 0; --j) {
                SchemaFileTest.addMeasurementChild(etn, String.format("mtc2_%d_%d", i, j));
                if (resName.size() >= 101) continue;
                resName.add(String.format("mtc2_%d_%d", i, j));
            }
        }
        orderedTree = SchemaFileTest.getTreeBFT((IMNode)sgNode);
        sf = SchemaFile.loadSchemaFile((String)sgNode.getName(), (int)0);
        ArrayList<IMNode> arbitraryNode = new ArrayList<IMNode>();
        try {
            while (orderedTree.hasNext()) {
                node = orderedTree.next();
                if (node.isMeasurement() || node.isStorageGroup()) continue;
                sf.writeMNode(node);
                if (arbitraryNode.size() >= 50) continue;
                arbitraryNode.add(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(node.getName());
        }
        finally {
            sf.close();
        }
        sf = SchemaFile.loadSchemaFile((String)"sgRoot", (int)0);
        for (String key : resName) {
            IMNode resNode = sf.getChildNode((IMNode)arbitraryNode.get(arbitraryNode.size() - 3), key);
            Assert.assertTrue((boolean)resNode.getAsMeasurementMNode().getAlias().equals(resNode.getName() + "alias"));
        }
        Iterator res = sf.getChildren((IMNode)arbitraryNode.get(arbitraryNode.size() - 1));
        boolean i2 = false;
        while (res.hasNext()) {
            resName.remove(((IMNode)res.next()).getName());
        }
        Assert.assertTrue((boolean)resName.isEmpty());
        sf.close();
    }

    @Test
    public void testUpdateOnFullPageSegment() throws MetadataException, IOException {
        ISchemaFile sf = SchemaFile.initSchemaFile((String)"root.sg", (int)0);
        IMNode root = SchemaFileTest.getFlatTree(783, "aa");
        Iterator<IMNode> ite = SchemaFileTest.getTreeBFT(root);
        while (ite.hasNext()) {
            IMNode cur = ite.next();
            if (cur.isMeasurement()) continue;
            sf.writeMNode(cur);
        }
        root.getChildren().clear();
        root.addChild(SchemaFileTest.getMeasurementNode(root, "aa0", "updatedupdatednode"));
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)root).moveMNodeToCache("aa0");
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)root).updateMNode("aa0");
        sf.writeMNode(root);
        Assert.assertEquals((Object)"updatedupdatednode", (Object)sf.getChildNode(root, "aa0").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"aa0", (Object)sf.getChildNode(root, "updatedupdatednode").getName());
        root.getChildren().clear();
        root.addChild((IMNode)new EntityMNode(root, "ent1"));
        IMNode ent1 = root.getChild("ent1");
        ent1.addChild(SchemaFileTest.getMeasurementNode(ent1, "m1", "m1a"));
        sf.writeMNode(root);
        sf.writeMNode(ent1);
        ent1.getChildren().clear();
        ent1.addChild(SchemaFileTest.getMeasurementNode(ent1, "m1", "m1aaaaaa"));
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)ent1).moveMNodeToCache("m1");
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)ent1).updateMNode("m1");
        Assert.assertEquals((long)64L, (long)SchemaFileTest.getSegment(sf, SchemaFileTest.getSegAddr(sf, SchemaFileTest.getSegAddrInContainer(ent1), "m1")).size());
        sf.writeMNode(ent1);
        Assert.assertEquals((long)1020L, (long)SchemaFileTest.getSegment(sf, SchemaFileTest.getSegAddr(sf, SchemaFileTest.getSegAddrInContainer(ent1), "m1")).size());
        ent1.getChildren().clear();
        while (ent1.getChildren().size() < 374) {
            SchemaFileTest.addMeasurementChild(ent1, "nc" + ent1.getChildren().size());
        }
        sf.writeMNode(ent1);
        ent1.getChildren().clear();
        ent1.addChild(SchemaFileTest.getMeasurementNode(ent1, "nc0", "updated_nc0updated_nc0updated_nc0updated_nc0"));
        SchemaFileTest.moveToUpdateBuffer(ent1, "nc0");
        sf.writeMNode(ent1);
        ent1.getChildren().clear();
        ent1.addChild(SchemaFileTest.getMeasurementNode(ent1, "nc1", "updated_nc1updated_nc1updated_nc1updated_nc1"));
        SchemaFileTest.moveToUpdateBuffer(ent1, "nc1");
        sf.writeMNode(ent1);
        Assert.assertEquals((long)SchemaFileTest.getSegAddr(sf, SchemaFileTest.getSegAddrInContainer(ent1), "nc1"), (long)SchemaFileTest.getSegAddr(sf, SchemaFileTest.getSegAddrInContainer(ent1), "nc0"));
        sf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEstimateSegSize() throws Exception {
        StorageGroupMNode sgNode = new StorageGroupMNode(null, "mma", 111111111L);
        IMNode d1 = this.fillChildren((IMNode)sgNode, 300, "d", this::supplyEntity);
        try (ISchemaFile sf = SchemaFile.initSchemaFile((String)"root.sg", (int)0);){
            sf.writeMNode((IMNode)sgNode);
            this.fillChildren(d1, 46, "s", this::supplyMeasurement);
            sf.writeMNode(d1);
            SchemaFileTest.moveAllToBuffer(d1);
            SchemaFileTest.moveAllToBuffer((IMNode)sgNode);
            this.fillChildren((IMNode)sgNode, 350, "sd", this::supplyEntity);
            sf.writeMNode((IMNode)sgNode);
            this.fillChildren(d1, 20, "ss", this::supplyMeasurement);
            sf.writeMNode(d1);
            Iterator verifyChildren = sf.getChildren(d1);
            int cnt = 0;
            while (verifyChildren.hasNext()) {
                ++cnt;
                verifyChildren.next();
            }
            Assert.assertEquals((long)66L, (long)cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Test
    public void test200KAlias() throws Exception {
        ISchemaFile sf = SchemaFile.initSchemaFile((String)"root.sg", (int)0);
        StorageGroupMNode sgNode = new StorageGroupMNode(null, "mma", 111111111L);
        int factor20K = 20000;
        ArrayList<EntityMNode> devs = new ArrayList<EntityMNode>();
        ArrayList senList = new ArrayList();
        HashMap<String, String> aliasAns = new HashMap<String, String>();
        try {
            for (int i = 0; i < 5; ++i) {
                devs.add(new EntityMNode((IMNode)sgNode, "d_" + i));
                sgNode.addChild((IMNode)devs.get(i));
            }
            for (IMNode iMNode : devs) {
                ArrayList<IMNode> arrayList = new ArrayList<IMNode>();
                for (int i = 0; i < factor20K; ++i) {
                    arrayList.add(SchemaFileTest.getMeasurementNode(iMNode, "s_" + i, null));
                    iMNode.addChild((IMNode)arrayList.get(i));
                    if (!iMNode.getName().equals("d_0")) continue;
                    aliasAns.put("s_" + i, "als_" + i);
                }
                senList.add(arrayList);
            }
            Iterator<IMNode> ite = SchemaFileTest.getTreeBFT((IMNode)sgNode);
            while (ite.hasNext()) {
                IMNode iMNode = ite.next();
                if (iMNode.isMeasurement()) continue;
                sf.writeMNode(iMNode);
            }
        }
        finally {
            sf.sync();
            sf.close();
        }
        sf = SchemaFile.loadSchemaFile((String)"root.sg", (int)0);
        try {
            void var9_24;
            IMNode dev2 = (IMNode)devs.get(2);
            for (IMNode iMNode : dev2.getChildren().values()) {
                iMNode.getAsMeasurementMNode().setAlias((String)aliasAns.get(iMNode.getName()));
            }
            for (String string : aliasAns.keySet()) {
                SchemaFileTest.moveToUpdateBuffer(dev2, string);
            }
            sf.writeMNode(dev2);
            sf.sync();
            sf.close();
            sf = SchemaFile.loadSchemaFile((String)"root.sg", (int)0);
            for (Map.Entry entry : aliasAns.entrySet()) {
                Assert.assertEquals(entry.getKey(), (Object)sf.getChildNode(dev2, (String)entry.getValue()).getName());
            }
            Iterator iterator = sf.getChildren(dev2);
            boolean bl = false;
            while (iterator.hasNext()) {
                ++var9_24;
                iterator.next();
            }
            Assert.assertEquals((long)factor20K, (long)((long)var9_24));
        }
        finally {
            sf.close();
        }
    }

    @Test
    public void testRearrangementWhenInsert() throws MetadataException, IOException {
        ISchemaFile sf = SchemaFile.initSchemaFile((String)"root.sg", (int)0);
        StorageGroupEntityMNode root = new StorageGroupEntityMNode(null, "sgRoot", 0L);
        root.getChildren().clear();
        EntityMNode ent2 = new EntityMNode((IMNode)root, "ent2");
        EntityMNode ent3 = new EntityMNode((IMNode)root, "ent3");
        EntityMNode ent4 = new EntityMNode((IMNode)root, "ent4");
        root.addChild((IMNode)ent2);
        root.addChild((IMNode)ent3);
        root.addChild((IMNode)ent4);
        while (ent4.getChildren().size() < 19) {
            ent4.addChild(SchemaFileTest.getMeasurementNode((IMNode)ent4, "e4m" + ent4.getChildren().size(), "e4malais" + ent4.getChildren().size()));
        }
        sf.writeMNode((IMNode)root);
        sf.writeMNode((IMNode)ent4);
        ent4.getChildren().clear();
        ent4.addChild(SchemaFileTest.getMeasurementNode((IMNode)ent4, "e4m0", "updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_"));
        SchemaFileTest.moveToUpdateBuffer((IMNode)ent4, "e4m0");
        sf.writeMNode((IMNode)ent4);
        while (ent2.getChildren().size() < 19) {
            ent2.addChild(SchemaFileTest.getMeasurementNode((IMNode)ent2, "e2m" + ent2.getChildren().size(), "e2malais" + ent2.getChildren().size()));
        }
        sf.writeMNode((IMNode)ent2);
        while (ent3.getChildren().size() < 180) {
            ent3.addChild(SchemaFileTest.getMeasurementNode((IMNode)ent3, "e3m" + ent3.getChildren().size(), "e3malais" + ent3.getChildren().size()));
        }
        sf.writeMNode((IMNode)ent3);
        ent2.getChildren().clear();
        while (ent2.getChildren().size() < 70) {
            ent2.addChild(SchemaFileTest.getMeasurementNode((IMNode)ent2, "e2ms" + ent2.getChildren().size(), "e2is_s2_" + ent2.getChildren().size()));
        }
        sf.writeMNode((IMNode)ent2);
        Assert.assertEquals((long)(SchemaFileTest.getSegAddr(sf, SchemaFileTest.getSegAddrInContainer((IMNode)ent2), "e2m0") + 1L), (long)SchemaFileTest.getSegAddr(sf, SchemaFileTest.getSegAddrInContainer((IMNode)ent3), "e3m0"));
        Assert.assertEquals((long)(SchemaFileTest.getSegAddr(sf, SchemaFileTest.getSegAddrInContainer((IMNode)ent2), "e2m0") + 2L), (long)SchemaFileTest.getSegAddr(sf, SchemaFileTest.getSegAddrInContainer((IMNode)ent4), "e4m0"));
        root.getChildren().clear();
        EntityMNode ent5 = new EntityMNode((IMNode)root, "ent5");
        root.addChild((IMNode)ent5);
        while (ent5.getChildren().size() < 19) {
            ent5.addChild(SchemaFileTest.getMeasurementNode((IMNode)ent5, "e5mk" + ent5.getChildren().size(), "e5malaikkkkks" + ent5.getChildren().size()));
        }
        sf.writeMNode((IMNode)root);
        sf.writeMNode((IMNode)ent5);
        ent5.getChildren().clear();
        ent5.addChild(SchemaFileTest.getMeasurementNode((IMNode)ent5, "e5extm", "e5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkks"));
        sf.writeMNode((IMNode)ent5);
        Assert.assertEquals((long)20L, (long)SchemaFileTest.getSegment(sf, SchemaFileTest.getSegAddrInContainer((IMNode)ent5)).getAllRecords().size());
        Assert.assertEquals((Object)"e5extm", (Object)sf.getChildNode((IMNode)ent5, "e5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkks").getName());
        ent5.getChildren().clear();
        SchemaFileTest.addNodeToUpdateBuffer((IMNode)ent5, SchemaFileTest.getMeasurementNode((IMNode)ent5, "e5extm", null));
        sf.writeMNode((IMNode)ent5);
        Assert.assertEquals(null, (Object)sf.getChildNode((IMNode)ent5, "e5extm").getAsMeasurementMNode().getAlias());
        sf.close();
    }

    @Test
    public void bitwiseTest() {
        long initGlbAdr = 0x10010000000L;
        int pageIndex = SchemaFile.getPageIndex((long)initGlbAdr);
        for (int bs = 1; bs <= 32; ++bs) {
            long highBits = 0xFFFFFFFF00000000L & (0xFFFFFFFFL & (long)pageIndex) << 1;
            pageIndex <<= 1;
            pageIndex = (int)((long)pageIndex | highBits >>> 32);
            Assert.assertEquals((long)pageIndex, (long)SchemaFile.getPageIndex((long)SchemaFile.getGlobalIndex((int)pageIndex, (short)0)));
        }
        short segIdx = SchemaFile.getSegIndex((long)initGlbAdr);
        while (initGlbAdr < 1099980063232L) {
            Assert.assertEquals((long)initGlbAdr, (long)SchemaFile.getGlobalIndex((int)pageIndex, (short)segIdx));
            pageIndex = SchemaFile.getPageIndex((long)(initGlbAdr += 0x80000000L));
            segIdx = SchemaFile.getSegIndex((long)initGlbAdr);
        }
    }

    @Test
    public void basicTest() throws IOException, MetadataException {
        SchemaFileConfig.INTERNAL_SPLIT_VALVE = 16000;
        StorageGroupEntityMNode sgNode = new StorageGroupEntityMNode(null, "sgRoot", 11111111L);
        HashSet<String> checkSet = new HashSet<String>();
        for (int i = 10000; i >= 0; --i) {
            String name = Integer.toString(i);
            if (i < 10) {
                name = "00" + name;
            } else if (i < 100) {
                name = "0" + name;
            }
            IMNode aMeas = SchemaFileTest.getMeasurementNode((IMNode)sgNode, "s_" + name, null);
            checkSet.add(aMeas.getName());
            sgNode.addChild(aMeas);
        }
        Iterator<IMNode> orderedTree = SchemaFileTest.getTreeBFT((IMNode)sgNode);
        ISchemaFile sf = SchemaFile.initSchemaFile((String)sgNode.getName(), (int)0);
        sf.writeMNode((IMNode)sgNode);
        Iterator res = sf.getChildren((IMNode)sgNode);
        while (res.hasNext()) {
            checkSet.remove(((IMNode)res.next()).getName());
        }
        Assert.assertTrue((boolean)checkSet.isEmpty());
        sf.close();
        SchemaFileConfig.INTERNAL_SPLIT_VALVE = 0;
    }

    @Test
    public void basicSplitTest() throws MetadataException, IOException {
        InternalMNode aMeas;
        String name;
        int j;
        SchemaFileConfig.INTERNAL_SPLIT_VALVE = 16230;
        SchemaFileConfig.DETAIL_SKETCH = true;
        StorageGroupEntityMNode sgNode = new StorageGroupEntityMNode(null, "sgRoot", 11111111L);
        HashSet<String> checkSet = new HashSet<String>();
        for (int i = 999; i >= 0; --i) {
            String name2 = Integer.toString(i);
            if (i < 10) {
                name2 = "00" + name2;
            } else if (i < 100) {
                name2 = "0" + name2;
            }
            IMNode aMeas2 = SchemaFileTest.getMeasurementNode((IMNode)sgNode, "s_" + name2, null);
            checkSet.add(aMeas2.getName());
            sgNode.addChild(aMeas2);
        }
        ISchemaFile sf = SchemaFile.initSchemaFile((String)sgNode.getName(), (int)0);
        sf.writeMNode((IMNode)sgNode);
        Iterator res = sf.getChildren((IMNode)sgNode);
        while (res.hasNext()) {
            checkSet.remove(((IMNode)res.next()).getName());
        }
        Assert.assertTrue((boolean)checkSet.isEmpty());
        sgNode.getChildren().clear();
        for (j = 50; j >= 0; --j) {
            name = Integer.toString(j);
            if (j < 10) {
                name = "00" + name;
            } else if (j < 100) {
                name = "0" + name;
            }
            aMeas = new InternalMNode((IMNode)sgNode, "d_" + name);
            sgNode.addChild((IMNode)aMeas);
        }
        for (j = 560; j >= 0; --j) {
            name = Integer.toString(j);
            if (j < 10) {
                name = "00" + name;
            } else if (j < 100) {
                name = "0" + name;
            }
            aMeas = new InternalMNode((IMNode)sgNode, "dd2_" + name);
            checkSet.add(aMeas.getName());
            ((IMNode)sgNode.getChildren().get((Object)"d_010")).addChild((IMNode)aMeas);
        }
        IMNode d010 = (IMNode)sgNode.getChildren().get((Object)"d_010");
        d010 = MNodeUtils.setToEntity((IMNode)d010);
        IMNode ano = SchemaFileTest.getMeasurementNode(d010, "splitover", "aliaslasialsai");
        d010.addChild(ano);
        sgNode.addChild(d010);
        sf.writeMNode((IMNode)sgNode);
        sf.writeMNode((IMNode)sgNode.getChildren().get((Object)"d_010"));
        ano.getAsMeasurementMNode().setAlias("aliaslasialsaialiaslasialsai");
        d010.getChildren().clear();
        d010.addChild(ano);
        SchemaFileTest.moveToUpdateBuffer(d010, "splitover");
        sf.writeMNode(d010);
        int d010cs = 0;
        Iterator res2 = sf.getChildren(d010);
        while (res2.hasNext()) {
            checkSet.add(((IMNode)res2.next()).getName());
            ++d010cs;
        }
        sf.close();
        ISchemaFile sf2 = SchemaFile.loadSchemaFile((String)"sgRoot", (int)0);
        res2 = sf2.getChildren(d010);
        while (res2.hasNext()) {
            checkSet.remove(((IMNode)res2.next()).getName());
            --d010cs;
        }
        Assert.assertEquals((Object)"aliaslasialsaialiaslasialsai", (Object)sf2.getChildNode(d010, "splitover").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"splitover", (Object)sf2.getChildNode(d010, "aliaslasialsaialiaslasialsai").getName());
        Assert.assertEquals((long)0L, (long)d010cs);
        Assert.assertTrue((boolean)checkSet.isEmpty());
        sf2.close();
        SchemaFileConfig.INTERNAL_SPLIT_VALVE = 0;
    }

    private void printSF(ISchemaFile file) throws IOException, MetadataException {
        ((SchemaFile)file).inspect();
    }

    public static void print(Object o) {
        System.out.println(o.toString());
    }

    private static WrappedSegment getSegment(ISchemaFile sf, long address) {
        try {
            return ((SchemaFile)sf).getPageOnTest(SchemaFile.getPageIndex((long)address)).getSegmentOnTest(SchemaFile.getSegIndex((long)address));
        }
        catch (IOException | MetadataException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static long getSegAddr(ISchemaFile sf, long curAddr, String key) {
        try {
            return ((SchemaFile)sf).getTargetSegmentOnTest(curAddr, key);
        }
        catch (IOException | MetadataException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    private IMNode supplyMeasurement(IMNode par, String name) {
        return SchemaFileTest.getMeasurementNode(par, name, name + "_als");
    }

    private IMNode supplyInternal(IMNode par, String name) {
        return new InternalMNode(par, name);
    }

    private IMNode supplyEntity(IMNode par, String name) {
        return new EntityMNode(par, name);
    }

    private IMNode fillChildren(IMNode par, int number, String prefix, BiFunction<IMNode, String, IMNode> nodeFactory) {
        IMNode lastChild = null;
        for (int i = 0; i < number; ++i) {
            String childName = prefix + "_" + i;
            lastChild = nodeFactory.apply(par, childName);
            par.addChild(lastChild);
        }
        return lastChild;
    }

    static void addMeasurementChild(IMNode par, String mid) {
        par.addChild(SchemaFileTest.getMeasurementNode(par, mid, mid + "alias"));
    }

    static IMeasurementSchema getSchema(String id) {
        return new MeasurementSchema(id, TSDataType.FLOAT);
    }

    private IMNode getNode(IMNode root, String path) throws MetadataException {
        String[] pathNodes = PathUtils.splitPathToDetachedNodes((String)path);
        IMNode cur = root;
        for (String node : pathNodes) {
            if (node.equals("root")) continue;
            cur = cur.getChild(node);
        }
        return cur;
    }

    static IMNode getInternalWithSegAddr(IMNode par, String name, long segAddr) {
        EntityMNode node = new EntityMNode(par, name);
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)node).setSegmentAddress(segAddr);
        return node;
    }

    static IMNode getMeasurementNode(IMNode par, String name, String alias) {
        MeasurementSchema schema = new MeasurementSchema(name, TSDataType.FLOAT);
        IMeasurementMNode mNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)par.getAsEntityMNode(), (String)name, (IMeasurementSchema)schema, (String)alias);
        return mNode;
    }

    static void addNodeToUpdateBuffer(IMNode par, IMNode child) {
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).remove((Object)child.getName());
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).appendMNode(child);
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).moveMNodeToCache(child.getName());
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).updateMNode(child.getName());
    }

    static void moveToUpdateBuffer(IMNode par, String childName) {
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).appendMNode(par.getChild(childName));
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).moveMNodeToCache(childName);
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).updateMNode(childName);
    }

    static void moveAllToUpdate(IMNode par) {
        List childNames = par.getChildren().values().stream().map(IMNode::getName).collect(Collectors.toList());
        for (String name : childNames) {
            ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).moveMNodeToCache(name);
            ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).updateMNode(name);
        }
    }

    static void moveAllToBuffer(IMNode par) {
        List childNames = par.getChildren().values().stream().map(IMNode::getName).collect(Collectors.toList());
        for (String name : childNames) {
            ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).moveMNodeToCache(name);
        }
    }

    static long getSegAddrInContainer(IMNode par) {
        return ICachedMNodeContainer.getCachedMNodeContainer((IMNode)par).getSegmentAddress();
    }

    static IMNode virtualTriangleMTree(int size, String sgPath) throws MetadataException {
        int idx;
        IMeasurementMNode mNode;
        MeasurementSchema schema;
        String[] sgPathNodes = PathUtils.splitPathToDetachedNodes((String)sgPath);
        InternalMNode upperNode = null;
        for (String name : sgPathNodes) {
            InternalMNode child;
            upperNode = child = new InternalMNode(upperNode, name);
        }
        StorageGroupEntityMNode internalNode = new StorageGroupEntityMNode(upperNode, "vRoot1", 0L);
        for (int idx2 = 0; idx2 < size; ++idx2) {
            String measurementId = "mid" + idx2;
            schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            mNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)internalNode.getAsEntityMNode(), (String)measurementId, (IMeasurementSchema)schema, (String)(measurementId + "als"));
            internalNode.addChild((IMNode)mNode);
        }
        StorageGroupEntityMNode curNode = internalNode;
        for (idx = 0; idx < size; ++idx) {
            String nodeName = "int" + idx;
            EntityMNode newNode = new EntityMNode((IMNode)curNode, nodeName);
            curNode.addChild((IMNode)newNode);
            curNode = newNode;
        }
        for (idx = 0; idx < 1000; ++idx) {
            schema = new MeasurementSchema("finalM" + idx, TSDataType.FLOAT);
            mNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)internalNode.getAsEntityMNode(), (String)("finalM" + idx), (IMeasurementSchema)schema, (String)("finalals" + idx));
            curNode.addChild((IMNode)mNode);
        }
        MeasurementSchema schema2 = new MeasurementSchema("finalM", TSDataType.FLOAT);
        IMeasurementMNode mNode2 = MeasurementMNode.getMeasurementMNode((IEntityMNode)internalNode.getAsEntityMNode(), (String)"finalM", (IMeasurementSchema)schema2, (String)"finalals");
        curNode.addChild((IMNode)mNode2);
        upperNode.addChild((IMNode)internalNode);
        return internalNode;
    }

    static IMNode getFlatTree(int flatSize, String id) {
        InternalMNode root = new InternalMNode(null, "root");
        InternalMNode test = new InternalMNode((IMNode)root, "test");
        StorageGroupEntityMNode internalNode = new StorageGroupEntityMNode(null, "vRoot1", 0L);
        for (int idx = 0; idx < flatSize; ++idx) {
            String measurementId = id + idx;
            MeasurementSchema schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            IMeasurementMNode mNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)internalNode.getAsEntityMNode(), (String)measurementId, (IMeasurementSchema)schema, (String)(measurementId + "als"));
            internalNode.addChild((IMNode)mNode);
        }
        test.addChild((IMNode)internalNode);
        return internalNode;
    }

    static IMNode getVerticalTree(int height, String id) {
        InternalMNode trueRoot = new InternalMNode(null, "root");
        trueRoot.addChild((IMNode)new InternalMNode((IMNode)trueRoot, "sgvt"));
        StorageGroupEntityMNode root = new StorageGroupEntityMNode(null, "vt", 0L);
        StorageGroupEntityMNode cur = root;
        for (int cnt = 0; cnt < height; ++cnt) {
            cur.addChild((IMNode)new EntityMNode((IMNode)cur, id + "_" + cnt));
            cur = cur.getChild(id + "_" + cnt);
        }
        trueRoot.getChild("sgvt").addChild((IMNode)root);
        return root;
    }

    static Iterator<IMNode> getTreeBFT(final IMNode root) {
        return new Iterator<IMNode>(){
            Queue<IMNode> queue = new LinkedList<IMNode>();
            {
                this.queue.add(root);
            }

            @Override
            public boolean hasNext() {
                return this.queue.size() > 0;
            }

            @Override
            public IMNode next() {
                IMNode curNode = this.queue.poll();
                if (!curNode.isMeasurement() && curNode.getChildren().size() > 0) {
                    for (IMNode child : curNode.getChildren().values()) {
                        this.queue.add(child);
                    }
                }
                return curNode;
            }
        };
    }
}

