/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupEntityMNode;
import org.apache.iotdb.db.metadata.mtree.schemafile.SchemaFileTest;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegmentedPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFile;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaFileLogTest {
    private static final int TEST_SCHEMA_REGION_ID = 0;

    @Before
    public void setUp() {
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Schema_File.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void essentialLogTest() throws IOException, MetadataException {
        SchemaFile sf = (SchemaFile)SchemaFile.initSchemaFile((String)"root.test.vRoot1", (int)0);
        StorageGroupEntityMNode newSGNode = new StorageGroupEntityMNode(null, "newSG", 10000L);
        sf.updateStorageGroupNode((IStorageGroupMNode)newSGNode);
        IMNode root = SchemaFileTest.virtualTriangleMTree(5, "root.test");
        Iterator<IMNode> ite = SchemaFileTest.getTreeBFT(root);
        IMNode lastNode = null;
        while (ite.hasNext()) {
            IMNode curNode = ite.next();
            if (curNode.isMeasurement()) continue;
            sf.writeMNode(curNode);
            lastNode = curNode;
        }
        long address = SchemaFileTest.getSegAddrInContainer(lastNode);
        int corruptPageIndex = SchemaFile.getPageIndex((long)address);
        ISegmentedPage corPage = ISchemaPage.initSegmentedPage((ByteBuffer)ByteBuffer.allocate(16384), (int)corruptPageIndex);
        Iterator res = sf.getChildren(lastNode);
        int cnt = 0;
        while (res.hasNext()) {
            ++cnt;
            res.next();
        }
        try {
            Class<SchemaFile> schemaFileClass = SchemaFile.class;
            Field channelField = schemaFileClass.getDeclaredField("channel");
            channelField.setAccessible(true);
            FileChannel fileChannel = (FileChannel)channelField.get(sf);
            corPage.flushPageToChannel(fileChannel);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            sf.close();
        }
        sf = (SchemaFile)SchemaFile.loadSchemaFile((String)"root.test.vRoot1", (int)0);
        try {
            sf.getChildren(lastNode);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Segment(index:0) not found in page(index:2).", (Object)e.getMessage());
        }
        finally {
            sf.close();
        }
        try (FileOutputStream outputStream = null;){
            CharSequence[] logFilePath = new String[]{"target", "tmp", "system", "schema", "root.test.vRoot1", "0", "schema_file_log.bin"};
            File logFile = new File(String.join((CharSequence)File.separator, logFilePath));
            outputStream = new FileOutputStream(logFile, true);
            FileChannel channel = outputStream.getChannel();
            channel.truncate(channel.size() - 1L);
        }
        sf = (SchemaFile)SchemaFile.loadSchemaFile((String)"root.test.vRoot1", (int)0);
        res = sf.getChildren(lastNode);
        int cnt2 = 0;
        while (res.hasNext()) {
            res.next();
            ++cnt2;
        }
        Assert.assertEquals((long)cnt, (long)cnt2);
        sf.close();
    }
}

