/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.RecordUtils;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecordUtilTests {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void internalNodeTest() throws MetadataException {
        InternalMNode oneNode = new InternalMNode(null, "abcd");
        ICachedMNodeContainer.getCachedMNodeContainer((IMNode)oneNode).setSegmentAddress(1234567L);
        oneNode.setUseTemplate(true);
        ByteBuffer buffer = RecordUtils.node2Buffer((IMNode)oneNode);
        buffer.clear();
        IMNode node2 = RecordUtils.buffer2Node((String)"abcd", (ByteBuffer)buffer);
        Assert.assertEquals((long)ICachedMNodeContainer.getCachedMNodeContainer((IMNode)node2).getSegmentAddress(), (long)1234567L);
        Assert.assertEquals((Object)node2.isUseTemplate(), (Object)oneNode.isUseTemplate());
    }

    @Test
    public void measurementTest() throws MetadataException {
        MeasurementSchema schema = new MeasurementSchema("amn", TSDataType.FLOAT, TSEncoding.BITMAP, CompressionType.GZIP);
        IMeasurementMNode amn = MeasurementMNode.getMeasurementMNode(null, (String)"amn", (IMeasurementSchema)schema, (String)"anothername");
        ByteBuffer tBuf = RecordUtils.node2Buffer((IMNode)amn);
        tBuf.clear();
        Assert.assertFalse((boolean)RecordUtils.buffer2Node((String)"name", (ByteBuffer)tBuf).getAsMeasurementMNode().isPreDeleted());
        amn.getAsMeasurementMNode().setPreDeleted(true);
        tBuf = RecordUtils.node2Buffer((IMNode)amn);
        tBuf.clear();
        Assert.assertTrue((boolean)RecordUtils.buffer2Node((String)"name", (ByteBuffer)tBuf).getAsMeasurementMNode().isPreDeleted());
        ByteBuffer buffer = RecordUtils.node2Buffer((IMNode)amn);
        buffer.clear();
        IMNode node2 = RecordUtils.buffer2Node((String)"amn", (ByteBuffer)buffer);
        Assert.assertTrue((boolean)amn.getAsMeasurementMNode().getSchema().equals(node2.getAsMeasurementMNode().getSchema()));
        Assert.assertEquals((Object)node2.getAsMeasurementMNode().getAlias(), (Object)amn.getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)true, (Object)node2.getAsMeasurementMNode().isPreDeleted());
    }
}

