/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegment;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InternalPageTest {
    @Before
    public void setUp() {
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Schema_File.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    @Test
    public void initTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        ISegment seg = ISchemaPage.initInternalPage((ByteBuffer)buffer, (int)0, (int)999).getAsInternalPage();
        String[] test = new String[]{"abc", "key3", "key4", "key9", "key5", "key6", "key112", "key888"};
        for (int i = 0; i < test.length; ++i) {
            seg.insertRecord(test[i], (Object)i);
        }
        seg.syncBuffer();
        buffer.clear();
        ISegment seg2 = ISchemaPage.loadSchemaPage((ByteBuffer)buffer).getAsInternalPage();
        Assert.assertEquals((Object)seg.inspect(), (Object)seg2.inspect());
        Assert.assertTrue((boolean)seg2.hasRecordKey("key5"));
        Assert.assertFalse((boolean)seg2.hasRecordKey("key51"));
        Assert.assertEquals((long)2L, (long)((Integer)seg2.getRecordByKey("key41")).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)seg2.getRecordByKey("abd")).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)seg2.getRecordByKey("zzz")).intValue());
    }

    @Test
    public void evenSplitTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(170);
        ISegment seg = ISchemaPage.initInternalPage((ByteBuffer)buffer, (int)0, (int)999).getAsInternalPage();
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a9"};
        for (int i = 0; i < test.length; ++i) {
            seg.insertRecord(test[i], (Object)i);
        }
        ByteBuffer buf2 = ByteBuffer.allocate(170);
        String sk = seg.splitByKey("a8", (Object)666, buf2, true);
        Assert.assertEquals((Object)"a5", (Object)sk);
        buf2.clear();
        ISegment seg2 = ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsInternalPage();
        Assert.assertEquals((long)4L, (long)((Integer)seg2.getRecordByKey("a5")).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)seg2.getRecordByKey("a6")).intValue());
        Assert.assertEquals((long)999L, (long)((Integer)seg.getRecordByKey("a")).intValue());
    }

    @Test
    public void increasingSplitTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(300);
        ISegment seg = ISchemaPage.initInternalPage((ByteBuffer)buffer, (int)0, (int)999).getAsInternalPage();
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a9"};
        for (int i = 0; i < test.length; ++i) {
            seg.insertRecord(test[i], (Object)i);
        }
        seg.insertRecord("a61", (Object)10);
        seg.insertRecord("a62", (Object)11);
        seg.insertRecord("a63", (Object)12);
        ByteBuffer buf2 = ByteBuffer.allocate(300);
        String sk = seg.splitByKey("a99", (Object)666, buf2, true);
        Assert.assertEquals((Object)"a9", (Object)sk);
        buf2.clear();
        Assert.assertEquals((Object)7, (Object)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsInternalPage().getRecordByKey("a91"));
        Assert.assertEquals((long)117L, (long)seg.insertRecord("a1", (Object)0));
        buf2.clear();
        seg.insertRecord("a21", (Object)20);
        seg.insertRecord("a22", (Object)21);
        seg.insertRecord("a23", (Object)22);
        sk = seg.splitByKey("a64", (Object)6464, buf2, true);
        Assert.assertEquals((Object)"a63", (Object)sk);
        seg.insertRecord("a11", (Object)11);
        seg.insertRecord("a12", (Object)12);
        buf2.clear();
        sk = seg.splitByKey("a24", (Object)24, buf2, true);
        Assert.assertEquals((Object)"a23", (Object)sk);
        buf2.clear();
        Assert.assertEquals((Object)24, (Object)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsInternalPage().getRecordByKey("a24"));
        Assert.assertEquals((long)172L, (long)seg.insertRecord("a1", (Object)0));
        buf2.clear();
        Assert.assertEquals((long)159L, (long)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsInternalPage().insertRecord("a24", (Object)0));
    }

    @Test
    public void decreasingSplitTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(300);
        ISegment seg = ISchemaPage.initInternalPage((ByteBuffer)buffer, (int)0, (int)999).getAsInternalPage();
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a9"};
        for (int i = test.length - 1; i >= 0; --i) {
            seg.insertRecord(test[i], (Object)i);
        }
        ByteBuffer buf2 = ByteBuffer.allocate(300);
        String sk = seg.splitByKey("a0", (Object)90, buf2, true);
        Assert.assertEquals((Object)"a1", (Object)sk);
        Assert.assertEquals((long)246L, (long)seg.insertRecord("a0", (Object)9));
        buf2.clear();
        Assert.assertEquals((long)162L, (long)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsInternalPage().insertRecord("a2", (Object)0));
        seg.insertRecord("a13", (Object)12);
        seg.insertRecord("a12", (Object)11);
        sk = seg.splitByKey("a11", (Object)110, buf2, true);
        Assert.assertEquals((Object)"a11", (Object)sk);
        Assert.assertEquals((long)246L, (long)seg.insertRecord("a0", (Object)1));
        buf2.clear();
        Assert.assertEquals((Object)110, (Object)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsInternalPage().getRecordByKey("a11"));
    }

    @Test
    public void increasingOnLowIndex() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(300);
        ISegment seg = ISchemaPage.initInternalPage((ByteBuffer)buffer, (int)0, (int)999).getAsInternalPage();
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9"};
        for (int i = 0; i < test.length; ++i) {
            seg.insertRecord(test[i], (Object)i);
        }
        seg.insertRecord("a01", (Object)10);
        seg.insertRecord("a02", (Object)20);
        ByteBuffer buf2 = ByteBuffer.allocate(300);
        String sk = seg.splitByKey("a04", (Object)30, buf2, true);
        Assert.assertEquals((Object)"a3", (Object)sk);
        Assert.assertEquals((long)6L, (long)seg.getAllRecords().size());
    }

    public void print(ByteBuffer buf) throws MetadataException {
        System.out.println(ISchemaPage.loadSchemaPage((ByteBuffer)buf).getAsInternalPage().inspect());
    }

    public void print(Object s) {
        System.out.println(s);
    }
}

