/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.disk;

import java.util.Collections;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.estimator.BasicMNodSizeEstimator;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.CachedMNodeSizeEstimator;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.IMemManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.MemManagerHolder;
import org.apache.iotdb.db.metadata.rescon.MemoryStatistics;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class MemManagerTest {
    private IoTDBConfig config;
    private long rawMemorySize;

    @Before
    public void setUp() throws Exception {
        this.config = IoTDBDescriptor.getInstance().getConfig();
        this.config.setSchemaEngineMode(SchemaEngineMode.Schema_File.toString());
        this.rawMemorySize = this.config.getAllocateMemoryForSchemaRegion();
        this.config.setAllocateMemoryForSchemaRegion(1500L);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        this.config.setAllocateMemoryForSchemaRegion(this.rawMemorySize);
        this.config.setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    @Test
    public void testNodeEstimatedSizeBasedMemControl() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        MemoryStatistics memoryStatistics = MemoryStatistics.getInstance();
        IMemManager memManager = MemManagerHolder.getMemManagerInstance();
        IStorageGroupMNode storageGroupMNode = schemaProcessor.getStorageGroupNodeByPath(new PartialPath("root.laptop"));
        IMNode deviceNode = schemaProcessor.getDeviceNode(new PartialPath("root.laptop.d1"));
        IMeasurementMNode measurementMNode = schemaProcessor.getMeasurementMNode(new PartialPath("root.laptop.d1.s1"));
        BasicMNodSizeEstimator basicMNodSizeEstimator = new BasicMNodSizeEstimator();
        int permSgSize = basicMNodSizeEstimator.estimateSize((IMNode)storageGroupMNode);
        CachedMNodeSizeEstimator cachedMNodeSizeEstimator = new CachedMNodeSizeEstimator();
        int cachedSgSize = cachedMNodeSizeEstimator.estimateSize((IMNode)storageGroupMNode);
        int deviceSize = cachedMNodeSizeEstimator.estimateSize(deviceNode);
        int measurementSize = cachedMNodeSizeEstimator.estimateSize((IMNode)measurementMNode);
        Assert.assertEquals((long)(cachedSgSize + deviceSize), (long)memManager.getPinnedSize());
        int possibleAllMemUsage = permSgSize + cachedSgSize + deviceSize + measurementSize;
        int possibleMemUsageWithoutMeasurement = permSgSize + cachedSgSize + deviceSize;
        Assert.assertTrue((memoryStatistics.getMemoryUsage() == (long)possibleAllMemUsage || memoryStatistics.getMemoryUsage() == (long)possibleMemUsageWithoutMeasurement ? 1 : 0) != 0);
        Assert.assertTrue((memManager.getCachedSize() == (long)measurementSize || memManager.getCachedSize() == 0L ? 1 : 0) != 0);
    }
}

