/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MNodeTest {
    private static ExecutorService service;

    @Before
    public void setUp() throws Exception {
        service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setDaemon(false).setNameFormat("replaceChild-%d").build());
    }

    @Test
    public void testReplaceChild() {
        InternalMNode rootNode = new InternalMNode(null, "root");
        EntityMNode aNode = new EntityMNode((IMNode)rootNode, "a");
        rootNode.addChild(aNode.getName(), (IMNode)aNode);
        IMeasurementMNode bNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)aNode, (String)"b", null, null);
        aNode.addChild(bNode.getName(), (IMNode)bNode);
        aNode.addAlias("aliasOfb", bNode);
        EntityMNode newANode = new EntityMNode(null, "a");
        rootNode.replaceChild(aNode.getName(), (IMNode)newANode);
        List multiFullPaths = MetaUtils.getMultiFullPaths((IMNode)rootNode);
        Assert.assertEquals((Object)"root.a.b", multiFullPaths.get(0));
        Assert.assertEquals((Object)"root.a.b", (Object)rootNode.getChild("a").getChild("aliasOfb").getFullPath());
        Assert.assertNotSame((Object)aNode, (Object)rootNode.getChild("a"));
        Assert.assertSame((Object)newANode, (Object)rootNode.getChild("a"));
    }

    @Test
    public void testAddChild() {
        InternalMNode rootNode = new InternalMNode(null, "root");
        IMNode speedNode = rootNode.addChild((IMNode)new InternalMNode(null, "sg1")).addChild((IMNode)new InternalMNode(null, "a")).addChild((IMNode)new InternalMNode(null, "b")).addChild((IMNode)new InternalMNode(null, "c")).addChild((IMNode)new InternalMNode(null, "d")).addChild((IMNode)new InternalMNode(null, "device")).addChild((IMNode)new InternalMNode(null, "speed"));
        Assert.assertEquals((Object)"root.sg1.a.b.c.d.device.speed", (Object)speedNode.getFullPath());
        IMNode temperatureNode = rootNode.getChild("sg1").addChild((IMNode)new InternalMNode(null, "aa")).addChild((IMNode)new InternalMNode(null, "bb")).addChild((IMNode)new InternalMNode(null, "cc")).addChild((IMNode)new InternalMNode(null, "dd")).addChild((IMNode)new InternalMNode(null, "device11")).addChild((IMNode)new InternalMNode(null, "temperature"));
        Assert.assertEquals((Object)"root.sg1.aa.bb.cc.dd.device11.temperature", (Object)temperatureNode.getFullPath());
    }
}

