/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemplateTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testCreateSchemaTemplateSerialization() throws IOException {
        CreateTemplatePlan plan = this.getTreeTemplatePlan();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        plan.serialize(dos);
        byte[] byteArray = baos.toByteArray();
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        Assert.assertEquals((long)PhysicalPlan.PhysicalPlanType.CREATE_TEMPLATE.ordinal(), (long)buffer.get());
        CreateTemplatePlan deserializedPlan = new CreateTemplatePlan();
        deserializedPlan.deserialize(buffer);
        Assert.assertEquals(((List)plan.getCompressors().get(0)).get(0), ((List)deserializedPlan.getCompressors().get(0)).get(0));
        Assert.assertEquals((long)plan.getMeasurements().size(), (long)deserializedPlan.getMeasurements().size());
        Assert.assertEquals((Object)plan.getName(), (Object)deserializedPlan.getName());
    }

    private CreateTemplatePlan getTreeTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("d1.s1"));
        measurementList.add(Collections.singletonList("s2"));
        measurementList.add(Arrays.asList("GPS.x", "GPS.y"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Arrays.asList(TSDataType.FLOAT, TSDataType.FLOAT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Arrays.asList(TSEncoding.RLE, TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(CompressionType.UNCOMPRESSED));
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        return new CreateTemplatePlan("treeTemplate", measurementList, dataTypeList, encodingList, compressionTypes);
    }

    private CreateTemplatePlan getCreateTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s11"));
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("vector.s" + i);
        }
        measurementList.add(measurements);
        ArrayList<List<Object>> dataTypeList = new ArrayList<List<Object>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList<List<Object>> encodingList = new ArrayList<List<Object>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList<List<Object>> compressionTypes = new ArrayList<List<Object>>();
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressorList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s21");
        schemaNames.add("vector");
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    private CreateTemplatePlan getDirectAlignedTemplate() {
        ArrayList measurementList = new ArrayList();
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("vs" + i);
        }
        measurementList.add(measurements);
        ArrayList dataTypeList = new ArrayList();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList encodingList = new ArrayList();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList compressionTypes = new ArrayList();
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressorList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("vector");
        return new CreateTemplatePlan("templateDA", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }
}

