/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SchemaBasicTest {
    private CompressionType compressionType;

    @Before
    public void setUp() {
        this.compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        this.setConfig();
        EnvironmentUtils.envSetUp();
    }

    protected abstract void setConfig();

    protected abstract void rollBackConfig();

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        this.rollBackConfig();
    }

    @Test
    public void testAddPathAndExist() throws IllegalPathException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop")));
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d1"));
            schemaProcessor.setStorageGroup(new PartialPath("root.`1`"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`")));
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.laptop have already been created as database", (Object)e.getMessage());
        }
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s1")));
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.1_2"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.`\"1.2.3\"`"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.`1`.`2`.`3`"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s1")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.1_2")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.`\"1.2.3\"`")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`.`2`")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`.`2`.`3`")));
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
            Assert.fail((String)e1.getMessage());
        }
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s1")));
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root")));
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
            Assert.fail((String)e1.getMessage());
        }
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
            Assert.fail((String)e1.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d2")));
        Assert.assertFalse((boolean)schemaProcessor.checkStorageGroupByPath(new PartialPath("root.laptop.d2")));
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop1"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)String.format("The seriesPath of %s already exist, it can't be set to the database", "root.laptop1"), (Object)e.getMessage());
        }
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.1_2"));
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.`\"1.2.3\"`"));
            schemaProcessor.deleteTimeseries(new PartialPath("root.`1`.`2`.`3`"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.1_2")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.`\"1.2.3\"`")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`.`2`.`3`")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`.`2`")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`")));
        try {
            schemaProcessor.deleteStorageGroups(Collections.singletonList(new PartialPath("root.`1`")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`")));
    }

    @Test
    public void testDeleteNonExistentTimeseries() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.non.existent"));
            Assert.fail();
        }
        catch (PathNotExistException e) {
            Assert.assertEquals((Object)"Path [root.non.existent] does not exist", (Object)e.getMessage());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateAlignedTimeseries() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            schemaProcessor.createAlignedTimeSeries(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"INT32"), TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s2")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s3")));
        schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.aligned_device.*"));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s1")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s2")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s3")));
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        try {
            schemaProcessor.createAlignedTimeSeries(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s0", "s2", "s4"), Arrays.asList(TSDataType.valueOf((String)"INT32"), TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s0")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s2")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s4")));
    }

    @Test
    public void testGetAllTimeseriesCount() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s2.t1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.**")), (long)6L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.**")), (long)6L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*")), (long)1L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*.*")), (long)4L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*.**")), (long)5L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*.*.t1")), (long)1L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*.s1")), (long)2L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d1.**")), (long)3L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d1.*")), (long)2L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d2.s1")), (long)1L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d2.**")), (long)2L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop")), (long)0L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d3.s1")), (long)0L);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetStorageGroupAndExist() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root1.laptop.d2")));
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d1"));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1.s1")));
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d2"));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRecover() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d1"));
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d2"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
            TreeSet<String> devices = new TreeSet<String>(){
                {
                    this.add("root.laptop.d1");
                    this.add("root.laptop.d2");
                }
            };
            Assert.assertEquals((Object)devices, schemaProcessor.getMatchedDevices(new PartialPath("root.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            schemaProcessor.deleteStorageGroups(Collections.singletonList(new PartialPath("root.laptop.d2")));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
            devices.remove("root.laptop.d2");
            Assert.assertEquals((Object)devices, schemaProcessor.getMatchedDevices(new PartialPath("root.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            EnvironmentUtils.restartDaemon();
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
            Assert.assertEquals((Object)devices, schemaProcessor.getMatchedDevices(new PartialPath("root.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetAllFileNamesByPath() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d1"));
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d2"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            ArrayList<PartialPath> list = new ArrayList<PartialPath>();
            list.add(new PartialPath("root.laptop.d1"));
            Assert.assertEquals(list, (Object)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals(list, (Object)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.laptop.d1")));
            list.add(new PartialPath("root.laptop.d2"));
            Assert.assertEquals(list, (Object)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.laptop.**")));
            Assert.assertEquals(list, (Object)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.**")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCheckStorageExistOfPath() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            Assert.assertTrue((boolean)schemaProcessor.getMeasurementPaths(new PartialPath("root")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle.device0")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle.device0.sensor")).isEmpty());
            schemaProcessor.setStorageGroup(new PartialPath("root.vehicle"));
            Assert.assertFalse((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertFalse((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle.device0")).isEmpty());
            Assert.assertFalse((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle.device0.sensor")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device0")).isEmpty());
            schemaProcessor.setStorageGroup(new PartialPath("root.vehicle1.device0"));
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device1")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device2")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device3")).isEmpty());
            Assert.assertFalse((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device0")).isEmpty());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testShowChildNodesWithGivenPrefix() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            HashSet<String> nodes = new HashSet<String>(Arrays.asList("s1", "s2"));
            HashSet<String> nodes2 = new HashSet<String>(Arrays.asList("laptop"));
            HashSet<String> nodes3 = new HashSet<String>(Arrays.asList("d1", "d2"));
            Set nexLevelNodes1 = schemaProcessor.getChildNodeNameInNextLevel(new PartialPath("root.laptop.d1"));
            Set nexLevelNodes2 = schemaProcessor.getChildNodeNameInNextLevel(new PartialPath("root"));
            Set nexLevelNodes3 = schemaProcessor.getChildNodeNameInNextLevel(new PartialPath("root.laptop"));
            Assert.assertEquals(nodes, (Object)nexLevelNodes1);
            Assert.assertEquals(nodes2, (Object)nexLevelNodes2);
            Assert.assertEquals(nodes3, (Object)nexLevelNodes3);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetStorageGroupNameByAutoLevel() {
        int level = IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel();
        try {
            Assert.assertEquals((Object)"root.laptop", (Object)MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root.laptop.d1.s1"), (int)level).getFullPath());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        boolean caughtException = false;
        try {
            MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root1.laptop.d1.s1"), (int)level);
        }
        catch (MetadataException e) {
            caughtException = true;
            Assert.assertEquals((Object)"root1.laptop.d1.s1 is not a legal path", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)caughtException);
        caughtException = false;
        try {
            MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root"), (int)level);
        }
        catch (MetadataException e) {
            caughtException = true;
            Assert.assertEquals((Object)"root is not a legal path", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)caughtException);
    }

    @Test
    public void testGetDevicesWithGivenPrefix() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            TreeSet<String> devices = new TreeSet<String>();
            devices.add("root.laptop.d1");
            devices.add("root.laptop.d2");
            Assert.assertEquals(devices, schemaProcessor.getMatchedDevices(new PartialPath("root.laptop.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            schemaProcessor.setStorageGroup(new PartialPath("root.vehicle"));
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            devices.add("root.vehicle.d1");
            Assert.assertEquals(devices, schemaProcessor.getMatchedDevices(new PartialPath("root.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetChildNodePathInNextLevel() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        String[] res = new String[]{"[TSchemaNode(nodeName:root.laptop, nodeType:2), TSchemaNode(nodeName:root.vehicle, nodeType:2)]", "[TSchemaNode(nodeName:root.laptop.b1, nodeType:3), TSchemaNode(nodeName:root.laptop.b2, nodeType:3)]", "[TSchemaNode(nodeName:root.laptop.b1.d1, nodeType:4), TSchemaNode(nodeName:root.laptop.b1.d2, nodeType:4)]", "[TSchemaNode(nodeName:root.laptop.b1, nodeType:3), TSchemaNode(nodeName:root.laptop.b2, nodeType:3), TSchemaNode(nodeName:root.vehicle.b1, nodeType:3), TSchemaNode(nodeName:root.vehicle.b2, nodeType:3)]", "[TSchemaNode(nodeName:root.laptop.b1.d1, nodeType:4), TSchemaNode(nodeName:root.laptop.b1.d2, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d0, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d2, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d3, nodeType:4)]", "[TSchemaNode(nodeName:root.laptop.b1.d1, nodeType:4), TSchemaNode(nodeName:root.laptop.b1.d2, nodeType:4)]", "[TSchemaNode(nodeName:root.vehicle.b1.d0, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d2, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d3, nodeType:4), TSchemaNode(nodeName:root.vehicle.b2.d0, nodeType:4)]", "[TSchemaNode(nodeName:root.laptop.b1.d1.s0, nodeType:5), TSchemaNode(nodeName:root.laptop.b1.d1.s1, nodeType:5), TSchemaNode(nodeName:root.laptop.b1.d2.s0, nodeType:5), TSchemaNode(nodeName:root.laptop.b2.d1.s1, nodeType:5), TSchemaNode(nodeName:root.laptop.b2.d1.s3, nodeType:5), TSchemaNode(nodeName:root.laptop.b2.d2.s2, nodeType:5)]", "[]"};
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.setStorageGroup(new PartialPath("root.vehicle"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b1.d1.s0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b1.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b1.d2.s0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b2.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b2.d1.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b2.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.b1.d0.s0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.b1.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.b1.d3.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.b2.d0.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((Object)res[0], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root")).toString());
            Assert.assertEquals((Object)res[1], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.laptop")).toString());
            Assert.assertEquals((Object)res[2], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.laptop.b1")).toString());
            Assert.assertEquals((Object)res[3], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.*")).toString());
            Assert.assertEquals((Object)res[4], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.*.b1")).toString());
            Assert.assertEquals((Object)res[5], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.l*.b1")).toString());
            Assert.assertEquals((Object)res[6], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.v*.*")).toString());
            Assert.assertEquals((Object)res[7], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.l*.b*.*")).toString());
            Assert.assertEquals((Object)res[8], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.laptopp")).toString());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private CreateTemplatePlan getTreeTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("d1.s1"));
        measurementList.add(Collections.singletonList("s2"));
        measurementList.add(Arrays.asList("GPS.x", "GPS.y"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        dataTypeList.add(Arrays.asList(TSDataType.FLOAT, TSDataType.FLOAT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Arrays.asList(TSEncoding.RLE, TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(CompressionType.GZIP));
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        return new CreateTemplatePlan("treeTemplate", measurementList, dataTypeList, encodingList, compressionTypes);
    }

    private CreateTemplatePlan getCreateTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s11"));
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("vector.s" + i);
        }
        measurementList.add(measurements);
        ArrayList<List<Object>> dataTypeList = new ArrayList<List<Object>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList<List<Object>> encodingList = new ArrayList<List<Object>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList<List<Object>> compressionTypes = new ArrayList<List<Object>>();
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressorList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s21");
        schemaNames.add("vector");
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    @Test
    public void testShowTimeseries() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.laptop.d1.s0"), false, null, null, 0, 0, false);
            List result = schemaProcessor.showTimeseries(showTimeSeriesPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"root.laptop.d1.s0", (Object)((ShowTimeSeriesResult)result.get(0)).getName());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTotalSeriesNumber() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s2.t1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((long)6L, (long)schemaProcessor.getTotalSeriesNumber());
            EnvironmentUtils.restartDaemon();
            Assert.assertEquals((long)6L, (long)schemaProcessor.getTotalSeriesNumber());
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d2.s1"));
            Assert.assertEquals((long)5L, (long)schemaProcessor.getTotalSeriesNumber());
            schemaProcessor.deleteStorageGroups(Collections.singletonList(new PartialPath("root.laptop")));
            Assert.assertEquals((long)0L, (long)schemaProcessor.getTotalSeriesNumber());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStorageGroupNameWithHyphen() throws IllegalPathException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.group_with_hyphen")));
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.group_with_hyphen"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.group_with_hyphen")));
    }

    @Test
    public void testCreateTimeseriesAndInsertWithAlignedData() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.aligned_device.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.aligned_device.s2"), TSDataType.valueOf((String)"INT64"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            schemaProcessor.createAlignedTimeSeries(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s3", "s4", "s5"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Timeseries under this entity is not aligned, please use createTimeseries or change entity. (Path: root.laptop.d1.aligned_device)", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateAlignedTimeseriesWithIllegalNames() throws Exception {
        String[] measurementIds;
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
        PartialPath deviceId = new PartialPath("root.laptop.d1");
        for (String measurementId : measurementIds = new String[]{"time", "timestamp", "TIME", "TIMESTAMP"}) {
            PartialPath path = deviceId.concatNode(measurementId);
            try {
                schemaProcessor.createAlignedTimeSeries(path, Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertEquals((Object)String.format("%s is not a legal path, because %s", path.getFullPath(), String.format("%s is an illegal name.", measurementId)), (Object)e.getMessage());
            }
        }
        PartialPath path = deviceId.concatNode("t1");
        for (String measurementId : measurementIds) {
            try {
                schemaProcessor.createAlignedTimeSeries(path, Arrays.asList(measurementId, "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertEquals((Object)String.format("%s is an illegal name.", measurementId), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCreateAlignedTimeseriesWithAliasAndTags() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
        PartialPath devicePath = new PartialPath("root.laptop.device0");
        List<String> measurements = Arrays.asList("s1", "s2", "s3", "s4", "s5");
        List<TSDataType> tsDataTypes = Arrays.asList(TSDataType.DOUBLE, TSDataType.TEXT, TSDataType.FLOAT, TSDataType.BOOLEAN, TSDataType.INT32);
        List<TSEncoding> tsEncodings = Arrays.asList(TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN);
        List<CompressionType> compressionTypes = Arrays.asList(CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED);
        List<String> aliasList = Arrays.asList("alias1", null, "alias2", null, null);
        ArrayList tagList = new ArrayList();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("key", "value");
        tagList.add(tags);
        tagList.add(null);
        tagList.add(null);
        tagList.add(tags);
        tagList.add(null);
        CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = new CreateAlignedTimeSeriesPlan(devicePath, measurements, tsDataTypes, tsEncodings, compressionTypes, aliasList, tagList, null);
        schemaProcessor.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
        Assert.assertEquals((long)5L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.device0.*")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.device0.alias2")));
        ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.**"), false, "key", "value", 0, 0, false);
        List showTimeSeriesResults = schemaProcessor.showTimeseries(showTimeSeriesPlan, null);
        Assert.assertEquals((long)2L, (long)showTimeSeriesResults.size());
        showTimeSeriesResults = showTimeSeriesResults.stream().sorted(Comparator.comparing(ShowResult::getName)).collect(Collectors.toList());
        ShowTimeSeriesResult result = (ShowTimeSeriesResult)showTimeSeriesResults.get(0);
        Assert.assertEquals((Object)"root.laptop.device0.s1", (Object)result.getName());
        Assert.assertEquals((Object)"alias1", (Object)result.getAlias());
        Assert.assertEquals(tags, (Object)result.getTag());
        result = (ShowTimeSeriesResult)showTimeSeriesResults.get(1);
        Assert.assertEquals((Object)"root.laptop.device0.s4", (Object)result.getName());
        Assert.assertEquals(tags, (Object)result.getTag());
    }

    @Test
    public void testGetStorageGroupNodeByPath() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        PartialPath partialPath = null;
        try {
            partialPath = new PartialPath("root.ln.sg1");
        }
        catch (IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.setStorageGroup(partialPath);
        }
        catch (MetadataException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            partialPath = new PartialPath("root.ln.sg2.device1.sensor1");
        }
        catch (IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.getStorageGroupNodeByPath(partialPath);
        }
        catch (StorageGroupNotSetException e) {
            Assert.assertEquals((Object)"Database is not set for current seriesPath: [root.ln.sg2.device1.sensor1]", (Object)e.getMessage());
        }
        catch (StorageGroupAlreadySetException e) {
            Assert.assertEquals((Object)"some children of root.ln have already been created as database", (Object)e.getMessage());
        }
        catch (MetadataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private CreateTemplatePlan getCreateTemplatePlan(String schemaName) {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s0"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(this.compressionType));
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add(schemaName);
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    @Test
    public void testTagIndexRecovery() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        PartialPath path = new PartialPath("root.sg.d.s");
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("description", "oldValue");
        schemaProcessor.createTimeseries(new CreateTimeSeriesPlan(path, TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, null, tags, null, null));
        ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d.s"), true, "description", "Value", 0, 0, false);
        List results = schemaProcessor.showTimeseries(showTimeSeriesPlan, new QueryContext());
        Assert.assertEquals((long)1L, (long)results.size());
        Map resultTag = ((ShowTimeSeriesResult)results.get(0)).getTag();
        Assert.assertEquals((Object)"oldValue", resultTag.get("description"));
        tags.put("description", "newValue");
        schemaProcessor.upsertTagsAndAttributes(null, tags, null, path);
        showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d.s"), true, "description", "Value", 0, 0, false);
        results = schemaProcessor.showTimeseries(showTimeSeriesPlan, new QueryContext());
        Assert.assertEquals((long)1L, (long)results.size());
        resultTag = ((ShowTimeSeriesResult)results.get(0)).getTag();
        Assert.assertEquals((Object)"newValue", resultTag.get("description"));
        EnvironmentUtils.restartDaemon();
        showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d.s"), true, "description", "oldValue", 0, 0, false);
        results = schemaProcessor.showTimeseries(showTimeSeriesPlan, new QueryContext());
        Assert.assertEquals((long)0L, (long)results.size());
        showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d.s"), true, "description", "Value", 0, 0, false);
        results = schemaProcessor.showTimeseries(showTimeSeriesPlan, new QueryContext());
        Assert.assertEquals((long)1L, (long)results.size());
        resultTag = ((ShowTimeSeriesResult)results.get(0)).getTag();
        Assert.assertEquals((Object)"newValue", resultTag.get("description"));
    }
}

