/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.localconfignode;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.localconfignode.LocalDataPartitionInfo;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalConfigNodeMultiDataRegionTest {
    int originDataRegionNum;
    boolean isClusterMode = false;

    @Before
    public void setUp() throws IllegalPathException {
        this.originDataRegionNum = IoTDBDescriptor.getInstance().getConfig().getDataRegionNum();
        this.isClusterMode = IoTDBDescriptor.getInstance().getConfig().isClusterMode();
        IoTDBDescriptor.getInstance().getConfig().setClusterMode(false);
        IoTDB.configManager.init();
        EnvironmentUtils.envSetUp();
        LocalDataPartitionInfo.getInstance().init(Collections.EMPTY_MAP);
    }

    @After
    public void tearDown() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setDataRegionNum(this.originDataRegionNum);
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setClusterMode(this.isClusterMode);
    }

    @Test
    public void createMultiDataRegionTest() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setDataRegionNum(3);
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.test"));
        LocalConfigNode configNode = LocalConfigNode.getInstance();
        LocalDataPartitionInfo info = LocalDataPartitionInfo.getInstance();
        info.registerStorageGroup(new PartialPath("root.test"));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath("root.test.d1"));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath("root.test.d2"));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath("root.test.d3"));
        List regionIds = info.getDataRegionIdsByStorageGroup(new PartialPath("root.test"));
        Assert.assertEquals((long)3L, (long)regionIds.size());
    }

    @Test
    public void recoverMultiDataRegionTest() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setDataRegionNum(3);
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.test"));
        LocalConfigNode configNode = LocalConfigNode.getInstance();
        LocalDataPartitionInfo info = LocalDataPartitionInfo.getInstance();
        info.registerStorageGroup(new PartialPath("root.test"));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath("root.test.d1"));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath("root.test.d2"));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath("root.test.d3"));
        LocalConfigNode.getInstance().clear();
        LocalConfigNode.getInstance().init();
        info = LocalDataPartitionInfo.getInstance();
        info.registerStorageGroup(new PartialPath("root.test"));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath("root.test.d1"));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath("root.test.d2"));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath("root.test.d3"));
        List regionIds = info.getDataRegionIdsByStorageGroup(new PartialPath("root.test"));
        Assert.assertEquals((long)3L, (long)regionIds.size());
    }
}

