/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.engine.storagegroup.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileResourceTest {
    private final File file = new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)1L, (long)1L, (int)1, (int)1));
    private final TsFileResource tsFileResource = new TsFileResource(this.file);
    private final Map<String, Integer> deviceToIndex = new HashMap<String, Integer>();
    private final long[] startTimes = new long[100];
    private final long[] endTimes = new long[100];
    private static final int DEVICE_NUM = 100;

    @Before
    public void setUp() {
        IntStream.range(0, 100).forEach(i -> this.deviceToIndex.put("root.sg.d" + i, i));
        DeviceTimeIndex deviceTimeIndex = new DeviceTimeIndex(this.deviceToIndex, this.startTimes, this.endTimes);
        IntStream.range(0, 100).forEach(i -> {
            deviceTimeIndex.updateStartTime("root.sg.d" + i, (long)i);
            deviceTimeIndex.updateEndTime("root.sg.d" + i, (long)(i + 1));
        });
        this.tsFileResource.setTimeIndex((ITimeIndex)deviceTimeIndex);
        this.tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
    }

    @After
    public void tearDown() throws IOException {
        File resourceFile;
        if (this.file.exists()) {
            FileUtils.delete((File)this.file);
        }
        if ((resourceFile = new File(this.file.getName() + ".resource")).exists()) {
            FileUtils.delete((File)resourceFile);
        }
    }

    @Test
    public void testSerializeAndDeserialize() throws IOException {
        this.tsFileResource.serialize();
        TsFileResource derTsFileResource = new TsFileResource(this.file);
        derTsFileResource.deserialize();
        Assert.assertEquals((Object)this.tsFileResource, (Object)derTsFileResource);
    }

    @Test
    public void testDegradeAndFileTimeIndex() {
        Assert.assertEquals((long)1L, (long)this.tsFileResource.getTimeIndexType());
        this.tsFileResource.degradeTimeIndex();
        Assert.assertEquals((long)2L, (long)this.tsFileResource.getTimeIndexType());
        Assert.assertEquals(this.deviceToIndex.keySet(), (Object)this.tsFileResource.getDevices());
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((long)this.tsFileResource.getStartTime("root.sg1.d" + i), (long)0L);
            Assert.assertEquals((long)this.tsFileResource.getEndTime("root.sg1.d" + i), (long)100L);
        }
    }
}

