/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.IOException;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TimePartitionInfo;
import org.apache.iotdb.db.engine.storagegroup.TimePartitionManager;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimePartitionManagerTest {
    private final TimePartitionManager timePartitionManager = TimePartitionManager.getInstance();
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private long prevTimePartitionInfoMemoryThreshold;

    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        this.prevTimePartitionInfoMemoryThreshold = CONFIG.getAllocateMemoryForTimePartitionInfo();
        this.timePartitionManager.setTimePartitionInfoMemoryThreshold(100L);
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        this.timePartitionManager.setTimePartitionInfoMemoryThreshold(this.prevTimePartitionInfoMemoryThreshold);
        this.timePartitionManager.clear();
    }

    @Test
    public void testRegisterPartitionInfo() {
        TimePartitionInfo timePartitionInfo1 = new TimePartitionInfo(new DataRegionId(1), 0L, true, Long.MAX_VALUE, 0L, true);
        this.timePartitionManager.registerTimePartitionInfo(timePartitionInfo1);
        Assert.assertEquals((Object)timePartitionInfo1, (Object)this.timePartitionManager.getTimePartitionInfo(new DataRegionId(1), 0L));
        TimePartitionInfo timePartitionInfo2 = new TimePartitionInfo(new DataRegionId(1), 1L, true, Long.MAX_VALUE, 0L, true);
        this.timePartitionManager.registerTimePartitionInfo(timePartitionInfo2);
        Assert.assertFalse((boolean)this.timePartitionManager.getTimePartitionInfo((DataRegionId)new DataRegionId((int)1), (long)0L).isLatestPartition);
        Assert.assertTrue((boolean)this.timePartitionManager.getTimePartitionInfo((DataRegionId)new DataRegionId((int)1), (long)1L).isLatestPartition);
    }

    @Test
    public void testUpdate() {
        TimePartitionInfo timePartitionInfo = new TimePartitionInfo(new DataRegionId(1), 0L, true, Long.MAX_VALUE, 0L, true);
        this.timePartitionManager.registerTimePartitionInfo(timePartitionInfo);
        this.timePartitionManager.updateAfterFlushing(new DataRegionId(1), 0L, 100L, 100L, false);
        TimePartitionInfo timePartitionInfo1 = this.timePartitionManager.getTimePartitionInfo(new DataRegionId(1), 0L);
        Assert.assertTrue((boolean)timePartitionInfo1.isLatestPartition);
        Assert.assertEquals((long)timePartitionInfo1.lastSystemFlushTime, (long)100L);
        Assert.assertEquals((long)timePartitionInfo1.memSize, (long)100L);
        Assert.assertFalse((boolean)timePartitionInfo1.isActive);
        this.timePartitionManager.updateAfterOpeningTsFileProcessor(new DataRegionId(1), 0L);
        TimePartitionInfo timePartitionInfo2 = this.timePartitionManager.getTimePartitionInfo(new DataRegionId(1), 0L);
        Assert.assertTrue((boolean)timePartitionInfo2.isActive);
    }

    @Test
    public void testMemoryControl() {
        for (int i = 0; i < 5; ++i) {
            TimePartitionInfo timePartitionInfo = new TimePartitionInfo(new DataRegionId(i), 0L, true, Long.MAX_VALUE, 0L, true);
            this.timePartitionManager.registerTimePartitionInfo(timePartitionInfo);
        }
        this.timePartitionManager.updateAfterFlushing(new DataRegionId(0), 0L, 100L, 20L, false);
        this.timePartitionManager.updateAfterFlushing(new DataRegionId(1), 0L, 101L, 20L, true);
        this.timePartitionManager.updateAfterFlushing(new DataRegionId(2), 0L, 102L, 20L, false);
        this.timePartitionManager.updateAfterFlushing(new DataRegionId(3), 0L, 103L, 20L, false);
        this.timePartitionManager.updateAfterFlushing(new DataRegionId(4), 0L, 104L, 20L, true);
        this.timePartitionManager.registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(0), 1L, true, Long.MAX_VALUE, 0L, true));
        this.timePartitionManager.updateAfterFlushing(new DataRegionId(0), 1L, 105L, 20L, true);
        Assert.assertNull((Object)this.timePartitionManager.getTimePartitionInfo(new DataRegionId(0), 0L));
        this.timePartitionManager.updateAfterFlushing(new DataRegionId(0), 1L, 106L, 40L, true);
        Assert.assertNull((Object)this.timePartitionManager.getTimePartitionInfo(new DataRegionId(2), 0L));
        this.timePartitionManager.updateAfterFlushing(new DataRegionId(0), 1L, 107L, 60L, true);
        Assert.assertNull((Object)this.timePartitionManager.getTimePartitionInfo(new DataRegionId(3), 0L));
    }
}

