/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.UnSetTTLStatement;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.SchemaTestUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TTLTest {
    private String sg1 = "root.TTL_SG1";
    private DataRegionId dataRegionId1 = new DataRegionId(1);
    private String sg2 = "root.TTL_SG2";
    private DataRegionId dataRegionId2 = new DataRegionId(1);
    private long ttl = 12345L;
    private DataRegion dataRegion;
    private String s1 = "s1";
    private String g1s1 = this.sg1 + '.' + this.s1;
    private long prevPartitionInterval;

    @Before
    public void setUp() throws MetadataException, DataRegionException {
        this.prevPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval();
        IoTDBDescriptor.getInstance().getConfig().setTimePartitionInterval(86400000L);
        EnvironmentUtils.envSetUp();
        this.createSchemas();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setTimePartitionInterval(this.prevPartitionInterval);
    }

    private void createSchemas() throws MetadataException, DataRegionException {
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(this.sg1));
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(this.sg2));
        this.dataRegion = new DataRegion(IoTDBDescriptor.getInstance().getConfig().getSystemDir(), String.valueOf(this.dataRegionId1.getId()), (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), this.sg1);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(this.g1s1), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, Collections.emptyMap());
    }

    @Test
    public void testSetMetaTTL() throws IOException, MetadataException {
        boolean caught = false;
        try {
            IoTDB.schemaProcessor.setTTL(new PartialPath(this.sg1 + ".notExist"), this.ttl);
        }
        catch (MetadataException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        IoTDB.schemaProcessor.setTTL(new PartialPath(this.sg1), this.ttl);
        IStorageGroupMNode mNode = IoTDB.schemaProcessor.getStorageGroupNodeByPath(new PartialPath(this.sg1));
        Assert.assertEquals((long)this.ttl, (long)mNode.getDataTTL());
        mNode = IoTDB.schemaProcessor.getStorageGroupNodeByPath(new PartialPath(this.sg2));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)mNode.getDataTTL());
    }

    @Test
    public void testTTLWrite() throws WriteProcessException, QueryProcessException, IllegalPathException {
        InsertRowNode node = new InsertRowNode(new PlanNodeId("0"), new PartialPath(this.sg1), false, new String[]{"s1"}, new TSDataType[]{TSDataType.INT64}, System.currentTimeMillis(), new Object[]{1L}, false);
        node.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)});
        this.dataRegion.insert(node);
        this.dataRegion.setDataTTL(1000L);
        node.setTime(System.currentTimeMillis() - 1001L);
        boolean caught = false;
        try {
            this.dataRegion.insert(node);
        }
        catch (OutOfTTLException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        node.setTime(System.currentTimeMillis() - 900L);
        this.dataRegion.insert(node);
    }

    private void prepareData() throws WriteProcessException, IllegalPathException {
        int i;
        InsertRowNode node = new InsertRowNode(new PlanNodeId("0"), new PartialPath(this.sg1), false, new String[]{"s1"}, new TSDataType[]{TSDataType.INT64}, System.currentTimeMillis(), new Object[]{1L}, false);
        node.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)});
        long initTime = System.currentTimeMillis();
        for (i = 1000; i < 2000; ++i) {
            node.setTime(initTime - 2000L + (long)i);
            this.dataRegion.insert(node);
            if ((i + 1) % 300 != 0) continue;
            this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        }
        for (i = 0; i < 1000; ++i) {
            node.setTime(initTime - 2000L + (long)i);
            this.dataRegion.insert(node);
            if ((i + 1) % 300 != 0) continue;
            this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        }
    }

    @Test
    public void testTTLRead() throws IOException, WriteProcessException, StorageEngineException, QueryProcessException, MetadataException {
        this.prepareData();
        QueryDataSource dataSource = this.dataRegion.query(Collections.singletonList(SchemaTestUtils.getMeasurementPath(this.sg1 + "." + this.s1)), this.sg1, EnvironmentUtils.TEST_QUERY_CONTEXT, null, null);
        List seqResource = dataSource.getSeqResources();
        List unseqResource = dataSource.getUnseqResources();
        Assert.assertEquals((long)4L, (long)seqResource.size());
        Assert.assertEquals((long)4L, (long)unseqResource.size());
        this.dataRegion.setDataTTL(500L);
        dataSource = this.dataRegion.query(Collections.singletonList(SchemaTestUtils.getMeasurementPath(this.sg1 + "." + this.s1)), this.sg1, EnvironmentUtils.TEST_QUERY_CONTEXT, null, null);
        seqResource = dataSource.getSeqResources();
        unseqResource = dataSource.getUnseqResources();
        Assert.assertTrue((seqResource.size() < 4 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)unseqResource.size());
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.sg1 + "." + this.s1);
        HashSet<String> allSensors = new HashSet<String>();
        allSensors.add(this.s1);
        SeriesRawDataBatchReader reader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, seqResource, unseqResource, null, null, true);
        int cnt = 0;
        while (reader.hasNextBatch()) {
            BatchData batchData = reader.nextBatch();
            while (batchData.hasCurrent()) {
                batchData.next();
                ++cnt;
            }
        }
        reader.close();
        Assert.assertTrue((cnt <= 1000 ? 1 : 0) != 0);
        this.dataRegion.setDataTTL(0L);
        dataSource = this.dataRegion.query(Collections.singletonList(SchemaTestUtils.getMeasurementPath(this.sg1 + "." + this.s1)), this.sg1, EnvironmentUtils.TEST_QUERY_CONTEXT, null, null);
        seqResource = dataSource.getSeqResources();
        unseqResource = dataSource.getUnseqResources();
        Assert.assertEquals((long)0L, (long)seqResource.size());
        Assert.assertEquals((long)0L, (long)unseqResource.size());
    }

    @Test
    public void testTTLRemoval() throws StorageEngineException, WriteProcessException, QueryProcessException, IllegalPathException {
        this.prepareData();
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        File seqDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile(), this.sg1);
        File unseqDir = new File(DirectoryManager.getInstance().getNextFolderForUnSequenceFile(), this.sg1);
        ArrayList<File> seqFiles = new ArrayList<File>();
        for (File directory : seqDir.listFiles()) {
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".tsfile")) continue;
                    seqFiles.add(file);
                }
            }
        }
        ArrayList<File> unseqFiles = new ArrayList<File>();
        for (File directory : unseqDir.listFiles()) {
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".tsfile")) continue;
                    unseqFiles.add(file);
                }
            }
        }
        Assert.assertEquals((long)4L, (long)seqFiles.size());
        Assert.assertEquals((long)4L, (long)unseqFiles.size());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.dataRegion.setDataTTL(500L);
        this.dataRegion.checkFilesTTL();
        seqFiles = new ArrayList();
        for (File directory : seqDir.listFiles()) {
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".tsfile")) continue;
                    seqFiles.add(file);
                }
            }
        }
        unseqFiles = new ArrayList();
        for (File directory : unseqDir.listFiles()) {
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".tsfile")) continue;
                    unseqFiles.add(file);
                }
            }
        }
        Assert.assertTrue((seqFiles.size() <= 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)unseqFiles.size());
    }

    @Test
    public void testParseSetTTL() {
        SetTTLStatement statement1 = (SetTTLStatement)StatementGenerator.createStatement((String)("SET TTL TO " + this.sg1 + " 10000"), (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals((Object)this.sg1, (Object)statement1.getStorageGroupPath().getFullPath());
        Assert.assertEquals((long)10000L, (long)statement1.getTTL());
        UnSetTTLStatement statement2 = (UnSetTTLStatement)StatementGenerator.createStatement((String)("UNSET TTL TO " + this.sg2), (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals((Object)this.sg2, (Object)statement2.getStorageGroupPath().getFullPath());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)statement2.getTTL());
    }

    @Test
    public void testParseShowTTL() {
        ShowTTLStatement statement1 = (ShowTTLStatement)StatementGenerator.createStatement((String)"SHOW ALL TTL", (ZoneId)ZoneId.systemDefault());
        Assert.assertTrue((boolean)statement1.getPaths().isEmpty());
        ArrayList<String> sgs = new ArrayList<String>();
        sgs.add("root.sg1");
        sgs.add("root.sg2");
        sgs.add("root.sg3");
        ShowTTLStatement statement2 = (ShowTTLStatement)StatementGenerator.createStatement((String)"SHOW TTL ON root.sg1,root.sg2,root.sg3", (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(sgs, statement2.getPaths().stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
    }

    @Test
    public void testTTLCleanFile() throws WriteProcessException, QueryProcessException, IllegalPathException {
        this.prepareData();
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertEquals((long)4L, (long)this.dataRegion.getSequenceFileList().size());
        Assert.assertEquals((long)4L, (long)this.dataRegion.getUnSequenceFileList().size());
        this.dataRegion.setDataTTL(0L);
        this.dataRegion.checkFilesTTL();
        Assert.assertEquals((long)0L, (long)this.dataRegion.getSequenceFileList().size());
        Assert.assertEquals((long)0L, (long)this.dataRegion.getUnSequenceFileList().size());
    }
}

