/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.io.LocalTextModificationAccessor;
import org.junit.Assert;
import org.junit.Test;

public class LocalTextModificationAccessorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readMyWrite() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath(new String[]{"d1", "s1"}), 1L, 1L), new Deletion(new PartialPath(new String[]{"d1", "s2"}), 2L, 2L), new Deletion(new PartialPath(new String[]{"d1", "s3"}), 3L, 3L), new Deletion(new PartialPath(new String[]{"d1", "s4"}), 4L, 4L)};
        try (LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(tempFileName);){
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                accessor.write(modifications[i2]);
            }
            List modificationList = (List)accessor.read();
            for (i = 0; i < 2; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
            for (i = 2; i < 4; ++i) {
                accessor.write(modifications[i]);
            }
            modificationList = (List)accessor.read();
            for (i = 0; i < 4; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    @Test
    public void readNull() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(tempFileName);
        new File(tempFileName).delete();
        Collection modifications = accessor.read();
        Assert.assertEquals(new ArrayList(), (Object)modifications);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readAndTruncate() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        File file = new File(tempFileName);
        if (file.exists()) {
            file.delete();
        }
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath(new String[]{"d1", "s1"}), 1L, 1L), new Deletion(new PartialPath(new String[]{"d1", "s2"}), 2L, 2L), new Deletion(new PartialPath(new String[]{"d1", "s3"}), 3L, 3L), new Deletion(new PartialPath(new String[]{"d1", "s4"}), 4L, 4L)};
        try (LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(tempFileName);
             BufferedWriter writer = new BufferedWriter(new FileWriter(tempFileName, true));){
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                accessor.write(modifications[i2]);
            }
            List modificationList = (List)accessor.read();
            for (int i3 = 0; i3 < 2; ++i3) {
                Assert.assertEquals((Object)modifications[i3], modificationList.get(i3));
            }
            long length = file.length();
            writer.write("error");
            writer.newLine();
            writer.flush();
            for (i = 2; i < 4; ++i) {
                accessor.write(modifications[i]);
            }
            modificationList = (List)accessor.read();
            for (i = 0; i < 2; ++i) {
                System.out.println(modificationList);
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
            Assert.assertEquals((long)length, (long)file.length());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            file.delete();
        }
    }
}

