/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.util.concurrent.ExecutionException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.MetadataManagerHelper;
import org.apache.iotdb.db.engine.flush.MemTableFlushTask;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.MemTableTestUtils;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemTableFlushTaskTest {
    private RestorableTsFileIOWriter writer;
    private String storageGroup = "storage_group1";
    private String filePath = TestConstant.OUTPUT_DATA_DIR.concat("testUnsealedTsFileProcessor.tsfile");
    private IMemTable memTable;
    private long startTime = 1L;
    private long endTime = 100L;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        MetadataManagerHelper.initMetadata();
        this.writer = new RestorableTsFileIOWriter(FSFactoryProducer.getFSFactory().getFile(this.filePath));
        this.memTable = new PrimitiveMemTable();
    }

    @After
    public void tearDown() throws Exception {
        this.writer.close();
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
    }

    @Test
    public void testFlushMemTable() throws ExecutionException, InterruptedException, IllegalPathException {
        MemTableTestUtils.produceData(this.memTable, this.startTime, this.endTime, MemTableTestUtils.deviceId0, MemTableTestUtils.measurementId0, MemTableTestUtils.dataType0);
        MemTableFlushTask memTableFlushTask = new MemTableFlushTask(this.memTable, this.writer, this.storageGroup);
        Assert.assertTrue((boolean)this.writer.getVisibleMetadataList(MemTableTestUtils.deviceId0, MemTableTestUtils.measurementId0, MemTableTestUtils.dataType0).isEmpty());
        memTableFlushTask.syncFlushMemTable();
        this.writer.makeMetadataVisible();
        Assert.assertEquals((long)1L, (long)this.writer.getVisibleMetadataList(MemTableTestUtils.deviceId0, MemTableTestUtils.measurementId0, MemTableTestUtils.dataType0).size());
        ChunkMetadata chunkMetaData = (ChunkMetadata)this.writer.getVisibleMetadataList(MemTableTestUtils.deviceId0, MemTableTestUtils.measurementId0, MemTableTestUtils.dataType0).get(0);
        Assert.assertEquals((Object)MemTableTestUtils.measurementId0, (Object)chunkMetaData.getMeasurementUid());
        Assert.assertEquals((long)this.startTime, (long)chunkMetaData.getStartTime());
        Assert.assertEquals((long)this.endTime, (long)chunkMetaData.getEndTime());
        Assert.assertEquals((Object)MemTableTestUtils.dataType0, (Object)chunkMetaData.getDataType());
        Assert.assertEquals((long)(this.endTime - this.startTime + 1L), (long)chunkMetaData.getNumOfPoints());
    }

    @Test
    public void testFlushVectorMemTable() throws ExecutionException, InterruptedException, IllegalPathException, WriteProcessException {
        MemTableTestUtils.produceVectorData(this.memTable);
        MemTableFlushTask memTableFlushTask = new MemTableFlushTask(this.memTable, this.writer, this.storageGroup);
        Assert.assertTrue((boolean)this.writer.getVisibleMetadataList(MemTableTestUtils.deviceId0, "sensor0", TSDataType.BOOLEAN).isEmpty());
        memTableFlushTask.syncFlushMemTable();
        this.writer.makeMetadataVisible();
        Assert.assertEquals((long)1L, (long)this.writer.getVisibleMetadataList(MemTableTestUtils.deviceId0, "sensor0", TSDataType.BOOLEAN).size());
        ChunkMetadata chunkMetaData = (ChunkMetadata)this.writer.getVisibleMetadataList(MemTableTestUtils.deviceId0, "sensor0", TSDataType.BOOLEAN).get(0);
        Assert.assertEquals((Object)"sensor0", (Object)chunkMetaData.getMeasurementUid());
        Assert.assertEquals((long)this.startTime, (long)chunkMetaData.getStartTime());
        Assert.assertEquals((long)this.endTime, (long)chunkMetaData.getEndTime());
        Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)chunkMetaData.getDataType());
        Assert.assertEquals((long)(this.endTime - this.startTime + 1L), (long)chunkMetaData.getNumOfPoints());
    }

    @Test
    public void testFlushNullableVectorMemTable() throws ExecutionException, InterruptedException, IllegalPathException, WriteProcessException {
        MemTableTestUtils.produceNullableVectorData(this.memTable);
        MemTableFlushTask memTableFlushTask = new MemTableFlushTask(this.memTable, this.writer, this.storageGroup);
        Assert.assertTrue((boolean)this.writer.getVisibleMetadataList(MemTableTestUtils.deviceId0, "sensor0", TSDataType.BOOLEAN).isEmpty());
        memTableFlushTask.syncFlushMemTable();
        this.writer.makeMetadataVisible();
        Assert.assertEquals((long)1L, (long)this.writer.getVisibleMetadataList(MemTableTestUtils.deviceId0, "sensor0", TSDataType.BOOLEAN).size());
        ChunkMetadata chunkMetaData = (ChunkMetadata)this.writer.getVisibleMetadataList(MemTableTestUtils.deviceId0, "sensor0", TSDataType.BOOLEAN).get(0);
        Assert.assertEquals((Object)"sensor0", (Object)chunkMetaData.getMeasurementUid());
        Assert.assertEquals((long)this.startTime, (long)chunkMetaData.getStartTime());
        Assert.assertEquals((long)this.endTime, (long)chunkMetaData.getEndTime());
        Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)chunkMetaData.getDataType());
        Assert.assertEquals((long)(this.endTime - this.startTime + 1L), (long)chunkMetaData.getNumOfPoints());
    }
}

