/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.engine.compaction.inner.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTsFileDeviceIteratorTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1024L);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
    }

    @Test
    public void getNonAlignedDevicesFromDifferentFilesWithFourLayersInNodeTreeTest() throws MetadataException, IOException, WriteProcessException {
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
        this.registerTimeseriesInMManger(30, 3, false);
        this.createFiles(3, 10, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(4, 5, 3, 100, 1000, 0, 50, 50, false, true);
        this.createFiles(2, 15, 3, 100, 1000, 0, 50, 50, false, false);
        this.createFiles(3, 30, 3, 100, 1000, 0, 50, 50, false, false);
        ArrayList<String> deviceIds = new ArrayList<String>();
        for (int i = 0; i < 30; ++i) {
            deviceIds.add("root.testsg.d" + i);
        }
        deviceIds.sort(String::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.seqResources, this.unseqResources);){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertFalse((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
    }

    @Test
    public void getAlignedDevicesFromDifferentFilesWithOneLayerInNodeTreeTest() throws MetadataException, IOException, WriteProcessException {
        this.registerTimeseriesInMManger(30, 3, false);
        this.createFiles(3, 10, 3, 100, 0, 0, 50, 50, true, true);
        this.createFiles(4, 5, 3, 100, 1000, 0, 50, 50, true, true);
        this.createFiles(2, 15, 3, 100, 1000, 0, 50, 50, true, false);
        this.createFiles(3, 30, 3, 100, 1000, 0, 50, 50, true, false);
        ArrayList<String> deviceIds = new ArrayList<String>();
        for (int i = 0; i < 30; ++i) {
            deviceIds.add("root.testsg.d" + (i + TsFileGeneratorUtils.getAlignDeviceOffset()));
        }
        deviceIds.sort(String::compareTo);
        int deviceNum = 0;
        try (MultiTsFileDeviceIterator multiTsFileDeviceIterator = new MultiTsFileDeviceIterator(this.seqResources, this.unseqResources);){
            while (multiTsFileDeviceIterator.hasNextDevice()) {
                Pair deviceInfo = multiTsFileDeviceIterator.nextDevice();
                Assert.assertEquals(deviceIds.get(deviceNum), (Object)deviceInfo.left);
                Assert.assertTrue((boolean)((Boolean)deviceInfo.right));
                ++deviceNum;
            }
        }
        Assert.assertEquals((long)30L, (long)deviceNum);
    }
}

