/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.recover;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.engine.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.CompactionRecoverTask;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeTieredCompactionRecoverCompatibleTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws StorageEngineException, IOException {
        super.tearDown();
    }

    @Test
    public void testCompatibleWithAllSourceFilesExistWithFilePath() throws Exception {
        this.createFiles(6, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.registerTimeseriesInMManger(2, 3, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.seqResources, targetResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        RandomAccessFile targetFile = new RandomAccessFile(targetResource.getTsFile(), "rw");
        long fileLength = targetFile.length();
        targetFile.getChannel().truncate(fileLength - 20L);
        targetFile.close();
        for (int i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        File logFile = new File(targetResource.getTsFile().getParent(), COMPACTION_TEST_SG + ".compaction.log");
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(logFile));
        for (TsFileResource tsFileResource : this.seqResources) {
            logWriter.write(String.format("info-source\n%s 0 0 %s sequence\n", COMPACTION_TEST_SG, tsFileResource.getTsFile().getName()));
        }
        logWriter.write("sequence\n");
        logWriter.write(String.format("info-target\n%s 0 0 %s sequence\n", COMPACTION_TEST_SG, targetResource.getTsFile().getName()));
        logWriter.close();
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", targetResource.getTsFile().getParent());
        tsFileManager.addAll(this.seqResources, true);
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, logFile, true);
        recoverTask.doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)targetResource.resourceFileExists());
        Assert.assertFalse((boolean)targetResource.getModFile().exists());
        Assert.assertFalse((boolean)logFile.exists());
    }

    @Test
    public void testCompatibleWithSomeSourceFilesLostWithFilePath() throws Exception {
        this.createFiles(6, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.registerTimeseriesInMManger(2, 3, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.seqResources, targetResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)COMPACTION_TEST_SG);
        ((TsFileResource)this.seqResources.get(0)).delete();
        for (int i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        File logFile = new File(targetResource.getTsFile().getParent(), COMPACTION_TEST_SG + ".compaction.log");
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(logFile));
        for (TsFileResource tsFileResource : this.seqResources) {
            logWriter.write(String.format("info-source\n%s 0 0 %s sequence\n", COMPACTION_TEST_SG, tsFileResource.getTsFile().getName()));
        }
        logWriter.write("sequence\n");
        logWriter.write(String.format("info-target\n%s 0 0 %s sequence\n", COMPACTION_TEST_SG, targetResource.getTsFile().getName()));
        logWriter.close();
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", targetResource.getTsFile().getParent());
        tsFileManager.addAll(this.seqResources, true);
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, logFile, true);
        recoverTask.doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        Assert.assertFalse((boolean)logFile.exists());
    }

    @Test
    public void testCompatibleWithAllSourceFilesExistWithFileInfo() throws Exception {
        this.createFiles(6, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.registerTimeseriesInMManger(2, 3, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.seqResources, targetResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        RandomAccessFile targetFile = new RandomAccessFile(targetResource.getTsFile(), "rw");
        long fileLength = targetFile.length();
        targetFile.getChannel().truncate(fileLength - 20L);
        targetFile.close();
        File logFile = new File(targetResource.getTsFile().getParent(), "root.compactionTest.compaction.log");
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(logFile));
        for (TsFileResource tsFileResource : this.seqResources) {
            logWriter.write(String.format("source\n%s\n", tsFileResource.getTsFile().getAbsolutePath()));
        }
        logWriter.write("sequence\n");
        logWriter.write(String.format("target\n%s\n", targetResource.getTsFile().getAbsolutePath()));
        logWriter.close();
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", targetResource.getTsFile().getParent());
        tsFileManager.addAll(this.seqResources, true);
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, logFile, true);
        recoverTask.doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)logFile.exists());
    }

    @Test
    public void testCompatibleWithSomeSourceFilesLostWithFileInfo() throws Exception {
        this.createFiles(6, 2, 3, 100, 0, 0, 50, 50, false, false);
        this.registerTimeseriesInMManger(2, 3, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.unseqResources, (boolean)true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.seqResources, targetResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        ((TsFileResource)this.unseqResources.get(0)).delete();
        for (int i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        File logFile = new File(targetResource.getTsFile().getParent(), "root.compactionTest.compaction.log");
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(logFile));
        for (TsFileResource tsFileResource : this.unseqResources) {
            logWriter.write(String.format("source\n%s\n", tsFileResource.getTsFile().getAbsolutePath()));
        }
        logWriter.write("sequence\n");
        logWriter.write(String.format("target\n%s\n", targetResource.getTsFile().getAbsolutePath()));
        logWriter.close();
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", targetResource.getTsFile().getParent());
        tsFileManager.addAll(this.unseqResources, false);
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, logFile, true);
        recoverTask.doCompaction();
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        Assert.assertFalse((boolean)logFile.exists());
    }
}

