/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.recover;

import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.engine.compaction.task.CompactionRecoverTask;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RewriteCrossSpaceCompactionRecoverCompatibleTest
extends AbstractCompactionTest {
    private final String oldThreadName = Thread.currentThread().getName();

    @Override
    @Before
    public void setUp() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        super.setUp();
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-1");
    }

    @Override
    @After
    public void tearDown() throws StorageEngineException, IOException {
        super.tearDown();
        Thread.currentThread().setName(this.oldThreadName);
    }

    @Test
    public void testCompatibleWithAllSourceFilesExistWithFileInfo() throws Exception {
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i;
        this.createFiles(6, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(3, 2, 3, 50, 0, 0, 50, 50, false, false);
        this.registerTimeseriesInMManger(2, 3, false);
        ArrayList<TsFileResource> tmpTargetResources = new ArrayList<TsFileResource>();
        for (TsFileResource resource : this.seqResources) {
            Iterator mergeFile = new File(resource.getTsFilePath() + ".merge");
            ((File)((Object)mergeFile)).createNewFile();
            tmpTargetResources.add(new TsFileResource((File)((Object)mergeFile)));
        }
        File logFile = new File(SEQ_DIRS.getPath(), "merge.log");
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(logFile));
        logWriter.write("seqFiles\n");
        for (TsFileResource tsFileResource : this.seqResources) {
            logWriter.write(String.format(COMPACTION_TEST_SG + " 0 0 %s true\n", tsFileResource.getTsFile().getName()));
        }
        logWriter.write("unseqFiles\n");
        for (TsFileResource tsFileResource : this.unseqResources) {
            logWriter.write(String.format(COMPACTION_TEST_SG + " 0 0 %s false\n", tsFileResource.getTsFile().getName()));
        }
        logWriter.close();
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        for (i = 0; i < this.unseqResources.size(); ++i) {
            deleteMap = new HashMap();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d1" + "." + "s1", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        ModificationFile mergeMods = new ModificationFile(SEQ_DIRS + File.separator + "merge.mods");
        mergeMods.write((Modification)new Deletion(new PartialPath("root.d1.s1"), 100L, 0L, 100L));
        mergeMods.close();
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, logFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : tmpTargetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
        }
        for (TsFileResource resource : CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources)) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
        }
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertFalse((boolean)mergeMods.exists());
    }

    @Test
    public void testCompatibleWithSomeSourceFilesLostWithFileInfo() throws Exception {
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i;
        this.createFiles(6, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(3, 2, 3, 50, 0, 0, 50, 50, false, false);
        this.registerTimeseriesInMManger(2, 3, false);
        ArrayList<TsFileResource> tmpTargetResources = new ArrayList<TsFileResource>();
        for (TsFileResource resource : this.seqResources) {
            Iterator mergeFile = new File(resource.getTsFilePath() + ".merge");
            Files.copy((File)resource.getTsFile(), (File)((Object)mergeFile));
            tmpTargetResources.add(new TsFileResource((File)((Object)mergeFile)));
        }
        File logFile = new File(SEQ_DIRS.getPath(), "merge.log");
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(logFile));
        logWriter.write("seqFiles\n");
        for (TsFileResource tsFileResource : this.seqResources) {
            logWriter.write(String.format(COMPACTION_TEST_SG + " 0 0 %s true\n", tsFileResource.getTsFile().getName()));
        }
        logWriter.write("unseqFiles\n");
        for (TsFileResource tsFileResource : this.unseqResources) {
            logWriter.write(String.format(COMPACTION_TEST_SG + " 0 0 %s false\n", tsFileResource.getTsFile().getName()));
        }
        logWriter.close();
        ((TsFileResource)this.seqResources.get(0)).delete();
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        for (i = 0; i < this.unseqResources.size(); ++i) {
            deleteMap = new HashMap();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d1" + "." + "s1", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        ModificationFile mergeMods = new ModificationFile(SEQ_DIRS + File.separator + "merge.mods");
        mergeMods.write((Modification)new Deletion(new PartialPath("root.d1.s1"), 100L, 0L, 100L));
        mergeMods.close();
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, logFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : tmpTargetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
        }
        for (TsFileResource seqResource : CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources)) {
            TsFileResource resource = new TsFileResource(new File(seqResource.getTsFilePath().replace(".cross", ".tsfile")));
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
        }
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertFalse((boolean)mergeMods.exists());
    }

    @Test
    public void testCompatibleWithAllSourceFilesExistWithFilePath() throws Exception {
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i;
        this.createFiles(6, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(3, 2, 3, 50, 0, 0, 50, 50, false, false);
        this.registerTimeseriesInMManger(2, 3, false);
        ArrayList<TsFileResource> tmpTargetResources = new ArrayList<TsFileResource>();
        for (TsFileResource resource : this.seqResources) {
            Iterator mergeFile = new File(resource.getTsFilePath() + ".merge");
            ((File)((Object)mergeFile)).createNewFile();
            tmpTargetResources.add(new TsFileResource((File)((Object)mergeFile)));
        }
        File logFile = new File(SEQ_DIRS.getPath(), "merge.log");
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(logFile));
        logWriter.write("seqFiles\n");
        for (TsFileResource tsFileResource : this.seqResources) {
            logWriter.write(tsFileResource.getTsFile().getAbsolutePath());
            logWriter.write("\n");
        }
        logWriter.write("unseqFiles\n");
        for (TsFileResource tsFileResource : this.unseqResources) {
            logWriter.write(tsFileResource.getTsFile().getAbsolutePath());
            logWriter.write("\n");
        }
        logWriter.write("merge start");
        logWriter.write("\n");
        logWriter.write(((TsFileResource)this.seqResources.get(0)).getTsFile().getAbsolutePath() + " " + 100);
        logWriter.close();
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        for (i = 0; i < this.unseqResources.size(); ++i) {
            deleteMap = new HashMap();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d1" + "." + "s1", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        ModificationFile mergeMods = new ModificationFile(SEQ_DIRS + File.separator + "merge.mods");
        mergeMods.write((Modification)new Deletion(new PartialPath("root.d1.s1"), 100L, 0L, 100L));
        mergeMods.close();
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, logFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : tmpTargetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
        }
        for (TsFileResource resource : CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources)) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
        }
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertFalse((boolean)mergeMods.exists());
    }

    @Test
    public void testCompatibleWithSomeSourceFilesLostWithFilePath() throws Exception {
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i;
        this.createFiles(6, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(3, 2, 3, 50, 0, 0, 50, 50, false, false);
        this.registerTimeseriesInMManger(2, 3, false);
        ArrayList<TsFileResource> tmpTargetResources = new ArrayList<TsFileResource>();
        for (TsFileResource resource : this.seqResources) {
            Iterator mergeFile = new File(resource.getTsFilePath() + ".merge");
            Files.copy((File)resource.getTsFile(), (File)((Object)mergeFile));
            tmpTargetResources.add(new TsFileResource((File)((Object)mergeFile)));
        }
        File logFile = new File(SEQ_DIRS.getPath(), "merge.log");
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(logFile));
        logWriter.write("seqFiles\n");
        for (TsFileResource tsFileResource : this.seqResources) {
            logWriter.write(tsFileResource.getTsFile().getAbsolutePath());
            logWriter.write("\n");
        }
        logWriter.write("unseqFiles\n");
        for (TsFileResource tsFileResource : this.unseqResources) {
            logWriter.write(tsFileResource.getTsFile().getAbsolutePath());
            logWriter.write("\n");
        }
        logWriter.write("merge start");
        logWriter.write("\n");
        logWriter.write(((TsFileResource)this.seqResources.get(0)).getTsFile().getAbsolutePath() + " " + 100);
        logWriter.close();
        ((TsFileResource)this.seqResources.get(0)).delete();
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        for (i = 0; i < this.unseqResources.size(); ++i) {
            deleteMap = new HashMap();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d1" + "." + "s1", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        ModificationFile mergeMods = new ModificationFile(SEQ_DIRS + File.separator + "merge.mods");
        mergeMods.write((Modification)new Deletion(new PartialPath("root.d1.s1"), 100L, 0L, 100L));
        mergeMods.close();
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, logFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : tmpTargetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.resourceFileExists());
        }
        for (TsFileResource seqResource : CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources)) {
            TsFileResource resource = new TsFileResource(new File(seqResource.getTsFilePath().replace(".cross", ".tsfile")));
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
        }
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertFalse((boolean)mergeMods.exists());
    }
}

