/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.TestUtilsForAlignedSeries;
import org.apache.iotdb.db.engine.compaction.performer.ICompactionPerformer;
import org.apache.iotdb.db.engine.compaction.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.utils.CompactionCheckerUtils;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadChunkCompactionPerformerAlignedTest {
    private static final String storageGroup = "root.testAlignedCompaction";
    private final ICompactionPerformer performer = new ReadChunkCompactionPerformer();
    private static File dataDirectory = new File(TestConstant.BASE_OUTPUT_PATH + "data".concat(File.separator) + "sequence".concat(File.separator) + "root.testAlignedCompaction".concat(File.separator) + "0".concat(File.separator) + "0".concat(File.separator));

    @Before
    public void setUp() throws Exception {
        if (!dataDirectory.exists()) {
            Assert.assertTrue((boolean)dataDirectory.mkdirs());
        }
        IoTDB.configManager.init();
    }

    @After
    public void tearDown() throws Exception {
        new CompactionConfigRestorer().restoreCompactionConfig();
        FileUtils.forceDelete((File)dataDirectory);
        IoTDB.configManager.clear();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testSimpleAlignedTsFileCompaction() throws Exception {
        ArrayList<String> devices = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            devices.add("root.testAlignedCompaction.d" + i);
        }
        boolean[] aligned = new boolean[]{true, true, true, true, true};
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s0", TSDataType.DOUBLE));
        schemas.add(new MeasurementSchema("s1", TSDataType.FLOAT));
        schemas.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemas.add(new MeasurementSchema("s3", TSDataType.INT32));
        schemas.add(new MeasurementSchema("s4", TSDataType.TEXT));
        schemas.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
        TestUtilsForAlignedSeries.registerTimeSeries(storageGroup, devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), aligned);
        boolean[] randomNull = new boolean[]{false, false, false, false, false};
        int timeInterval = 500;
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (int i = 1; i < 31; ++i) {
            TsFileResource resource = new TsFileResource(new File(dataDirectory, String.format("%d-%d-0-0.tsfile", i, i)));
            TestUtilsForAlignedSeries.writeTsFile(devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), resource, aligned, timeInterval * i, timeInterval * (i + 1), randomNull);
            resources.add(resource);
        }
        TsFileResource targetResource = new TsFileResource(new File(dataDirectory, "1-1-1-0.tsfile"));
        ArrayList<PartialPath> fullPaths = new ArrayList<PartialPath>();
        ArrayList<IMeasurementSchema> iMeasurementSchemas = new ArrayList<IMeasurementSchema>();
        ArrayList measurementIds = new ArrayList();
        schemas.forEach(e -> measurementIds.add(e.getMeasurementId()));
        for (String device : devices) {
            iMeasurementSchemas.addAll(schemas);
            fullPaths.add((PartialPath)new AlignedPath(device, measurementIds, schemas));
        }
        Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, resources, new ArrayList<TsFileResource>());
        this.performer.setSourceFiles(resources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary(new CompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)storageGroup);
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)storageGroup);
        Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
        CompactionCheckerUtils.validDataByValueList(originData, compactedData);
    }

    @Test
    public void testAlignedTsFileWithModificationCompaction() throws Exception {
        ArrayList<String> devices = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            devices.add("root.testAlignedCompaction.d" + i);
        }
        boolean[] aligned = new boolean[]{true, true, true, true, true};
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s0", TSDataType.DOUBLE));
        schemas.add(new MeasurementSchema("s1", TSDataType.FLOAT));
        schemas.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemas.add(new MeasurementSchema("s3", TSDataType.INT32));
        schemas.add(new MeasurementSchema("s4", TSDataType.TEXT));
        schemas.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
        TestUtilsForAlignedSeries.registerTimeSeries(storageGroup, devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), aligned);
        boolean[] randomNull = new boolean[]{false, false, false, false, false};
        int timeInterval = 500;
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (int i = 1; i < 31; ++i) {
            TsFileResource resource = new TsFileResource(new File(dataDirectory, String.format("%d-%d-0-0.tsfile", i, i)));
            TestUtilsForAlignedSeries.writeTsFile(devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), resource, aligned, timeInterval * i, timeInterval * (i + 1), randomNull);
            Pair deleteInterval = new Pair((Object)((long)(timeInterval * i) + 10L), (Object)((long)(timeInterval * i) + 20L));
            HashMap<String, Pair<Long, Long>> deletionMap = new HashMap<String, Pair<Long, Long>>();
            for (String device : devices) {
                deletionMap.put(device + ".s0", (Pair<Long, Long>)deleteInterval);
            }
            CompactionFileGeneratorUtils.generateMods(deletionMap, resource, false);
            resources.add(resource);
        }
        TsFileResource targetResource = new TsFileResource(new File(dataDirectory, "1-1-1-0.tsfile"));
        ArrayList<PartialPath> fullPaths = new ArrayList<PartialPath>();
        ArrayList<IMeasurementSchema> iMeasurementSchemas = new ArrayList<IMeasurementSchema>();
        ArrayList measurementIds = new ArrayList();
        schemas.forEach(e -> measurementIds.add(e.getMeasurementId()));
        for (String device : devices) {
            iMeasurementSchemas.addAll(schemas);
            fullPaths.add((PartialPath)new AlignedPath(device, measurementIds, schemas));
        }
        Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, resources, new ArrayList<TsFileResource>());
        this.performer.setSourceFiles(resources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary(new CompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)storageGroup);
        Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
        CompactionCheckerUtils.validDataByValueList(originData, compactedData);
    }

    @Test
    public void testAlignedTsFileWithNullValueCompaction() throws Exception {
        ArrayList<String> devices = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            devices.add("root.testAlignedCompaction.d" + i);
        }
        boolean[] aligned = new boolean[]{true, true, true, true, true};
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s0", TSDataType.DOUBLE));
        schemas.add(new MeasurementSchema("s1", TSDataType.FLOAT));
        schemas.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemas.add(new MeasurementSchema("s3", TSDataType.INT32));
        schemas.add(new MeasurementSchema("s4", TSDataType.TEXT));
        schemas.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
        TestUtilsForAlignedSeries.registerTimeSeries(storageGroup, devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), aligned);
        boolean[] randomNull = new boolean[]{true, false, true, false, true};
        int timeInterval = 500;
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (int i = 1; i < 31; ++i) {
            TsFileResource resource = new TsFileResource(new File(dataDirectory, String.format("%d-%d-0-0.tsfile", i, i)));
            TestUtilsForAlignedSeries.writeTsFile(devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), resource, aligned, timeInterval * i, timeInterval * (i + 1), randomNull);
            resources.add(resource);
        }
        TsFileResource targetResource = new TsFileResource(new File(dataDirectory, "1-1-1-0.tsfile"));
        ArrayList<PartialPath> fullPaths = new ArrayList<PartialPath>();
        ArrayList<IMeasurementSchema> iMeasurementSchemas = new ArrayList<IMeasurementSchema>();
        ArrayList measurementIds = new ArrayList();
        schemas.forEach(e -> measurementIds.add(e.getMeasurementId()));
        for (String device : devices) {
            iMeasurementSchemas.addAll(schemas);
            fullPaths.add((PartialPath)new AlignedPath(device, measurementIds, schemas));
        }
        Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, resources, new ArrayList<TsFileResource>());
        this.performer.setSourceFiles(resources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary(new CompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)storageGroup);
        Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
        CompactionCheckerUtils.validDataByValueList(originData, compactedData);
    }

    @Test
    public void testAlignedTsFileWithDifferentSchemaInDifferentTsFileCompaction() throws Exception {
        ArrayList<String> devices = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            devices.add("root.testAlignedCompaction.d" + i);
        }
        boolean[] aligned = new boolean[]{true, true, true, true, true};
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s0", TSDataType.DOUBLE));
        schemas.add(new MeasurementSchema("s1", TSDataType.FLOAT));
        schemas.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemas.add(new MeasurementSchema("s3", TSDataType.INT32));
        schemas.add(new MeasurementSchema("s4", TSDataType.TEXT));
        schemas.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
        TestUtilsForAlignedSeries.registerTimeSeries(storageGroup, devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), aligned);
        boolean[] randomNull = new boolean[]{true, false, true, false, true};
        int timeInterval = 500;
        Random random = new Random(1L);
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (int i = 1; i < 31; ++i) {
            TsFileResource resource = new TsFileResource(new File(dataDirectory, String.format("%d-%d-0-0.tsfile", i, i)));
            TestUtilsForAlignedSeries.writeTsFile(devices.toArray(new String[0]), schemas.subList(0, random.nextInt(schemas.size() - 1) + 1).toArray(new IMeasurementSchema[0]), resource, aligned, timeInterval * i, timeInterval * (i + 1), randomNull);
            resources.add(resource);
        }
        TsFileResource targetResource = new TsFileResource(new File(dataDirectory, "1-1-1-0.tsfile"));
        ArrayList<PartialPath> fullPaths = new ArrayList<PartialPath>();
        ArrayList<IMeasurementSchema> iMeasurementSchemas = new ArrayList<IMeasurementSchema>();
        ArrayList measurementIds = new ArrayList();
        schemas.forEach(e -> measurementIds.add(e.getMeasurementId()));
        for (String device : devices) {
            iMeasurementSchemas.addAll(schemas);
            fullPaths.add((PartialPath)new AlignedPath(device, measurementIds, schemas));
        }
        Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, resources, new ArrayList<TsFileResource>());
        this.performer.setSourceFiles(resources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary(new CompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)storageGroup);
        Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
        CompactionCheckerUtils.validDataByValueList(originData, compactedData);
    }

    @Test
    public void testAlignedTsFileWithDifferentDataTypeCompaction() throws Exception {
        ArrayList<String> devices = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            devices.add("root.testAlignedCompaction.d" + i);
        }
        boolean[] aligned = new boolean[]{false, true, false, true, false};
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s0", TSDataType.DOUBLE));
        schemas.add(new MeasurementSchema("s1", TSDataType.FLOAT));
        schemas.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemas.add(new MeasurementSchema("s3", TSDataType.INT32));
        schemas.add(new MeasurementSchema("s4", TSDataType.TEXT));
        schemas.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
        TestUtilsForAlignedSeries.registerTimeSeries(storageGroup, devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), aligned);
        boolean[] randomNull = new boolean[]{true, false, true, false, true};
        int timeInterval = 500;
        Random random = new Random(1L);
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (int i = 1; i < 31; ++i) {
            TsFileResource resource = new TsFileResource(new File(dataDirectory, String.format("%d-%d-0-0.tsfile", i, i)));
            TestUtilsForAlignedSeries.writeTsFile(devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), resource, aligned, timeInterval * i, timeInterval * (i + 1), randomNull);
            resources.add(resource);
        }
        TsFileResource targetResource = new TsFileResource(new File(dataDirectory, "1-1-1-0.tsfile"));
        ArrayList<PartialPath> fullPaths = new ArrayList<PartialPath>();
        ArrayList<IMeasurementSchema> iMeasurementSchemas = new ArrayList<IMeasurementSchema>();
        ArrayList measurementIds = new ArrayList();
        schemas.forEach(e -> measurementIds.add(e.getMeasurementId()));
        for (String device : devices) {
            iMeasurementSchemas.addAll(schemas);
            fullPaths.add((PartialPath)new AlignedPath(device, measurementIds, schemas));
        }
        Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, resources, new ArrayList<TsFileResource>());
        this.performer.setSourceFiles(resources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary(new CompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)storageGroup);
        Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
        CompactionCheckerUtils.validDataByValueList(originData, compactedData);
    }

    @Test
    public void testAlignedTsFileWithDifferentDataTypeInDifferentTsFileCompaction() throws Exception {
        ArrayList<String> devices = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            devices.add("root.testAlignedCompaction.d" + i);
        }
        boolean[] aligned = new boolean[]{false, true, false, true, false};
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s0", TSDataType.DOUBLE));
        schemas.add(new MeasurementSchema("s1", TSDataType.FLOAT));
        schemas.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemas.add(new MeasurementSchema("s3", TSDataType.INT32));
        schemas.add(new MeasurementSchema("s4", TSDataType.TEXT));
        schemas.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
        TestUtilsForAlignedSeries.registerTimeSeries(storageGroup, devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), aligned);
        boolean[] randomNull = new boolean[]{true, false, true, false, true};
        int timeInterval = 500;
        Random random = new Random(5L);
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (int i = 1; i < 31; ++i) {
            TsFileResource resource = new TsFileResource(new File(dataDirectory, String.format("%d-%d-0-0.tsfile", i, i)));
            TestUtilsForAlignedSeries.writeTsFile(devices.subList(0, random.nextInt(devices.size() - 1) + 1).toArray(new String[0]), schemas.subList(0, random.nextInt(schemas.size() - 1) + 1).toArray(new IMeasurementSchema[0]), resource, aligned, timeInterval * i, timeInterval * (i + 1), randomNull);
            resources.add(resource);
        }
        TsFileResource targetResource = new TsFileResource(new File(dataDirectory, "1-1-1-0.tsfile"));
        ArrayList<PartialPath> fullPaths = new ArrayList<PartialPath>();
        ArrayList<IMeasurementSchema> iMeasurementSchemas = new ArrayList<IMeasurementSchema>();
        ArrayList measurementIds = new ArrayList();
        schemas.forEach(e -> measurementIds.add(e.getMeasurementId()));
        for (String device : devices) {
            iMeasurementSchemas.addAll(schemas);
            fullPaths.add((PartialPath)new AlignedPath(device, measurementIds, schemas));
        }
        Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, resources, new ArrayList<TsFileResource>());
        this.performer.setSourceFiles(resources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary(new CompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)storageGroup);
        Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
        CompactionCheckerUtils.validDataByValueList(originData, compactedData);
    }

    @Test
    public void testAlignedTsFileWithBadSchemaCompaction() throws Exception {
        ArrayList<String> devices = new ArrayList<String>();
        devices.add("root.testAlignedCompaction.d0");
        for (int i = 1; i < 5; ++i) {
            devices.add((String)devices.get(i - 1) + ".d" + i);
        }
        boolean[] aligned = new boolean[]{false, true, false, true, false};
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s0", TSDataType.DOUBLE));
        schemas.add(new MeasurementSchema("s1", TSDataType.FLOAT));
        schemas.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemas.add(new MeasurementSchema("s3", TSDataType.INT32));
        schemas.add(new MeasurementSchema("s4", TSDataType.TEXT));
        schemas.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
        TestUtilsForAlignedSeries.registerTimeSeries(storageGroup, devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), aligned);
        boolean[] randomNull = new boolean[]{true, false, true, false, true};
        int timeInterval = 500;
        Random random = new Random(5L);
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (int i = 1; i < 31; ++i) {
            TsFileResource resource = new TsFileResource(new File(dataDirectory, String.format("%d-%d-0-0.tsfile", i, i)));
            TestUtilsForAlignedSeries.writeTsFile(devices.subList(0, random.nextInt(devices.size() - 1) + 1).toArray(new String[0]), schemas.subList(0, random.nextInt(schemas.size() - 1) + 1).toArray(new IMeasurementSchema[0]), resource, aligned, timeInterval * i, timeInterval * (i + 1), randomNull);
            resources.add(resource);
        }
        TsFileResource targetResource = new TsFileResource(new File(dataDirectory, "1-1-1-0.tsfile"));
        ArrayList<PartialPath> fullPaths = new ArrayList<PartialPath>();
        ArrayList<IMeasurementSchema> iMeasurementSchemas = new ArrayList<IMeasurementSchema>();
        ArrayList measurementIds = new ArrayList();
        schemas.forEach(e -> measurementIds.add(e.getMeasurementId()));
        for (String device : devices) {
            iMeasurementSchemas.addAll(schemas);
            fullPaths.add((PartialPath)new AlignedPath(device, measurementIds, schemas));
        }
        Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, resources, new ArrayList<TsFileResource>());
        this.performer.setSourceFiles(resources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary(new CompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)storageGroup);
        Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
        CompactionCheckerUtils.validDataByValueList(originData, compactedData);
    }

    @Test
    public void testAlignedTsFileWithEmptyChunkGroup() throws Exception {
        ArrayList<String> devices = new ArrayList<String>();
        devices.add("root.testAlignedCompaction.d0");
        for (int i = 1; i < 5; ++i) {
            devices.add((String)devices.get(i - 1) + ".d" + i);
        }
        boolean[] aligned = new boolean[]{false, true, false, true, false};
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s0", TSDataType.DOUBLE));
        schemas.add(new MeasurementSchema("s1", TSDataType.FLOAT));
        schemas.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemas.add(new MeasurementSchema("s3", TSDataType.INT32));
        schemas.add(new MeasurementSchema("s4", TSDataType.TEXT));
        schemas.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
        TestUtilsForAlignedSeries.registerTimeSeries(storageGroup, devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), aligned);
        boolean[] randomNull = new boolean[]{true, false, true, false, true};
        int timeInterval = 500;
        Random random = new Random(5L);
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (int i = 1; i < 30; ++i) {
            TsFileResource resource = new TsFileResource(new File(dataDirectory, String.format("%d-%d-0-0.tsfile", i, i)));
            TestUtilsForAlignedSeries.writeTsFile(devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), resource, aligned, timeInterval * i, timeInterval * (i + 1), randomNull);
            resources.add(resource);
        }
        TsFileResource resource = new TsFileResource(new File(dataDirectory, String.format("%d-%d-0-0.tsfile", 30, 30)));
        TestUtilsForAlignedSeries.writeTsFile(devices.toArray(new String[0]), schemas.toArray(new IMeasurementSchema[0]), resource, aligned, timeInterval * 31, timeInterval * 31, randomNull);
        resources.add(resource);
        TsFileResource targetResource = new TsFileResource(new File(dataDirectory, "1-1-1-0.tsfile"));
        ArrayList<PartialPath> fullPaths = new ArrayList<PartialPath>();
        ArrayList<IMeasurementSchema> iMeasurementSchemas = new ArrayList<IMeasurementSchema>();
        ArrayList measurementIds = new ArrayList();
        schemas.forEach(e -> measurementIds.add(e.getMeasurementId()));
        for (String device : devices) {
            iMeasurementSchemas.addAll(schemas);
            fullPaths.add((PartialPath)new AlignedPath(device, measurementIds, schemas));
        }
        Map<PartialPath, List<TimeValuePair>> originData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, resources, new ArrayList<TsFileResource>());
        this.performer.setSourceFiles(resources);
        this.performer.setTargetFiles(Collections.singletonList(targetResource));
        this.performer.setSummary(new CompactionTaskSummary());
        this.performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)storageGroup);
        Map<PartialPath, List<TimeValuePair>> compactedData = CompactionCheckerUtils.getDataByQuery(fullPaths, iMeasurementSchemas, Collections.singletonList(targetResource), new ArrayList<TsFileResource>());
        CompactionCheckerUtils.validDataByValueList(originData, compactedData);
    }
}

