/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.performer.ICompactionPerformer;
import org.apache.iotdb.db.engine.compaction.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.utils.CompactionCheckerUtils;
import org.apache.iotdb.db.engine.compaction.utils.CompactionClearUtils;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.compaction.utils.CompactionTimeseriesType;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InnerSeqCompactionWithReadChunkPerformerTest {
    static final String COMPACTION_TEST_SG = "root.compactionTest";
    static final String[] fullPaths = new String[]{"root.compactionTest.device0.sensor0", "root.compactionTest.device1.sensor0", "root.compactionTest.device2.sensor0", "root.compactionTest.device3.sensor0", "root.compactionTest.device4.sensor0", "root.compactionTest.device5.sensor0", "root.compactionTest.device6.sensor0", "root.compactionTest.device7.sensor0", "root.compactionTest.device8.sensor0"};
    static final int[] toMergeFileNums = new int[]{2, 3};
    static final CompactionTimeseriesType[] compactionTimeseriesTypes = new CompactionTimeseriesType[]{CompactionTimeseriesType.ALL_SAME, CompactionTimeseriesType.PART_SAME, CompactionTimeseriesType.NO_SAME};
    static final boolean[] compactionBeforeHasMods = new boolean[]{true, false};
    static final boolean[] compactionHasMods = new boolean[]{true, false};
    private static int prevMaxDegreeOfIndexNode;

    @Before
    public void setUp() throws MetadataException {
        prevMaxDegreeOfIndexNode = TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode();
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(2);
        EnvironmentUtils.envSetUp();
        IoTDB.configManager.init();
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(COMPACTION_TEST_SG));
        for (String fullPath : fullPaths) {
            PartialPath path = new PartialPath(fullPath);
            IoTDB.schemaProcessor.createTimeseries(path, TSDataType.INT64, TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        }
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        new CompactionConfigRestorer().restoreCompactionConfig();
        CompactionClearUtils.clearAllCompactionFiles();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        IoTDB.configManager.clear();
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.cleanAllDir();
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(prevMaxDegreeOfIndexNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeserializePage() throws Exception {
        long chunkSizeLowerBoundInCompaction = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(10240L);
        long chunkPointNumLowerBoundInCompaction = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(1000L);
        try {
            for (int toMergeFileNum : toMergeFileNums) {
                for (CompactionTimeseriesType compactionTimeseriesType : compactionTimeseriesTypes) {
                    for (boolean compactionBeforeHasMod : compactionBeforeHasMods) {
                        for (boolean compactionHasMod : compactionHasMods) {
                            ArrayList<TsFileResource> sourceResources = new ArrayList<TsFileResource>();
                            for (int i = 0; i < toMergeFileNum; ++i) {
                                HashSet<String> fullPath = new HashSet<String>();
                                if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                    fullPath.add(fullPaths[0]);
                                    fullPath.add(fullPaths[1]);
                                    fullPath.add(fullPaths[2]);
                                } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                    if (i == 0) {
                                        fullPath.add(fullPaths[0]);
                                        fullPath.add(fullPaths[1]);
                                        fullPath.add(fullPaths[2]);
                                    } else if (i == 1) {
                                        fullPath.add(fullPaths[1]);
                                        fullPath.add(fullPaths[2]);
                                        fullPath.add(fullPaths[3]);
                                    } else {
                                        fullPath.add(fullPaths[2]);
                                        fullPath.add(fullPaths[3]);
                                        fullPath.add(fullPaths[4]);
                                    }
                                } else if (i == 0) {
                                    fullPath.add(fullPaths[0]);
                                    fullPath.add(fullPaths[1]);
                                    fullPath.add(fullPaths[2]);
                                } else if (i == 1) {
                                    fullPath.add(fullPaths[3]);
                                    fullPath.add(fullPaths[4]);
                                    fullPath.add(fullPaths[5]);
                                } else {
                                    fullPath.add(fullPaths[6]);
                                    fullPath.add(fullPaths[7]);
                                    fullPath.add(fullPaths[8]);
                                }
                                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                                pagePointsNum.add(100L);
                                chunkPagePointsNum.add(pagePointsNum);
                                pagePointsNum = new ArrayList();
                                pagePointsNum.add(200L);
                                chunkPagePointsNum.add(pagePointsNum);
                                pagePointsNum = new ArrayList();
                                pagePointsNum.add(300L);
                                chunkPagePointsNum.add(pagePointsNum);
                                TsFileResource tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1);
                                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, (long)i * 600L, tsFileResource);
                                sourceResources.add(tsFileResource);
                                if (!compactionBeforeHasMod) continue;
                                HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                                if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[i], new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                    if (i == 0) {
                                        toDeleteTimeseriesAndTime.put(fullPaths[0], new Pair((Object)250L, (Object)300L));
                                    } else if (i == 1) {
                                        toDeleteTimeseriesAndTime.put(fullPaths[3], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                    } else {
                                        toDeleteTimeseriesAndTime.put(fullPaths[4], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                    }
                                } else if (i == 0) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[2], new Pair((Object)250L, (Object)300L));
                                } else if (i == 1) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[5], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                } else {
                                    toDeleteTimeseriesAndTime.put(fullPaths[8], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                }
                                CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, tsFileResource, false);
                            }
                            TsFileResource targetTsFileResource = CompactionFileGeneratorUtils.getTargetTsFileResourceFromSourceResource((TsFileResource)sourceResources.get(0));
                            Map<String, List<TimeValuePair>> sourceData = CompactionCheckerUtils.readFiles(sourceResources);
                            if (compactionHasMod) {
                                HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                                toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)250L, (Object)300L));
                                CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)sourceResources.get(0), true);
                                List<TimeValuePair> timeValuePairs = sourceData.get(fullPaths[1]);
                                timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 250L && timeValuePair.getTimestamp() <= 300L);
                            }
                            ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(sourceResources, targetTsFileResource);
                            performer.setSummary(new CompactionTaskSummary());
                            performer.perform();
                            CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)COMPACTION_TEST_SG);
                            CompactionUtils.combineModsInInnerCompaction(sourceResources, (TsFileResource)targetTsFileResource);
                            ArrayList<TsFileResource> targetTsFileResources = new ArrayList<TsFileResource>();
                            targetTsFileResources.add(targetTsFileResource);
                            CompactionCheckerUtils.checkDataAndResource(sourceData, targetTsFileResources);
                            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
                            if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                if (toMergeFileNum == 2) {
                                    if (compactionBeforeHasMod) {
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1149L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1149L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                    } else {
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1200L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                    }
                                } else if (toMergeFileNum == 3) {
                                    if (compactionBeforeHasMod) {
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1749L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1749L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1749L);
                                    } else {
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1800L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1800L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1800L);
                                    }
                                }
                            } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                if (toMergeFileNum == 2) {
                                    if (compactionBeforeHasMod) {
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 549L);
                                    } else {
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1200L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                    }
                                } else if (toMergeFileNum == 3) {
                                    if (compactionBeforeHasMod) {
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1800L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1149L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 549L);
                                    } else {
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1200L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1800L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1200L);
                                        CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                    }
                                }
                            } else if (toMergeFileNum == 2) {
                                if (compactionBeforeHasMod) {
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                                } else {
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                }
                            } else if (toMergeFileNum == 3) {
                                if (compactionBeforeHasMod) {
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 549L);
                                } else {
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[6], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[7], 600L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 600L);
                                }
                            }
                            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetTsFileResource);
                            CompactionClearUtils.clearAllCompactionFiles();
                        }
                    }
                }
            }
        }
        catch (InterruptedException | ExecutionException | StorageEngineException e) {
            e.printStackTrace();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(chunkPointNumLowerBoundInCompaction);
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(chunkSizeLowerBoundInCompaction);
        }
    }

    @Test
    public void testAppendPage() throws Exception {
        for (int toMergeFileNum : toMergeFileNums) {
            for (CompactionTimeseriesType compactionTimeseriesType : compactionTimeseriesTypes) {
                for (boolean compactionBeforeHasMod : compactionBeforeHasMods) {
                    for (boolean compactionHasMod : compactionHasMods) {
                        ArrayList<TsFileResource> toMergeResources = new ArrayList<TsFileResource>();
                        for (int i = 0; i < toMergeFileNum; ++i) {
                            HashSet<String> fullPath = new HashSet<String>();
                            if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                fullPath.add(fullPaths[0]);
                                fullPath.add(fullPaths[1]);
                                fullPath.add(fullPaths[2]);
                            } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                if (i == 0) {
                                    fullPath.add(fullPaths[0]);
                                    fullPath.add(fullPaths[1]);
                                    fullPath.add(fullPaths[2]);
                                } else if (i == 1) {
                                    fullPath.add(fullPaths[1]);
                                    fullPath.add(fullPaths[2]);
                                    fullPath.add(fullPaths[3]);
                                } else {
                                    fullPath.add(fullPaths[2]);
                                    fullPath.add(fullPaths[3]);
                                    fullPath.add(fullPaths[4]);
                                }
                            } else if (i == 0) {
                                fullPath.add(fullPaths[0]);
                                fullPath.add(fullPaths[1]);
                                fullPath.add(fullPaths[2]);
                            } else if (i == 1) {
                                fullPath.add(fullPaths[3]);
                                fullPath.add(fullPaths[4]);
                                fullPath.add(fullPaths[5]);
                            } else {
                                fullPath.add(fullPaths[6]);
                                fullPath.add(fullPaths[7]);
                                fullPath.add(fullPaths[8]);
                            }
                            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                            pagePointsNum.add(100L);
                            chunkPagePointsNum.add(pagePointsNum);
                            pagePointsNum = new ArrayList();
                            pagePointsNum.add(200L);
                            chunkPagePointsNum.add(pagePointsNum);
                            pagePointsNum = new ArrayList();
                            pagePointsNum.add(300L);
                            chunkPagePointsNum.add(pagePointsNum);
                            TsFileResource tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1);
                            CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, (long)i * 600L, tsFileResource);
                            toMergeResources.add(tsFileResource);
                            if (!compactionBeforeHasMod) continue;
                            HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                            if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                toDeleteTimeseriesAndTime.put(fullPaths[i], new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                            } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                if (i == 0) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[0], new Pair((Object)250L, (Object)300L));
                                } else if (i == 1) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[3], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                } else {
                                    toDeleteTimeseriesAndTime.put(fullPaths[4], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                }
                            } else if (i == 0) {
                                toDeleteTimeseriesAndTime.put(fullPaths[2], new Pair((Object)250L, (Object)300L));
                            } else if (i == 1) {
                                toDeleteTimeseriesAndTime.put(fullPaths[5], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                            } else {
                                toDeleteTimeseriesAndTime.put(fullPaths[8], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                            }
                            CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, tsFileResource, false);
                        }
                        TsFileResource targetTsFileResource = CompactionFileGeneratorUtils.getTargetTsFileResourceFromSourceResource((TsFileResource)toMergeResources.get(0));
                        Map<String, List<TimeValuePair>> sourceData = CompactionCheckerUtils.readFiles(toMergeResources);
                        if (compactionHasMod) {
                            HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                            toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)250L, (Object)300L));
                            CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)toMergeResources.get(0), true);
                            List<TimeValuePair> timeValuePairs = sourceData.get(fullPaths[1]);
                            timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 250L && timeValuePair.getTimestamp() <= 300L);
                        }
                        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(toMergeResources, targetTsFileResource);
                        performer.setSummary(new CompactionTaskSummary());
                        performer.perform();
                        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)COMPACTION_TEST_SG);
                        CompactionUtils.combineModsInInnerCompaction(toMergeResources, (TsFileResource)targetTsFileResource);
                        ArrayList<TsFileResource> targetTsFileResources = new ArrayList<TsFileResource>();
                        targetTsFileResources.add(targetTsFileResource);
                        CompactionCheckerUtils.checkDataAndResource(sourceData, targetTsFileResources);
                        HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
                        if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                            if (toMergeFileNum == 2) {
                                if (compactionBeforeHasMod) {
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1149L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1149L);
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                } else {
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                }
                            } else if (toMergeFileNum == 3) {
                                if (compactionBeforeHasMod) {
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 1749L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[1], 1749L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 1749L);
                                } else {
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                }
                            }
                        } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                            if (toMergeFileNum == 2) {
                                if (compactionBeforeHasMod) {
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 549L);
                                } else {
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                }
                            } else if (toMergeFileNum == 3) {
                                if (compactionBeforeHasMod) {
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[0], 549L);
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[3], 1149L);
                                    CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[4], 549L);
                                } else {
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                }
                            }
                        } else if (toMergeFileNum == 2) {
                            if (compactionBeforeHasMod) {
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                            } else {
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[5], new long[]{100L, 200L, 300L});
                            }
                        } else if (toMergeFileNum == 3) {
                            if (compactionBeforeHasMod) {
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[2], 549L);
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[5], 549L);
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[6], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[7], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putOnePageChunk(chunkPagePointsNumMerged, fullPaths[8], 549L);
                            } else {
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[5], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[6], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[7], new long[]{100L, 200L, 300L});
                                CompactionCheckerUtils.putChunk(chunkPagePointsNumMerged, fullPaths[8], new long[]{100L, 200L, 300L});
                            }
                        }
                        CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetTsFileResource);
                        CompactionClearUtils.clearAllCompactionFiles();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendChunk() throws Exception {
        long prevChunkPointNumLowerBoundInCompaction = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(1L);
        long prevChunkSizeLowerBoundInCompaction = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(1L);
        long prevTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
        long prevTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(1L);
        try {
            for (int toMergeFileNum : toMergeFileNums) {
                for (CompactionTimeseriesType compactionTimeseriesType : compactionTimeseriesTypes) {
                    for (boolean compactionBeforeHasMod : compactionBeforeHasMods) {
                        for (boolean compactionHasMod : compactionHasMods) {
                            ArrayList<TsFileResource> toMergeResources = new ArrayList<TsFileResource>();
                            for (int i = 0; i < toMergeFileNum; ++i) {
                                HashSet<String> fullPath = new HashSet<String>();
                                if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                    fullPath.add(fullPaths[0]);
                                    fullPath.add(fullPaths[1]);
                                    fullPath.add(fullPaths[2]);
                                } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                    if (i == 0) {
                                        fullPath.add(fullPaths[0]);
                                        fullPath.add(fullPaths[1]);
                                        fullPath.add(fullPaths[2]);
                                    } else if (i == 1) {
                                        fullPath.add(fullPaths[1]);
                                        fullPath.add(fullPaths[2]);
                                        fullPath.add(fullPaths[3]);
                                    } else {
                                        fullPath.add(fullPaths[2]);
                                        fullPath.add(fullPaths[3]);
                                        fullPath.add(fullPaths[4]);
                                    }
                                } else if (i == 0) {
                                    fullPath.add(fullPaths[0]);
                                    fullPath.add(fullPaths[1]);
                                    fullPath.add(fullPaths[2]);
                                } else if (i == 1) {
                                    fullPath.add(fullPaths[3]);
                                    fullPath.add(fullPaths[4]);
                                    fullPath.add(fullPaths[5]);
                                } else {
                                    fullPath.add(fullPaths[6]);
                                    fullPath.add(fullPaths[7]);
                                    fullPath.add(fullPaths[8]);
                                }
                                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                                pagePointsNum.add(100L);
                                chunkPagePointsNum.add(pagePointsNum);
                                pagePointsNum = new ArrayList();
                                pagePointsNum.add(200L);
                                chunkPagePointsNum.add(pagePointsNum);
                                pagePointsNum = new ArrayList();
                                pagePointsNum.add(300L);
                                chunkPagePointsNum.add(pagePointsNum);
                                TsFileResource tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1);
                                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, (long)i * 600L, tsFileResource);
                                toMergeResources.add(tsFileResource);
                                if (!compactionBeforeHasMod) continue;
                                HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                                if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[i], new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                    if (i == 0) {
                                        toDeleteTimeseriesAndTime.put(fullPaths[0], new Pair((Object)250L, (Object)300L));
                                    } else if (i == 1) {
                                        toDeleteTimeseriesAndTime.put(fullPaths[3], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                    } else {
                                        toDeleteTimeseriesAndTime.put(fullPaths[4], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                    }
                                } else if (i == 0) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[2], new Pair((Object)250L, (Object)300L));
                                } else if (i == 1) {
                                    toDeleteTimeseriesAndTime.put(fullPaths[5], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                } else {
                                    toDeleteTimeseriesAndTime.put(fullPaths[8], (Pair<Long, Long>)new Pair((Object)((long)i * 600L + 250L), (Object)((long)i * 600L + 300L)));
                                }
                                CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, tsFileResource, false);
                            }
                            TsFileResource targetTsFileResource = CompactionFileGeneratorUtils.getTargetTsFileResourceFromSourceResource((TsFileResource)toMergeResources.get(0));
                            Map<String, List<TimeValuePair>> sourceData = CompactionCheckerUtils.readFiles(toMergeResources);
                            if (compactionHasMod) {
                                HashMap<String, Pair<Long, Long>> toDeleteTimeseriesAndTime = new HashMap<String, Pair<Long, Long>>();
                                toDeleteTimeseriesAndTime.put(fullPaths[1], new Pair((Object)250L, (Object)300L));
                                CompactionFileGeneratorUtils.generateMods(toDeleteTimeseriesAndTime, (TsFileResource)toMergeResources.get(0), true);
                                List<TimeValuePair> timeValuePairs = sourceData.get(fullPaths[1]);
                                timeValuePairs.removeIf(timeValuePair -> timeValuePair.getTimestamp() >= 250L && timeValuePair.getTimestamp() <= 300L);
                            }
                            ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(toMergeResources, targetTsFileResource);
                            performer.setSummary(new CompactionTaskSummary());
                            performer.perform();
                            CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)COMPACTION_TEST_SG);
                            CompactionUtils.combineModsInInnerCompaction(toMergeResources, (TsFileResource)targetTsFileResource);
                            ArrayList<TsFileResource> targetTsFileResources = new ArrayList<TsFileResource>();
                            targetTsFileResources.add(targetTsFileResource);
                            CompactionCheckerUtils.checkDataAndResource(sourceData, targetTsFileResources);
                            HashMap<String, List<List<Long>>> chunkPagePointsNumMerged = new HashMap<String, List<List<Long>>>();
                            if (compactionTimeseriesType == CompactionTimeseriesType.ALL_SAME) {
                                if (toMergeFileNum == 2) {
                                    if (compactionBeforeHasMod) {
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 150L, 299L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 150L, 299L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    } else {
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                    }
                                } else if (toMergeFileNum == 3) {
                                    if (compactionBeforeHasMod) {
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 150L, 299L, 100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 150L, 299L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 150L, 299L});
                                    } else {
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                    }
                                }
                            } else if (compactionTimeseriesType == CompactionTimeseriesType.PART_SAME) {
                                if (toMergeFileNum == 2) {
                                    if (compactionBeforeHasMod) {
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 150L, 299L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 150L, 299L});
                                    } else {
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                    }
                                } else if (toMergeFileNum == 3) {
                                    if (compactionBeforeHasMod) {
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 150L, 299L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 150L, 299L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 150L, 299L});
                                    } else {
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L, 100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L, 100L, 200L, 300L});
                                        CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                    }
                                }
                            } else if (toMergeFileNum == 2) {
                                if (compactionBeforeHasMod) {
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 150L, 299L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[5], new long[]{100L, 150L, 299L});
                                } else {
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[5], new long[]{100L, 200L, 300L});
                                }
                            } else if (toMergeFileNum == 3) {
                                if (compactionBeforeHasMod) {
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 150L, 299L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[5], new long[]{100L, 150L, 299L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[6], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[7], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[8], new long[]{100L, 150L, 299L});
                                } else {
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[0], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[1], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[2], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[3], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[4], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[5], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[6], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[7], new long[]{100L, 200L, 300L});
                                    CompactionCheckerUtils.putOnePageChunks(chunkPagePointsNumMerged, fullPaths[8], new long[]{100L, 200L, 300L});
                                }
                            }
                            CompactionCheckerUtils.checkChunkAndPage(chunkPagePointsNumMerged, targetTsFileResource);
                            CompactionClearUtils.clearAllCompactionFiles();
                        }
                    }
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(prevChunkSizeLowerBoundInCompaction);
            IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(prevChunkPointNumLowerBoundInCompaction);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(prevTargetChunkPointNum);
            IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(prevTargetChunkSize);
        }
    }

    @Test
    public void testCompactionWithDeletionsDuringCompactions() throws MetadataException, IOException, DataRegionException {
        int i;
        ArrayList<TsFileResource> sourceResources = new ArrayList<TsFileResource>();
        ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
        ArrayList<Long> pagePointsNum = new ArrayList<Long>();
        pagePointsNum.add(100L);
        chunkPagePointsNum.add(pagePointsNum);
        pagePointsNum = new ArrayList();
        pagePointsNum.add(200L);
        chunkPagePointsNum.add(pagePointsNum);
        pagePointsNum = new ArrayList();
        pagePointsNum.add(300L);
        chunkPagePointsNum.add(pagePointsNum);
        HashSet<String> paths = new HashSet<String>();
        for (i = 0; i < fullPaths.length; ++i) {
            paths.add(fullPaths[i]);
        }
        for (i = 0; i < 5; ++i) {
            TsFileResource tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1);
            CompactionFileGeneratorUtils.writeTsFile(paths, chunkPagePointsNum, (long)i * 600L, tsFileResource);
            sourceResources.add(tsFileResource);
        }
        DataRegion vsgp = new DataRegion(TestConstant.BASE_OUTPUT_PATH, "0", (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), COMPACTION_TEST_SG);
        vsgp.getTsFileResourceManager().addAll(sourceResources, true);
        vsgp.deleteByDevice(new PartialPath(fullPaths[0]), 0L, 1000L, 0L, null);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, vsgp.getTsFileResourceManager(), sourceResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), new AtomicInteger(0), 0L);
        task.setSourceFilesToCompactionCandidate();
        task.checkValidAndSetMerging();
        vsgp.deleteByDevice(new PartialPath(fullPaths[0]), 0L, 1200L, 0L, null);
        vsgp.deleteByDevice(new PartialPath(fullPaths[0]), 0L, 1800L, 0L, null);
        for (int i2 = 0; i2 < sourceResources.size() - 1; ++i2) {
            TsFileResource resource = (TsFileResource)sourceResources.get(i2);
            resource.resetModFile();
            Assert.assertTrue((boolean)resource.getCompactionModFile().exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            if (i2 < 2) {
                Assert.assertEquals((long)3L, (long)resource.getModFile().getModifications().size());
                Assert.assertEquals((long)2L, (long)resource.getCompactionModFile().getModifications().size());
                continue;
            }
            if (i2 < 3) {
                Assert.assertEquals((long)2L, (long)resource.getModFile().getModifications().size());
                Assert.assertEquals((long)2L, (long)resource.getCompactionModFile().getModifications().size());
                continue;
            }
            Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
            Assert.assertEquals((long)1L, (long)resource.getCompactionModFile().getModifications().size());
        }
        task.start();
        for (TsFileResource resource : sourceResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
        }
        TsFileResource resource = TsFileNameGenerator.increaseInnerCompactionCnt((TsFileResource)((TsFileResource)sourceResources.get(0)));
        resource.resetModFile();
        Assert.assertTrue((boolean)resource.getModFile().exists());
        Assert.assertEquals((long)2L, (long)resource.getModFile().getModifications().size());
        Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
    }
}

