/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.inner.InnerCompactionTest;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.performer.ICompactionPerformer;
import org.apache.iotdb.db.engine.compaction.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InnerCompactionEmptyTsFileTest
extends InnerCompactionTest {
    File tempSGDir;

    @Override
    @Before
    public void setUp() throws Exception {
        this.tempSGDir = new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L));
        if (!this.tempSGDir.exists()) {
            Assert.assertTrue((boolean)this.tempSGDir.mkdirs());
        }
        this.seqFileNum = 0;
        this.unseqFileNum = 4;
        super.setUp();
        CompactionTaskManager.getInstance().restart();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
        this.tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Override
    void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        super.prepareFile(tsFileResource, 0L, 0L, 0L);
    }

    @Test
    public void testCompactWithPartialEmptyUnseqFiles() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources.subList(0, 3), false, (ICompactionPerformer)new ReadPointCompactionPerformer(), new AtomicInteger(0), 0L);
        ((TsFileResource)this.unseqResources.get(0)).readLock();
        CompactionTaskManager.getInstance().addTaskToWaitingQueue((AbstractCompactionTask)task);
        Future future = CompactionTaskManager.getInstance().getCompactionTaskFutureMayBlock((AbstractCompactionTask)task);
        ((TsFileResource)this.unseqResources.get(0)).readUnlock();
        Assert.assertTrue((boolean)((CompactionTaskSummary)future.get()).isSuccess());
    }
}

