/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.log.CompactionLogger;
import org.apache.iotdb.db.engine.compaction.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.CompactionRecoverTask;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RewriteCrossSpaceCompactionRecoverTest
extends AbstractCompactionTest {
    private final String oldThreadName = Thread.currentThread().getName();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1024L);
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-1");
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        Thread.currentThread().setName(this.oldThreadName);
    }

    @Test
    public void testRecoverWithAllSourceFilesExisted() throws Exception {
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        compactionLogger.close();
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, compactionLogFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile") + ".resource").exists());
        }
    }

    @Test
    public void testRecoverWithAllSourceFilesExistedAndSomeTargetFilesNotExist() throws Exception {
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        for (int i = 0; i < targetResources.size(); ++i) {
            if (i < 2) {
                targetResources.get(i).removeResourceFile();
                continue;
            }
            targetResources.get(i).remove();
        }
        compactionLogger.close();
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, compactionLogFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile") + ".resource").exists());
        }
    }

    @Test
    public void testRecoverWithAllSourceFilesExistedAndTargetFilesMoved() throws Exception {
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        compactionLogger.close();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, compactionLogFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".cross", ".tsfile") + ".resource").exists());
        }
    }

    @Test
    public void testRecoverWithSomeSourceFilesExisted() throws Exception {
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ((TsFileResource)this.seqResources.get(0)).getTsFile().delete();
        compactionLogger.close();
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, compactionLogFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross") + ".resource").exists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
    }

    @Test
    public void testRecoverWithoutAllSourceFilesAndModFilesExist() throws Exception {
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i;
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        compactionLogger.close();
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        for (i = 0; i < this.unseqResources.size(); ++i) {
            deleteMap = new HashMap();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d1" + "." + "s1", new Pair((Object)((long)i * 10L), (Object)((long)i * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        CompactionUtils.combineModsInCrossCompaction((List)this.seqResources, (List)this.unseqResources, targetResources);
        ((TsFileResource)this.seqResources.get(0)).remove();
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, compactionLogFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getCompactionModFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross") + ".resource").exists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
        }
        Assert.assertFalse((boolean)compactionLogFile.exists());
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
    }

    @Test
    public void testRecoverWithAllSourcesFileAndCompactonModFileExist() throws Exception {
        int i;
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i2;
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        compactionLogger.close();
        CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        for (i2 = 0; i2 < this.seqResources.size(); ++i2) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i2 * 10L), (Object)((long)i2 * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i2), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i2), false);
        }
        for (i2 = 0; i2 < this.unseqResources.size(); ++i2) {
            deleteMap = new HashMap();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d1" + "." + "s1", new Pair((Object)((long)i2 * 10L), (Object)((long)i2 * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i2), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i2), false);
        }
        CompactionUtils.combineModsInCrossCompaction((List)this.seqResources, (List)this.unseqResources, targetResources);
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, compactionLogFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (i = 0; i < this.seqResources.size(); ++i) {
            ((TsFileResource)this.seqResources.get(i)).resetModFile();
            ModificationFile f = ((TsFileResource)this.seqResources.get(i)).getCompactionModFile();
            Assert.assertFalse((boolean)f.exists());
        }
        for (i = 0; i < this.unseqResources.size(); ++i) {
            ((TsFileResource)this.unseqResources.get(i)).resetModFile();
            Assert.assertFalse((boolean)((TsFileResource)this.unseqResources.get(i)).getCompactionModFile().exists());
        }
        for (TsFileResource resource : this.seqResources) {
            resource.resetModFile();
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.resetModFile();
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
        }
        Assert.assertFalse((boolean)compactionLogFile.exists());
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
    }

    @Test
    public void testRecoverWithAllSourcesFileAndCompactonModFileExistAndSomeTargetFilesNotExist() throws Exception {
        int i;
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i2;
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", SEQ_DIRS.getPath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
        File compactionLogFile = new File(SEQ_DIRS, targetResources.get(0).getTsFile().getName() + ".cross-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        compactionLogger.logFiles(targetResources, "target");
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(this.unseqResources, "source");
        ReadPointCompactionPerformer performer = new ReadPointCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        for (i2 = 0; i2 < targetResources.size(); ++i2) {
            if (i2 < 2) {
                targetResources.get(i2).removeResourceFile();
                continue;
            }
            targetResources.get(i2).remove();
        }
        compactionLogger.close();
        for (i2 = 0; i2 < this.seqResources.size(); ++i2) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d0" + "." + "s0", new Pair((Object)((long)i2 * 10L), (Object)((long)i2 * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i2), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i2), false);
        }
        for (i2 = 0; i2 < this.unseqResources.size(); ++i2) {
            deleteMap = new HashMap();
            deleteMap.put(COMPACTION_TEST_SG + "." + "d1" + "." + "s1", new Pair((Object)((long)i2 * 10L), (Object)((long)i2 * 10L + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i2), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i2), false);
        }
        new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, compactionLogFile, false).doCompaction();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)new File(resource.getTsFilePath() + ".resource").exists());
        }
        for (TsFileResource resource : targetResources) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath().replace(".tsfile", ".cross")).exists());
            Assert.assertFalse((boolean)new File(resource.getTsFilePath() + ".resource").exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        for (i = 0; i < this.seqResources.size(); ++i) {
            ((TsFileResource)this.seqResources.get(i)).resetModFile();
            ModificationFile f = ((TsFileResource)this.seqResources.get(i)).getCompactionModFile();
            Assert.assertFalse((boolean)f.exists());
        }
        for (i = 0; i < this.unseqResources.size(); ++i) {
            ((TsFileResource)this.unseqResources.get(i)).resetModFile();
            Assert.assertFalse((boolean)((TsFileResource)this.unseqResources.get(i)).getCompactionModFile().exists());
        }
        for (TsFileResource resource : this.seqResources) {
            resource.resetModFile();
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.resetModFile();
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
        }
        Assert.assertFalse((boolean)compactionLogFile.exists());
        Assert.assertTrue((boolean)tsFileManager.isAllowCompaction());
    }
}

