/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.cross.CrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.cross.ICrossSpaceSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.tools.validate.TsFileValidationTool;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrossSpaceCompactionValidationTest
extends AbstractCompactionTest {
    TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", STORAGE_GROUP_DIR.getPath());
    private final String oldThreadName = Thread.currentThread().getName();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(1024L);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-1");
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        Thread.currentThread().setName(this.oldThreadName);
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        TsFileValidationTool.badFileNum = 0;
    }

    @Test
    public void test1() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1001, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test2() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test3() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test4() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 300, 1700, 1700, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2400, 2400, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1200, 3300, 3300, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6500, 6500, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6301, 6301, 100, 100, true, false);
        ((TsFileResource)this.seqResources.get(4)).setStatus(TsFileResourceStatus.UNCLOSED);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)4L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(2), this.unseqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(3), this.unseqResources.get(3));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test5() throws MetadataException, IOException, WriteProcessException, MergeException {
        IoTDBDescriptor.getInstance().getConfig().setMaxCrossCompactionCandidateFileNum(7);
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(7, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.createFiles(1, 5, 10, 4400, 1150, 1150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(3), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(4), this.seqResources.get(5));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test6() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 3000, 1100, 1100, 100, 100, true, true);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2000, 2000, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)3L, (long)((List)((Pair)selected.get((int)0)).right).size());
        for (TsFileResource selectedResource : (List)((Pair)selected.get((int)0)).left) {
            Assert.assertEquals((Object)selectedResource, this.seqResources.get(1));
        }
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(2), this.unseqResources.get(2));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test7() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 3000, 1100, 1100, 100, 100, true, true);
        this.createFiles(3, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2000, 2000, 100, 100, true, false);
        this.createFiles(1, 5, 10, 4050, 1200, 1200, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)4L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(2), this.unseqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(3), this.unseqResources.get(3));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void test8() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 5, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 5, 10, 300, 1700, 1700, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1000, 2400, 2400, 100, 100, true, false);
        this.createFiles(1, 5, 10, 1200, 3300, 3300, 100, 100, true, false);
        this.createFiles(2, 5, 10, 1000, 4200, 4200, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)4L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(2), this.unseqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(3), this.unseqResources.get(3));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile10() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile11() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile12() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile20() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile21() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile22() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, true, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, true, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile30() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile31() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile32() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, true, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile50() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(3), this.seqResources.get(5));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(4), this.seqResources.get(6));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile51() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 10, 5, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(3), this.seqResources.get(5));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(4), this.seqResources.get(6));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile52() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)6L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(3), this.seqResources.get(5));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(4), this.seqResources.get(6));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(5), this.seqResources.get(7));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewAlignedDeviceAndSensorInUnseqFile53() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, true, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, true, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, true, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, true, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, true, true);
        this.createFiles(1, 5, 2, 1000, 5500, 5500, 100, 100, true, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, true, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, true, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, true, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, true, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(3), this.seqResources.get(5));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(4), this.seqResources.get(7));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile10() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile11() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile12() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile20() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile21() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, false, false);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, false, true);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile22() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(2, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2100, 2100, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1500, 3200, 3200, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile30() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(2, 10, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile31() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile32() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 4200, 4200, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 5300, 5300, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 6400, 6400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7500, 7500, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1500, 1500, 1500, 100, 100, false, false);
        this.createFiles(1, 10, 10, 1000, 3100, 3100, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)3L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(1));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile50() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(3), this.seqResources.get(5));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(4), this.seqResources.get(6));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile51() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 10, 5, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(3), this.seqResources.get(5));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(4), this.seqResources.get(6));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile52() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 2, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)6L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(3), this.seqResources.get(5));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(4), this.seqResources.get(6));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(5), this.seqResources.get(7));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithNewDeviceAndSensorInUnseqFile53() throws MetadataException, IOException, WriteProcessException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(1, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 6, 6, 1000, 1100, 1100, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 2200, 2200, 100, 100, false, true);
        this.createFiles(1, 4, 4, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 3, 3, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 5, 2, 1000, 5500, 5500, 100, 100, false, true);
        this.createFiles(1, 5, 10, 1000, 6600, 6600, 100, 100, false, true);
        this.createFiles(1, 10, 7, 1000, 7700, 7700, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 8800, 8800, 100, 100, false, true);
        this.createFiles(1, 10, 10, 3300, 2150, 2150, 100, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)5L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(2), this.seqResources.get(4));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(3), this.seqResources.get(5));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(4), this.seqResources.get(7));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithUnclosedSeqFile() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (String deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithUnclosedSeqFileAndNewSensorInUnseqFile() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(3, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 5, 1000, 3300, 3300, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 4400, 4400, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (String deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testUnseqFileOverlapWithUnclosedSeqFile() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        this.createFiles(1, 5, 5, 3000, 1500, 1500, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (String deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testUnseqFileOverlapWithUnclosedSeqFile2() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        this.createFiles(1, 5, 5, 50, 4310, 4310, 100, 100, false, false);
        TsFileResource unclosedSeqResource = new TsFileResource(((TsFileResource)this.seqResources.get(4)).getTsFile());
        unclosedSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastSeqResource = (TsFileResource)this.seqResources.get(4);
        for (String deviceID : lastSeqResource.getDevices()) {
            unclosedSeqResource.updateStartTime(deviceID, lastSeqResource.getStartTime(deviceID));
        }
        this.seqResources.remove(4);
        this.seqResources.add(4, unclosedSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(1), this.unseqResources.get(1));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testWithUnclosedUnSeqFile() throws MergeException, IOException, MetadataException, WriteProcessException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 10, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 10, 10, 1000, 2500, 2500, 100, 100, false, false);
        this.createFiles(1, 5, 5, 3000, 1500, 1500, 100, 100, false, false);
        TsFileResource unclosedUnSeqResource = new TsFileResource(((TsFileResource)this.unseqResources.get(1)).getTsFile());
        unclosedUnSeqResource.setStatus(TsFileResourceStatus.UNCLOSED);
        TsFileResource lastUnSeqResource = (TsFileResource)this.unseqResources.get(1);
        for (String deviceID : lastUnSeqResource.getDevices()) {
            unclosedUnSeqResource.updateStartTime(deviceID, lastUnSeqResource.getStartTime(deviceID));
            unclosedUnSeqResource.updateEndTime(deviceID, lastUnSeqResource.getEndTime(deviceID));
        }
        this.unseqResources.remove(1);
        this.unseqResources.add(1, unclosedUnSeqResource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionResource resource = new CrossSpaceCompactionResource(this.seqResources, this.unseqResources);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, null);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)2L, (long)((List)((Pair)selected.get((int)0)).left).size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)selected.get((int)0)).right).size());
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(0), this.seqResources.get(2));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).left).get(1), this.seqResources.get(3));
        Assert.assertEquals(((List)((Pair)selected.get((int)0)).right).get(0), this.unseqResources.get(0));
        new CrossSpaceCompactionTask(0L, this.tsFileManager, (List)((Pair)selected.get((int)0)).left, (List)((Pair)selected.get((int)0)).right, IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), new AtomicInteger(0), 0L, this.tsFileManager.getNextCompactionTaskId()).doCompaction();
        this.validateSeqFiles(true);
    }

    @Test
    public void testSelectingFilesWhenSomeFilesBeingDeleted() throws MetadataException, IOException, WriteProcessException, StorageEngineException, InterruptedException, MergeException {
        this.registerTimeseriesInMManger(5, 10, true);
        this.createFiles(5, 10, 5, 1000, 0, 0, 100, 100, false, true);
        this.createFiles(1, 5, 10, 4500, 500, 500, 0, 100, false, false);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
        sourceFiles.add((TsFileResource)this.seqResources.get(2));
        sourceFiles.add((TsFileResource)this.seqResources.get(3));
        List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getInnerCompactionTargetTsFileResources(sourceFiles, true);
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(sourceFiles);
        performer.setTargetFiles(targetResources);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(targetResources, (boolean)true, (String)(COMPACTION_TEST_SG + "-0"));
        CompactionUtils.combineModsInInnerCompaction(sourceFiles, (TsFileResource)targetResources.get(0));
        this.tsFileManager.replace(sourceFiles, Collections.emptyList(), targetResources, 0L, true);
        CompactionUtils.deleteTsFilesInDisk(sourceFiles, (String)(COMPACTION_TEST_SG + "-0"));
        ICrossSpaceSelector selector = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector().createInstance(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)0L, (long)selected.size());
    }
}

