/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.log.TsFileIdentifier;
import org.junit.Assert;
import org.junit.Test;

public class TsFileIdentifierUT {
    @Test
    public void testGetInfoFromFilePath() {
        String firstPath = "sequence" + File.separator + "root.test.sg" + File.separator + "0" + File.separator + "0" + File.separator + "1-1-0-0.tsfile";
        TsFileIdentifier firstInfo = TsFileIdentifier.getFileIdentifierFromFilePath((String)firstPath);
        Assert.assertEquals((Object)firstInfo.getFilename(), (Object)"1-1-0-0.tsfile");
        Assert.assertEquals((Object)firstInfo.getLogicalStorageGroupName(), (Object)"root.test.sg");
        Assert.assertEquals((Object)firstInfo.getTimePartitionId(), (Object)"0");
        Assert.assertEquals((Object)firstInfo.getDataRegionId(), (Object)"0");
        Assert.assertTrue((boolean)firstInfo.isSequence());
        String secondPath = "unsequence" + File.separator + "root.test.sg" + File.separator + "0" + File.separator + "426" + File.separator + "999-3-24-12.tsfile";
        TsFileIdentifier secondInfo = TsFileIdentifier.getFileIdentifierFromFilePath((String)secondPath);
        Assert.assertEquals((Object)secondInfo.getFilename(), (Object)"999-3-24-12.tsfile");
        Assert.assertEquals((Object)secondInfo.getLogicalStorageGroupName(), (Object)"root.test.sg");
        Assert.assertEquals((Object)secondInfo.getTimePartitionId(), (Object)"426");
        Assert.assertEquals((Object)secondInfo.getDataRegionId(), (Object)"0");
        Assert.assertFalse((boolean)secondInfo.isSequence());
        String illegalPath = "root.test.sg" + File.separator + "0" + File.separator + "426" + File.separator + "999-3-24-12.tsfile";
        try {
            TsFileIdentifier.getFileIdentifierFromFilePath((String)illegalPath);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetInfoFromInfoString() {
        CharSequence[] firstInfoArray = new String[]{"sequence", "root.test.sg", "0", "0", "1-1-0-0.tsfile"};
        String firstInfoString = String.join((CharSequence)" ", firstInfoArray);
        TsFileIdentifier firstInfo = TsFileIdentifier.getFileIdentifierFromInfoString((String)firstInfoString);
        Assert.assertEquals((Object)firstInfo.getFilename(), (Object)"1-1-0-0.tsfile");
        Assert.assertEquals((Object)firstInfo.getTimePartitionId(), (Object)"0");
        Assert.assertEquals((Object)firstInfo.getDataRegionId(), (Object)"0");
        Assert.assertEquals((Object)firstInfo.getLogicalStorageGroupName(), (Object)"root.test.sg");
        Assert.assertTrue((boolean)firstInfo.isSequence());
        CharSequence[] secondInfoArray = new String[]{"unsequence", "root.test.sg", "0", "425", "666-888-222-131.tsfile"};
        String secondInfoString = String.join((CharSequence)" ", secondInfoArray);
        TsFileIdentifier secondInfo = TsFileIdentifier.getFileIdentifierFromInfoString((String)secondInfoString);
        Assert.assertEquals((Object)secondInfo.getFilename(), (Object)"666-888-222-131.tsfile");
        Assert.assertEquals((Object)secondInfo.getTimePartitionId(), (Object)"425");
        Assert.assertEquals((Object)secondInfo.getDataRegionId(), (Object)"0");
        Assert.assertEquals((Object)secondInfo.getLogicalStorageGroupName(), (Object)"root.test.sg");
        Assert.assertFalse((boolean)secondInfo.isSequence());
        CharSequence[] illegalInfoArray = new String[]{"unsequence", "0", "425", "666-888-222-131.tsfile"};
        String illegalInfoString = String.join((CharSequence)" ", illegalInfoArray);
        try {
            TsFileIdentifier.getFileIdentifierFromInfoString((String)illegalInfoString);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetInfoFromFileFromSingleDir() throws IOException {
        String firstPath = "sequence" + File.separator + "root.test.sg" + File.separator + "0" + File.separator + "0" + File.separator + "100-10-5-1.tsfile";
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        File file = new File(dataDirs[0], firstPath);
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        try {
            TsFileIdentifier info = TsFileIdentifier.getFileIdentifierFromFilePath((String)firstPath);
            Assert.assertNull((Object)info.getFileFromDataDirs());
            if (!file.getParentFile().exists()) {
                Assert.assertTrue((boolean)file.getParentFile().mkdirs());
            }
            Assert.assertTrue((boolean)file.createNewFile());
            Assert.assertTrue((boolean)Files.isSameFile(file.toPath(), info.getFileFromDataDirs().toPath()));
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetInfoFromFileFromMultiDirs() throws Exception {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        String[] originDataDirs = config.getDataDirs();
        Class<?> configClass = config.getClass();
        Field dataDirField = configClass.getDeclaredField("dataDirs");
        dataDirField.setAccessible(true);
        dataDirField.set(config, new String[]{"target" + File.separator + "data1", "target" + File.separator + "data2"});
        String filePath = "sequence" + File.separator + "root.test.sg" + File.separator + "0" + File.separator + "0" + File.separator + "100-10-5-1.tsfile";
        File testFile = new File("target" + File.separator + "data2", filePath);
        try {
            TsFileIdentifier info = TsFileIdentifier.getFileIdentifierFromFilePath((String)filePath);
            if (!testFile.getParentFile().exists()) {
                Assert.assertTrue((boolean)testFile.getParentFile().mkdirs());
            }
            if (testFile.exists()) {
                Assert.assertTrue((boolean)testFile.delete());
            }
            Assert.assertNull((Object)info.getFileFromDataDirs());
            Assert.assertTrue((boolean)testFile.createNewFile());
            Assert.assertTrue((boolean)Files.isSameFile(testFile.toPath(), info.getFileFromDataDirs().toPath()));
        }
        finally {
            dataDirField.set(config, originDataDirs);
            Files.deleteIfExists(testFile.toPath());
            FileUtils.deleteDirectory((File)new File("target" + File.separator + "data2"));
        }
    }
}

