/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class TestUtilsForAlignedSeries {
    public static void registerTimeSeries(String storageGroup, String[] devices, IMeasurementSchema[] schemas, boolean[] isAligned) throws MetadataException {
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(storageGroup));
        for (int i = 0; i < devices.length; ++i) {
            boolean aligned = isAligned[i];
            String device = devices[i];
            if (!aligned) {
                for (IMeasurementSchema schema : schemas) {
                    IoTDB.schemaProcessor.createTimeseries(new PartialPath(device, schema.getMeasurementId()), schema.getType(), schema.getEncodingType(), schema.getCompressor(), new HashMap());
                }
                continue;
            }
            TSDataType[] dataTypes = new TSDataType[schemas.length];
            TSEncoding[] encodings = new TSEncoding[schemas.length];
            CompressionType[] compressionTypes = new CompressionType[schemas.length];
            String[] measurements = new String[schemas.length];
            for (int j = 0; j < schemas.length; ++j) {
                dataTypes[j] = schemas[j].getType();
                encodings[j] = schemas[j].getEncodingType();
                compressionTypes[j] = schemas[j].getCompressor();
                measurements[j] = schemas[j].getMeasurementId();
            }
            IoTDB.schemaProcessor.createAlignedTimeSeries(new PartialPath(device), Arrays.asList(measurements), Arrays.asList(dataTypes), Arrays.asList(encodings), Arrays.asList(compressionTypes));
        }
    }

    public static void writeTsFile(String[] devices, IMeasurementSchema[] schemas, TsFileResource tsFileResource, boolean[] alignedArray, long startTime, long endTime, boolean[] randomNull) throws IOException {
        try (TsFileIOWriter writer = new TsFileIOWriter(tsFileResource.getTsFile());){
            for (int i = 0; i < devices.length; ++i) {
                String device = devices[i];
                boolean aligned = alignedArray[i];
                if (aligned) {
                    TestUtilsForAlignedSeries.writeAlignedChunkGroup(writer, device, schemas, startTime, endTime, randomNull[i]);
                } else {
                    TestUtilsForAlignedSeries.writeNotAlignedChunkGroup(writer, device, schemas, startTime, endTime, randomNull[i]);
                }
                tsFileResource.updateStartTime(devices[i], startTime);
                tsFileResource.updateEndTime(devices[i], endTime);
            }
            writer.endFile();
        }
        tsFileResource.close();
        tsFileResource.serialize();
    }

    private static void writeAlignedChunkGroup(TsFileIOWriter writer, String device, IMeasurementSchema[] schemas, long startTime, long endTime, boolean randomNull) throws IOException {
        writer.startChunkGroup(device);
        AlignedChunkWriterImpl alignedChunkWriter = new AlignedChunkWriterImpl(Arrays.asList(schemas));
        Random random = new Random();
        for (long time = startTime; time < endTime; ++time) {
            block9: for (int i = 0; i < schemas.length; ++i) {
                switch (schemas[i].getType()) {
                    case BOOLEAN: {
                        boolean booleanVal = (Boolean)TestUtilsForAlignedSeries.generateRandomVal(schemas[i].getType());
                        alignedChunkWriter.write(time, booleanVal, randomNull && random.nextInt(2) == 1);
                        continue block9;
                    }
                    case INT32: {
                        int intVal = (Integer)TestUtilsForAlignedSeries.generateRandomVal(schemas[i].getType());
                        alignedChunkWriter.write(time, intVal, randomNull && random.nextInt(2) == 1);
                        continue block9;
                    }
                    case DOUBLE: {
                        double doubleVal = (Double)TestUtilsForAlignedSeries.generateRandomVal(schemas[i].getType());
                        alignedChunkWriter.write(time, doubleVal, randomNull && random.nextInt(2) == 1);
                        continue block9;
                    }
                    case FLOAT: {
                        float floatVal = ((Float)TestUtilsForAlignedSeries.generateRandomVal(schemas[i].getType())).floatValue();
                        alignedChunkWriter.write(time, floatVal, randomNull && random.nextInt(2) == 1);
                        continue block9;
                    }
                    case TEXT: {
                        String stringVal = (String)TestUtilsForAlignedSeries.generateRandomVal(schemas[i].getType());
                        alignedChunkWriter.write(time, new Binary(stringVal.getBytes(StandardCharsets.UTF_8)), randomNull && random.nextInt(2) == 1);
                        continue block9;
                    }
                    case INT64: {
                        long longVal = (Long)TestUtilsForAlignedSeries.generateRandomVal(schemas[i].getType());
                        alignedChunkWriter.write(time, longVal, randomNull && random.nextInt(2) == 1);
                    }
                }
            }
            alignedChunkWriter.write(time);
        }
        alignedChunkWriter.writeToFileWriter(writer);
        writer.endChunkGroup();
    }

    private static void writeNotAlignedChunkGroup(TsFileIOWriter writer, String device, IMeasurementSchema[] schemas, long startTime, long endTime, boolean randomNull) throws IOException {
        writer.startChunkGroup(device);
        Random random = new Random();
        for (IMeasurementSchema schema : schemas) {
            ChunkWriterImpl chunkWriter = new ChunkWriterImpl(schema);
            block9: for (long time = startTime; time < endTime; ++time) {
                if (randomNull && random.nextInt(2) == 1) continue;
                switch (schema.getType()) {
                    case BOOLEAN: {
                        boolean booleanVal = (Boolean)TestUtilsForAlignedSeries.generateRandomVal(schema.getType());
                        chunkWriter.write(time, booleanVal);
                        continue block9;
                    }
                    case INT32: {
                        int intVal = (Integer)TestUtilsForAlignedSeries.generateRandomVal(schema.getType());
                        chunkWriter.write(time, intVal);
                        continue block9;
                    }
                    case DOUBLE: {
                        double doubleVal = (Double)TestUtilsForAlignedSeries.generateRandomVal(schema.getType());
                        chunkWriter.write(time, doubleVal);
                        continue block9;
                    }
                    case FLOAT: {
                        float floatVal = ((Float)TestUtilsForAlignedSeries.generateRandomVal(schema.getType())).floatValue();
                        chunkWriter.write(time, floatVal);
                        continue block9;
                    }
                    case TEXT: {
                        String stringVal = (String)TestUtilsForAlignedSeries.generateRandomVal(schema.getType());
                        chunkWriter.write(time, new Binary(stringVal.getBytes(StandardCharsets.UTF_8)));
                        continue block9;
                    }
                    case INT64: {
                        long longVal = (Long)TestUtilsForAlignedSeries.generateRandomVal(schema.getType());
                        chunkWriter.write(time, longVal);
                    }
                }
            }
            chunkWriter.writeToFileWriter(writer);
        }
        writer.endChunkGroup();
    }

    private static Object generateRandomVal(TSDataType type) {
        Random random = new Random();
        Object returnVal = null;
        switch (type) {
            case BOOLEAN: {
                returnVal = random.nextInt(2) == 0;
                break;
            }
            case INT32: {
                returnVal = random.nextInt();
                break;
            }
            case DOUBLE: {
                returnVal = random.nextDouble();
                break;
            }
            case FLOAT: {
                returnVal = Float.valueOf(random.nextFloat());
                break;
            }
            case TEXT: {
                returnVal = String.valueOf(random.nextLong());
                break;
            }
            case INT64: {
                returnVal = random.nextLong();
            }
        }
        return returnVal;
    }
}

