/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.reader.SeriesDataBlockReader;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.tools.validate.TsFileValidationTool;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.Assert;

public class AbstractCompactionTest {
    protected int seqFileNum = 5;
    protected int unseqFileNum = 0;
    protected List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    protected List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
    private int chunkGroupSize = 0;
    private int pageSize = 0;
    protected static String COMPACTION_TEST_SG = "root.testsg";
    private TSDataType dataType;
    private static final long oldTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
    private static final long oldTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
    private static final int oldChunkGroupSize = TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte();
    private static final int oldPagePointMaxNumber = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
    private static final int oldMaxCrossCompactionFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileNum();
    private final int oldMaxDegreeOfIndexNode = TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode();
    private final long oldLowerTargetChunkSize = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
    private final long oldLowerTargetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
    protected static File STORAGE_GROUP_DIR = new File(TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG);
    protected static File SEQ_DIRS = new File(TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0");
    protected static File UNSEQ_DIRS = new File(TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "unsequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0");
    private int fileVersion = 0;
    protected TsFileManager tsFileManager = new TsFileManager(COMPACTION_TEST_SG, "0", STORAGE_GROUP_DIR.getPath());

    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        if (!SEQ_DIRS.exists()) {
            Assert.assertTrue((boolean)SEQ_DIRS.mkdirs());
        }
        if (!UNSEQ_DIRS.exists()) {
            Assert.assertTrue((boolean)UNSEQ_DIRS.mkdirs());
        }
        this.dataType = TSDataType.INT64;
        CompactionTaskManager.getInstance().restart();
        this.seqResources.clear();
        this.unseqResources.clear();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
    }

    protected void createFiles(int fileNum, int deviceNum, int measurementNum, int pointNum, int startTime, int startValue, int timeInterval, int valueInterval, boolean isAlign, boolean isSeq) throws IOException, WriteProcessException, MetadataException {
        for (int i = 0; i < fileNum; ++i) {
            String fileName = System.currentTimeMillis() + "-" + this.fileVersion++ + "-0-0.tsfile";
            String filePath = isSeq ? SEQ_DIRS.getPath() + File.separator + fileName : UNSEQ_DIRS.getPath() + File.separator + fileName;
            File file = isAlign ? TsFileGeneratorUtils.generateAlignedTsFile((String)filePath, (int)deviceNum, (int)measurementNum, (int)pointNum, (int)(startTime + pointNum * i + timeInterval * i), (int)(startValue + pointNum * i + valueInterval * i), (int)this.chunkGroupSize, (int)this.pageSize) : TsFileGeneratorUtils.generateNonAlignedTsFile((String)filePath, (int)deviceNum, (int)measurementNum, (int)pointNum, (int)(startTime + pointNum * i + timeInterval * i), (int)(startValue + pointNum * i + valueInterval * i), (int)this.chunkGroupSize, (int)this.pageSize);
            this.addResource(file, deviceNum, startTime + pointNum * i + timeInterval * i, startTime + pointNum * i + timeInterval * i + pointNum - 1, isAlign, isSeq);
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createFilesWithTextValue(int fileNum, List<Integer> deviceIndexes, List<Integer> measurementIndexes, int pointNum, int startTime, int timeInterval, boolean isAlign, boolean isSeq) throws IOException, WriteProcessException {
        String value = isSeq ? "seqTestValue" : "unseqTestValue";
        for (int i = 0; i < fileNum; ++i) {
            String fileName = System.currentTimeMillis() + "-" + this.fileVersion++ + "-0-0.tsfile";
            String filePath = isSeq ? SEQ_DIRS.getPath() + File.separator + fileName : UNSEQ_DIRS.getPath() + File.separator + fileName;
            File file = isAlign ? TsFileGeneratorUtils.generateAlignedTsFileWithTextValues((String)filePath, deviceIndexes, measurementIndexes, (int)pointNum, (int)(startTime + pointNum * i + timeInterval * i), (String)value, (int)this.chunkGroupSize, (int)this.pageSize) : TsFileGeneratorUtils.generateNonAlignedTsFileWithTextValues((String)filePath, deviceIndexes, measurementIndexes, (int)pointNum, (int)(startTime + pointNum * i + timeInterval * i), (String)value, (int)this.chunkGroupSize, (int)this.pageSize);
            TsFileResource resource = new TsFileResource(file);
            int deviceStartindex = isAlign ? TsFileGeneratorUtils.getAlignDeviceOffset() : 0;
            for (int j = 0; j < deviceIndexes.size(); ++j) {
                resource.updateStartTime(COMPACTION_TEST_SG + "." + "d" + (deviceIndexes.get(j) + deviceStartindex), (long)(startTime + pointNum * i + timeInterval * i));
                resource.updateEndTime(COMPACTION_TEST_SG + "." + "d" + (deviceIndexes.get(j) + deviceStartindex), (long)(startTime + pointNum * i + timeInterval * i + pointNum - 1));
            }
            resource.updatePlanIndexes((long)this.fileVersion);
            resource.setStatus(TsFileResourceStatus.CLOSED);
            resource.serialize();
            if (isSeq) {
                this.seqResources.add(resource);
                continue;
            }
            this.unseqResources.add(resource);
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addResource(File file, int deviceNum, long startTime, long endTime, boolean isAlign, boolean isSeq) throws IOException {
        int deviceStartindex;
        TsFileResource resource = new TsFileResource(file);
        for (int i = deviceStartindex = isAlign ? TsFileGeneratorUtils.getAlignDeviceOffset() : 0; i < deviceStartindex + deviceNum; ++i) {
            resource.updateStartTime(COMPACTION_TEST_SG + "." + "d" + i, startTime);
            resource.updateEndTime(COMPACTION_TEST_SG + "." + "d" + i, endTime);
        }
        resource.updatePlanIndexes((long)this.fileVersion);
        resource.setStatus(TsFileResourceStatus.CLOSED);
        resource.serialize();
        if (isSeq) {
            this.seqResources.add(resource);
        } else {
            this.unseqResources.add(resource);
        }
    }

    protected void registerTimeseriesInMManger(int deviceNum, int measurementNum, boolean isAligned) throws MetadataException {
        for (int i = 0; i < deviceNum; ++i) {
            if (!isAligned) continue;
            ArrayList<String> measurements = new ArrayList<String>();
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
            ArrayList<CompressionType> compressionTypes = new ArrayList<CompressionType>();
            for (int j = 0; j < measurementNum; ++j) {
                measurements.add("s" + j);
                dataTypes.add(this.dataType);
                encodings.add(TSEncoding.PLAIN);
                compressionTypes.add(CompressionType.UNCOMPRESSED);
            }
        }
    }

    protected void deleteTimeseriesInMManager(List<String> timeseries) throws MetadataException {
    }

    public void tearDown() throws IOException, StorageEngineException {
        new CompactionConfigRestorer().restoreCompactionConfig();
        this.removeFiles();
        CompactionTaskManager.getInstance().stop();
        this.seqResources.clear();
        this.unseqResources.clear();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(oldTargetChunkSize);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(oldTargetChunkPointNum);
        IoTDBDescriptor.getInstance().getConfig().setMaxCrossCompactionCandidateFileNum(oldMaxCrossCompactionFileNum);
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(oldTargetChunkPointNum);
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(this.oldLowerTargetChunkPointNum);
        TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(oldChunkGroupSize);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(oldPagePointMaxNumber);
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(this.oldMaxDegreeOfIndexNode);
        EnvironmentUtils.cleanAllDir();
        if (SEQ_DIRS.exists()) {
            FileUtils.deleteDirectory((File)SEQ_DIRS);
        }
        if (UNSEQ_DIRS.exists()) {
            FileUtils.deleteDirectory((File)UNSEQ_DIRS);
        }
    }

    private void removeFiles() throws IOException {
        File[] resourceFiles;
        TsFileResource files;
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        for (TsFileResource tsFileResource : this.seqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (File file : files = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".tsfile")) {
            file.delete();
        }
        for (File resourceFile : resourceFiles = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".resource")) {
            resourceFile.delete();
        }
    }

    protected void validateSeqFiles(boolean isSeq) {
        TsFileValidationTool.clearMap((boolean)true);
        ArrayList<File> files = new ArrayList<File>();
        for (TsFileResource resource : this.tsFileManager.getTsFileList(isSeq)) {
            files.add(resource.getTsFile());
        }
        TsFileValidationTool.findUncorrectFiles(files);
        Assert.assertEquals((long)0L, (long)TsFileValidationTool.badFileNum);
    }

    protected Map<PartialPath, List<TimeValuePair>> readSourceFiles(List<PartialPath> timeseriesPaths, List<TSDataType> dataTypes) throws IOException {
        LinkedHashMap<PartialPath, List<TimeValuePair>> sourceData = new LinkedHashMap<PartialPath, List<TimeValuePair>>();
        for (int i = 0; i < timeseriesPaths.size(); ++i) {
            PartialPath path = timeseriesPaths.get(i);
            ArrayList<TimeValuePair> dataList = new ArrayList<TimeValuePair>();
            sourceData.put(path, dataList);
            SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader(path, dataTypes.get(i), FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
            while (tsBlockReader.hasNextBatch()) {
                TsBlock block = tsBlockReader.nextBatch();
                TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                while (iterator.hasNext()) {
                    dataList.add(new TimeValuePair(iterator.currentTime(), ((TsPrimitiveType[])iterator.currentValue())[0]));
                    iterator.next();
                }
            }
        }
        return sourceData;
    }

    protected void validateTargetDatas(Map<PartialPath, List<TimeValuePair>> sourceDatas, List<TSDataType> dataTypes) throws IOException {
        int timeseriesIndex = 0;
        for (Map.Entry<PartialPath, List<TimeValuePair>> entry : sourceDatas.entrySet()) {
            SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader(entry.getKey(), dataTypes.get(timeseriesIndex++), FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), Collections.emptyList(), true);
            List<TimeValuePair> timeseriesData = entry.getValue();
            while (tsBlockReader.hasNextBatch()) {
                TsBlock block = tsBlockReader.nextBatch();
                TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                while (iterator.hasNext()) {
                    TimeValuePair data = timeseriesData.remove(0);
                    Assert.assertEquals((long)data.getTimestamp(), (long)iterator.currentTime());
                    Assert.assertEquals((Object)data.getValue(), (Object)((TsPrimitiveType[])iterator.currentValue())[0]);
                    iterator.next();
                }
            }
            if (timeseriesData.size() <= 0) continue;
            Assert.fail();
        }
    }

    protected void generateModsFile(List<String> seriesPaths, List<TsFileResource> resources, long startValue, long endValue) throws IllegalPathException, IOException {
        for (TsFileResource resource : resources) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            for (String path : seriesPaths) {
                deleteMap.put(path, (Pair<Long, Long>)new Pair((Object)startValue, (Object)endValue));
            }
            CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
        }
    }

    public void generateModsFile(List<PartialPath> seriesPaths, TsFileResource resource, long startValue, long endValue) throws IllegalPathException, IOException {
        HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
        for (PartialPath path : seriesPaths) {
            String fullPath = path instanceof AlignedPath ? path.getFullPath() + "." + (String)((AlignedPath)path).getMeasurementList().get(0) : path.getFullPath();
            deleteMap.put(fullPath, (Pair<Long, Long>)new Pair((Object)startValue, (Object)endValue));
        }
        CompactionFileGeneratorUtils.generateMods(deleteMap, resource, false);
    }

    protected void check(TsFileResource targetResource, List<String> deviceIdList) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(targetResource.getTsFile().getAbsolutePath());){
            byte marker;
            reader.position((long)"TsFile".getBytes().length + 1L);
            block10: while ((marker = reader.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: 
                    case 65: 
                    case 69: {
                        ChunkHeader header = reader.readChunkHeader(marker);
                        int dataSize = header.getDataSize();
                        reader.position(reader.position() + (long)dataSize);
                        continue block10;
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                        String deviceID = chunkGroupHeader.getDeviceID();
                        if (deviceIdList.contains(deviceID)) continue block10;
                        Assert.fail((String)("Target file " + targetResource.getTsFile().getPath() + " contains empty chunk group " + deviceID));
                        continue block10;
                    }
                    case 4: {
                        reader.readPlanIndex();
                        continue block10;
                    }
                }
                throw new IOException("Unexpected marker " + marker);
            }
        }
    }

    protected TsFileResource createEmptyFileAndResource(boolean isSeq) {
        String fileName = System.currentTimeMillis() + "-" + this.fileVersion + "-0-0.tsfile";
        String filePath = isSeq ? SEQ_DIRS.getPath() + File.separator + fileName : UNSEQ_DIRS.getPath() + File.separator + fileName;
        TsFileResource resource = new TsFileResource(new File(filePath));
        resource.updatePlanIndexes((long)this.fileVersion++);
        resource.setStatus(TsFileResourceStatus.CLOSED);
        return resource;
    }

    protected void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }
}

