/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.net.URL;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBDescriptorTest {
    private final String confPath = System.getProperty("IOTDB_CONF", null);

    @Before
    public void init() {
        TomcatURLStreamHandlerFactory.getInstance();
    }

    @After
    public void clear() {
        if (this.confPath != null) {
            System.setProperty("IOTDB_CONF", this.confPath);
        } else {
            System.clearProperty("IOTDB_CONF");
        }
    }

    @Test
    public void testConfigURLWithFileProtocol() {
        IoTDBDescriptor desc = IoTDBDescriptor.getInstance();
        String pathString = "file:/usr/local/bin";
        System.setProperty("IOTDB_CONF", pathString);
        URL confURL = desc.getPropsUrl("iotdb-datanode.properties");
        Assert.assertTrue((boolean)confURL.toString().startsWith(pathString));
    }

    @Test
    public void testConfigURLWithClasspathProtocol() {
        IoTDBDescriptor desc = IoTDBDescriptor.getInstance();
        String pathString = "classpath:/root/path";
        System.setProperty("IOTDB_CONF", pathString);
        URL confURL = desc.getPropsUrl("iotdb-datanode.properties");
        Assert.assertTrue((boolean)confURL.toString().startsWith(pathString));
    }

    @Test
    public void testConfigURLWithPlainFilePath() {
        IoTDBDescriptor desc = IoTDBDescriptor.getInstance();
        URL path = IoTDBConfig.class.getResource("/iotdb-datanode.properties");
        String filePath = path.getFile();
        System.setProperty("IOTDB_CONF", filePath);
        URL confURL = desc.getPropsUrl("iotdb-datanode.properties");
        Assert.assertEquals((Object)confURL.toString(), (Object)path.toString());
    }
}

