/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.apache.iotdb.db.auth.BasicAuthorityCache;
import org.apache.iotdb.db.auth.ClusterAuthorityFetcher;
import org.apache.iotdb.db.auth.IAuthorCache;
import org.apache.iotdb.rpc.TSStatusCode;
import org.junit.Assert;
import org.junit.Test;

public class AuthorizerManagerTest {
    ClusterAuthorityFetcher authorityFetcher = new ClusterAuthorityFetcher((IAuthorCache)new BasicAuthorityCache());

    @Test
    public void permissionCacheTest() {
        User user = new User();
        Role role1 = new Role();
        Role role2 = new Role();
        ArrayList<String> roleList = new ArrayList<String>();
        HashSet<Integer> privilegesIds = new HashSet<Integer>();
        PathPrivilege privilege = new PathPrivilege();
        ArrayList<PathPrivilege> privilegeList = new ArrayList<PathPrivilege>();
        privilegesIds.add(PrivilegeType.CREATE_ROLE.ordinal());
        privilegesIds.add(PrivilegeType.REVOKE_USER_ROLE.ordinal());
        privilege.setPath("root.ln");
        privilege.setPrivileges(privilegesIds);
        privilegeList.add(privilege);
        role1.setName("role1");
        role1.setPrivilegeList(privilegeList);
        role2.setName("role2");
        role2.setPrivilegeList(new ArrayList());
        roleList.add("role1");
        roleList.add("role2");
        user.setName("user");
        user.setPassword("password");
        user.setPrivilegeList(privilegeList);
        user.setRoleList(roleList);
        TPermissionInfoResp result = new TPermissionInfoResp();
        TUserResp tUserResp = new TUserResp();
        HashMap<String, TRoleResp> tRoleRespMap = new HashMap<String, TRoleResp>();
        ArrayList<String> userPrivilegeList = new ArrayList<String>();
        ArrayList<String> rolePrivilegeList = new ArrayList<String>();
        ArrayList<Role> roleList1 = new ArrayList<Role>();
        roleList1.add(role1);
        roleList1.add(role2);
        for (Object pathPrivilege : user.getPrivilegeList()) {
            userPrivilegeList.add(pathPrivilege.getPath());
            String privilegeIdList = pathPrivilege.getPrivileges().toString();
            userPrivilegeList.add(privilegeIdList.substring(1, privilegeIdList.length() - 1));
        }
        tUserResp.setUsername(user.getName());
        tUserResp.setPassword(user.getPassword());
        tUserResp.setPrivilegeList(userPrivilegeList);
        tUserResp.setRoleList(new ArrayList());
        result.setUserInfo(tUserResp);
        result.setRoleInfo(new HashMap());
        this.authorityFetcher.getAuthorCache().putUserCache(user.getName(), this.authorityFetcher.cacheUser(result));
        User user1 = this.authorityFetcher.getAuthorCache().getUserCache(user.getName());
        assert (user1 != null);
        Assert.assertEquals((Object)user.getName(), (Object)user1.getName());
        Assert.assertEquals((Object)user.getPassword(), (Object)user1.getPassword());
        Assert.assertEquals((Object)user.getPrivilegeList(), (Object)user1.getPrivilegeList());
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)this.authorityFetcher.checkUserPrivileges("user", Collections.singletonList("root.ln"), PrivilegeType.CREATE_ROLE.ordinal()).getCode());
        Assert.assertEquals((long)TSStatusCode.NO_PERMISSION.getStatusCode(), (long)this.authorityFetcher.checkUserPrivileges("user", Collections.singletonList("root.ln"), PrivilegeType.CREATE_USER.ordinal()).getCode());
        this.authorityFetcher.getAuthorCache().invalidateCache(user.getName(), "");
        tUserResp.setPrivilegeList(new ArrayList());
        tUserResp.setRoleList(user.getRoleList());
        for (Role role : roleList1) {
            TRoleResp tRoleResp = new TRoleResp();
            rolePrivilegeList = new ArrayList();
            tRoleResp.setRoleName(role.getName());
            for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                rolePrivilegeList.add(pathPrivilege.getPath());
                String privilegeIdList = pathPrivilege.getPrivileges().toString();
                rolePrivilegeList.add(privilegeIdList.substring(1, privilegeIdList.length() - 1));
            }
            tRoleResp.setPrivilegeList(rolePrivilegeList);
            tRoleRespMap.put(role.getName(), tRoleResp);
        }
        result.setRoleInfo(tRoleRespMap);
        this.authorityFetcher.getAuthorCache().putUserCache(user.getName(), this.authorityFetcher.cacheUser(result));
        Role role3 = this.authorityFetcher.getAuthorCache().getRoleCache(role1.getName());
        Assert.assertEquals((Object)role1.getName(), (Object)role3.getName());
        Assert.assertEquals((Object)role1.getPrivilegeList(), (Object)role3.getPrivilegeList());
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)this.authorityFetcher.checkUserPrivileges("user", Collections.singletonList("root.ln"), PrivilegeType.CREATE_ROLE.ordinal()).getCode());
        Assert.assertEquals((long)TSStatusCode.NO_PERMISSION.getStatusCode(), (long)this.authorityFetcher.checkUserPrivileges("user", Collections.singletonList("root.ln"), PrivilegeType.CREATE_USER.ordinal()).getCode());
        this.authorityFetcher.getAuthorCache().invalidateCache(user.getName(), "");
        user1 = this.authorityFetcher.getAuthorCache().getUserCache(user.getName());
        role1 = this.authorityFetcher.getAuthorCache().getRoleCache(role1.getName());
        Assert.assertNull((Object)user1);
        Assert.assertNull((Object)role1);
    }
}

