/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.allocation;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.FolderManager;
import org.apache.iotdb.db.conf.directories.strategy.DirectoryStrategyType;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.wal.allocation.NodeAllocationStrategy;
import org.apache.iotdb.db.wal.node.IWALNode;
import org.apache.iotdb.db.wal.node.WALFakeNode;
import org.apache.iotdb.db.wal.node.WALNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeAllocationStrategy
implements NodeAllocationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNodeAllocationStrategy.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected FolderManager folderManager;

    public AbstractNodeAllocationStrategy() {
        try {
            this.folderManager = new FolderManager(Arrays.asList(config.getWalDirs()), DirectoryStrategyType.SEQUENCE_STRATEGY);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Fail to create wal node allocation strategy because all disks of wal folders are full.", (Throwable)((Object)e));
        }
    }

    protected IWALNode createWALNode(String identifier) {
        String folder;
        try {
            folder = this.folderManager.getNextFolder();
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Fail to create wal node because all disks of wal folders are full.", (Throwable)((Object)e));
            return WALFakeNode.getFailureInstance((Exception)((Object)e));
        }
        folder = folder + File.separator + identifier;
        return this.createWALNode(identifier, folder);
    }

    protected IWALNode createWALNode(String identifier, String folder) {
        try {
            return new WALNode(identifier, folder);
        }
        catch (FileNotFoundException e) {
            logger.error("Fail to create wal node", (Throwable)e);
            return WALFakeNode.getFailureInstance(e);
        }
    }

    protected IWALNode createWALNode(String identifier, String folder, long startFileVersion, long startSearchIndex) {
        try {
            return new WALNode(identifier, folder, startFileVersion, startSearchIndex);
        }
        catch (FileNotFoundException e) {
            logger.error("Fail to create wal node", (Throwable)e);
            return WALFakeNode.getFailureInstance(e);
        }
    }
}

