/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.timerangeiterator;

import org.apache.iotdb.db.qp.utils.DatetimeUtils;
import org.apache.iotdb.db.utils.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public class AggrWindowIterator
implements ITimeRangeIterator {
    private final long startTime;
    private final long endTime;
    private final long interval;
    private final long slidingStep;
    private final boolean isAscending;
    private final boolean isSlidingStepByMonth;
    private final boolean isIntervalByMonth;
    private TimeRange curTimeRange;

    public AggrWindowIterator(long startTime, long endTime, long interval, long slidingStep, boolean isAscending, boolean isSlidingStepByMonth, boolean isIntervalByMonth) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.interval = interval;
        this.slidingStep = slidingStep;
        this.isAscending = isAscending;
        this.isSlidingStepByMonth = isSlidingStepByMonth;
        this.isIntervalByMonth = isIntervalByMonth;
    }

    @Override
    public TimeRange getFirstTimeRange() {
        if (this.isAscending) {
            return this.getLeftmostTimeRange();
        }
        return this.getRightmostTimeRange();
    }

    private TimeRange getLeftmostTimeRange() {
        long retEndTime = this.isIntervalByMonth ? Math.min(DatetimeUtils.calcIntervalByMonth(this.startTime, this.interval), this.endTime) : Math.min(this.startTime + this.interval, this.endTime);
        return new TimeRange(this.startTime, retEndTime);
    }

    private TimeRange getRightmostTimeRange() {
        long retStartTime;
        long queryRange = this.endTime - this.startTime;
        if (this.isSlidingStepByMonth) {
            long intervalNum = (long)Math.ceil((double)queryRange / (double)(this.slidingStep * 2592000000L));
            retStartTime = DatetimeUtils.calcIntervalByMonth(this.startTime, intervalNum * this.slidingStep);
            while (retStartTime >= this.endTime) {
                retStartTime = DatetimeUtils.calcIntervalByMonth(this.startTime, --intervalNum * this.slidingStep);
            }
        } else {
            long intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep);
            retStartTime = this.slidingStep * (intervalNum - 1L) + this.startTime;
        }
        long retEndTime = this.isIntervalByMonth ? Math.min(DatetimeUtils.calcIntervalByMonth(retStartTime, this.interval), this.endTime) : Math.min(retStartTime + this.interval, this.endTime);
        return new TimeRange(retStartTime, retEndTime);
    }

    @Override
    public boolean hasNextTimeRange() {
        long retStartTime;
        if (this.curTimeRange == null) {
            this.curTimeRange = this.getFirstTimeRange();
            return true;
        }
        long curStartTime = this.curTimeRange.getMin();
        if (this.isAscending ? (retStartTime = this.isSlidingStepByMonth ? DatetimeUtils.calcIntervalByMonth(curStartTime, (int)this.slidingStep) : curStartTime + this.slidingStep) >= this.endTime : (retStartTime = this.isSlidingStepByMonth ? DatetimeUtils.calcIntervalByMonth(curStartTime, (int)(-this.slidingStep)) : curStartTime - this.slidingStep) < this.startTime) {
            return false;
        }
        long retEndTime = this.isIntervalByMonth ? DatetimeUtils.calcIntervalByMonth(retStartTime, (int)this.interval) : retStartTime + this.interval;
        retEndTime = Math.min(retEndTime, this.endTime);
        this.curTimeRange = new TimeRange(retStartTime, retEndTime);
        return true;
    }

    @Override
    public TimeRange nextTimeRange() {
        if (this.curTimeRange != null || this.hasNextTimeRange()) {
            return this.curTimeRange;
        }
        return null;
    }

    @Override
    public boolean isAscending() {
        return this.isAscending;
    }
}

