/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;

public class IExpressionDeserializeUtil {
    public static IExpression deserialize(ByteBuffer byteBuffer) {
        ExpressionType expressionType = ExpressionType.values()[byteBuffer.get()];
        switch (expressionType) {
            case OR: {
                return BinaryExpression.or((IExpression)IExpressionDeserializeUtil.deserialize(byteBuffer), (IExpression)IExpressionDeserializeUtil.deserialize(byteBuffer));
            }
            case AND: {
                return BinaryExpression.and((IExpression)IExpressionDeserializeUtil.deserialize(byteBuffer), (IExpression)IExpressionDeserializeUtil.deserialize(byteBuffer));
            }
            case SERIES: {
                return new SingleSeriesExpression(PathDeserializeUtil.deserialize(byteBuffer), FilterFactory.deserialize((ByteBuffer)byteBuffer));
            }
            case GLOBAL_TIME: {
                return GlobalTimeExpression.deserialize((ByteBuffer)byteBuffer);
            }
            case TRUE: {
                return null;
            }
        }
        throw new UnsupportedOperationException("unSupport expressionType");
    }
}

