/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.externalpipe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.sync.datasource.PipeOpManager;
import org.apache.iotdb.db.sync.datasource.PipeStorageGroupInfo;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginConfiguration;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginManager;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginRegister;
import org.apache.iotdb.db.sync.externalpipe.ExternalPipeStatus;
import org.apache.iotdb.db.sync.externalpipe.operation.DeleteOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.InsertOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.apache.iotdb.pipe.external.api.DataType;
import org.apache.iotdb.pipe.external.api.ExternalPipeSinkWriterStatus;
import org.apache.iotdb.pipe.external.api.IExternalPipeSinkWriter;
import org.apache.iotdb.pipe.external.api.IExternalPipeSinkWriterFactory;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtPipePlugin {
    private static final Logger logger = LoggerFactory.getLogger(ExtPipePlugin.class);
    private String extPipeTypeName;
    Map<String, String> sinkParams;
    private PipeOpManager pipeOpManager;
    private ExtPipePluginManager extPipePluginManager;
    private IExternalPipeSinkWriterFactory pipeSinkWriterFactory;
    private ExtPipePluginConfiguration configuration;
    private volatile boolean alive = false;
    private List<DataTransmissionTask> dataTransmissionTasks;
    private ExecutorService executorService;
    private Map<String, Long> dataCommitMap = new ConcurrentHashMap<String, Long>();
    private Map<String, Map<String, AtomicInteger>> writerInvocationFailures;
    private int timestampDivisor;

    public ExtPipePlugin(String extPipeTypeName, Map<String, String> sinkParams, ExtPipePluginManager extPipePluginManager, PipeOpManager pipeOpManager) {
        String timePrecision;
        this.extPipeTypeName = extPipeTypeName;
        this.sinkParams = sinkParams;
        this.pipeOpManager = pipeOpManager;
        this.extPipePluginManager = extPipePluginManager;
        switch (timePrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ms": {
                this.timestampDivisor = 1;
                break;
            }
            case "us": {
                this.timestampDivisor = 1000;
                break;
            }
            case "ns": {
                this.timestampDivisor = 1000000;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized time precision: " + timePrecision);
            }
        }
    }

    public ExtPipePlugin(String Name2, IExternalPipeSinkWriterFactory factory, ExtPipePluginConfiguration conf, TsFilePipe tsFilePipe) {
    }

    public void setPipeSinkWriterFactory(IExternalPipeSinkWriterFactory pipeSinkWriterFactory) {
        this.pipeSinkWriterFactory = pipeSinkWriterFactory;
    }

    private int getIntParam(String paramName, int defaultValue) {
        String valueStr = this.sinkParams.get(paramName);
        if (valueStr == null) {
            return defaultValue;
        }
        return Integer.parseInt(valueStr);
    }

    public void start() throws IOException {
        logger.debug("ExtPipePlugin start(), extPipeName={}.", (Object)this.extPipeTypeName);
        if (this.alive) {
            String errMsg = "Can not re-run alive External pipe: " + this.extPipeTypeName + ".";
            logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        int threadNum = this.getIntParam("thread_num", 1);
        int batchSize = this.getIntParam("batch_size", 100000);
        int attemptTimes = this.getIntParam("attempt_times", 3);
        int backoffInterval = this.getIntParam("retry_interval", 1000);
        try {
            this.configuration = new ExtPipePluginConfiguration.Builder(this.extPipeTypeName).numOfThreads(threadNum).operationBatchSize(batchSize).attemptTimes(attemptTimes).backOffInterval(backoffInterval).build();
            if (this.pipeSinkWriterFactory == null) {
                this.pipeSinkWriterFactory = ExtPipePluginRegister.getInstance().getWriteFactory(this.extPipeTypeName);
            }
            this.pipeSinkWriterFactory.initialize(this.sinkParams);
        }
        catch (Exception e) {
            logger.error("Failed to start External Pipe: {}.", (Object)this.extPipeTypeName, (Object)e);
            throw new IOException("Failed to start External Pipe: " + this.extPipeTypeName + ". " + e.getMessage());
        }
        this.alive = true;
        logger.info("External pipe " + this.extPipeTypeName + " begin to START");
        this.executorService = IoTDBThreadPoolFactory.newFixedThreadPool((int)threadNum, (String)(ThreadName.EXT_PIPE_PLUGIN_WORKER.getName() + "-" + this.extPipeTypeName));
        this.dataTransmissionTasks = new ArrayList<DataTransmissionTask>(threadNum);
        for (int i = 0; i < threadNum; ++i) {
            IExternalPipeSinkWriter writer = (IExternalPipeSinkWriter)this.pipeSinkWriterFactory.get();
            DataTransmissionTask dataTransmissionTask = new DataTransmissionTask(writer, i, this.configuration);
            this.dataTransmissionTasks.add(dataTransmissionTask);
            this.executorService.submit(dataTransmissionTask);
        }
        this.writerInvocationFailures = new ConcurrentHashMap<String, Map<String, AtomicInteger>>();
        logger.info("External pipe " + this.extPipeTypeName + " finish START.");
    }

    public void stop() {
        if (!this.alive) {
            String errMsg = "Error: External pipe " + this.extPipeTypeName + " has not started.";
            logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        this.alive = false;
        this.executorService.shutdown();
        boolean isExecutorServiceTerminated = false;
        try {
            isExecutorServiceTerminated = this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted when waiting for the termination of external pipe, " + this.extPipeTypeName, (Throwable)e);
        }
        finally {
            if (!isExecutorServiceTerminated) {
                logger.warn("ExtPipePlugin stop(), graceful termination of external pipe {} timed out. So force terminating working threads.", (Object)this.extPipeTypeName);
                this.executorService.shutdownNow();
            }
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    public ExternalPipeStatus getStatus() {
        ExternalPipeStatus status = new ExternalPipeStatus();
        try {
            List<ExternalPipeSinkWriterStatus> writerStatuses = this.dataTransmissionTasks.stream().map(DataTransmissionTask::getStatus).collect(Collectors.toList());
            status.setWriterStatuses(writerStatuses);
        }
        catch (Exception e) {
            this.handleExceptionsThrownByWriter("getStatus", e);
        }
        status.setAlive(this.alive);
        status.setWriterInvocationFailures(this.writerInvocationFailures);
        return status;
    }

    private void handleExceptionsThrownByWriter(String method, Exception e) {
        this.writerInvocationFailures.computeIfAbsent(method, m -> new ConcurrentHashMap());
        String eMsg = e.getMessage();
        if (eMsg == null) {
            eMsg = "N/A";
        }
        this.writerInvocationFailures.get(method).computeIfAbsent(eMsg, msg -> new AtomicInteger(0));
        this.writerInvocationFailures.get(method).get(eMsg).incrementAndGet();
        logger.info("Exception thrown from writer", (Throwable)e);
    }

    public long getDataCommitIndex(String sgName) {
        return this.dataCommitMap.getOrDefault(sgName, Long.MIN_VALUE);
    }

    private int getThreadIndex(String sgName) {
        return Math.abs(sgName.hashCode()) % this.configuration.getNumOfThreads();
    }

    public void notifyNewDataArrive(String sgName, long newDataBeginIndex, long newDataCount) {
        logger.debug("notifyNewDataArrive(), sgName={}, newDataBeginIndex={}, newDataCount={}", new Object[]{sgName, newDataBeginIndex, newDataCount});
        DataTransmissionTask dataTransmissionTask = this.dataTransmissionTasks.get(this.getThreadIndex(sgName));
        if (dataTransmissionTask != null) {
            dataTransmissionTask.notifyNewDataArrive(sgName, newDataBeginIndex, newDataCount);
        }
    }

    private class DataTransmissionTask
    implements Callable<Void> {
        private final IExternalPipeSinkWriter writer;
        private final int threadIndex;
        private final ExtPipePluginConfiguration configuration;
        private Map<String, PipeStorageGroupInfo> sgInfoMap;
        private long nextIndex;
        private String lastReadSgName;
        private byte[] newDataLocker = new byte[0];
        private long newDataCounter = 0L;

        DataTransmissionTask(IExternalPipeSinkWriter writer, int threadIndex, ExtPipePluginConfiguration configuration) throws IOException {
            this.writer = (IExternalPipeSinkWriter)Validate.notNull((Object)writer);
            this.threadIndex = threadIndex;
            this.configuration = configuration;
            this.sgInfoMap = configuration.getBucketSgInfoMap(threadIndex);
            this.writer.open();
        }

        private long getSgNextDataIndex(String sgName) {
            PipeStorageGroupInfo sgInfo = this.sgInfoMap.get(sgName);
            if (sgInfo != null) {
                return sgInfo.getNextReadIndex();
            }
            long nextReadIndex = ExtPipePlugin.this.pipeOpManager.getCommittedIndex(sgName) + 1L;
            this.sgInfoMap.put(sgName, new PipeStorageGroupInfo(sgName, nextReadIndex - 1L, nextReadIndex));
            return nextReadIndex;
        }

        private void setSgNextDataIndex(String sgName, long nextReadIndex, long committedIndex) {
            logger.debug("setSgNextDataIndex(), sgName={}, nextReadIndex={}, committedIndex={}.", new Object[]{sgName, nextReadIndex, committedIndex});
            PipeStorageGroupInfo sgInfo = this.sgInfoMap.computeIfAbsent(sgName, k -> new PipeStorageGroupInfo(sgName, -1L, 0L));
            sgInfo.setNextReadIndex(nextReadIndex);
            sgInfo.setCommittedIndex(committedIndex);
        }

        private void commitData(String sgName, long committedIndex) throws IOException {
            logger.debug("commitData(), sgName={}, committedIndex={}.", (Object)sgName, (Object)committedIndex);
            ExtPipePlugin.this.dataCommitMap.put(sgName, committedIndex);
            if (ExtPipePlugin.this.pipeOpManager.opBlockNeedCommit(sgName, committedIndex)) {
                ExtPipePlugin.this.extPipePluginManager.triggerCommit(sgName, committedIndex);
            }
        }

        private boolean sgHasNewData(String sgName) {
            PipeStorageGroupInfo pipeStorageGroupInfo = this.sgInfoMap.get(sgName);
            if (pipeStorageGroupInfo == null) {
                return true;
            }
            long nextReadIndex = pipeStorageGroupInfo.getNextReadIndex();
            long nextIndex = ExtPipePlugin.this.pipeOpManager.getNextIndex(sgName);
            return nextIndex > nextReadIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyNewDataArrive(String sgName, long newDataBeginIndex, long newDataCount) {
            byte[] byArray = this.newDataLocker;
            synchronized (this.newDataLocker) {
                ++this.newDataCounter;
                this.newDataLocker.notifyAll();
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public String waitForOperations() throws InterruptedException {
            if (this.lastReadSgName != null) {
                if (this.sgHasNewData(this.lastReadSgName)) {
                    return this.lastReadSgName;
                }
                this.lastReadSgName = null;
            }
            while (ExtPipePlugin.this.alive) {
                Set<String> sgSet = ExtPipePlugin.this.pipeOpManager.getSgSet();
                for (String sgName : sgSet) {
                    if (this.threadIndex != ExtPipePlugin.this.getThreadIndex(sgName) || !this.sgHasNewData(sgName)) continue;
                    this.lastReadSgName = sgName;
                    return sgName;
                }
                byte[] byArray = this.newDataLocker;
                // MONITORENTER : this.newDataLocker
                if (this.newDataCounter <= 0L) {
                    try {
                        this.newDataLocker.wait(15000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.newDataCounter = 0L;
                // MONITOREXIT : byArray
            }
            return null;
        }

        @Override
        public Void call() throws Exception {
            logger.info("ExternalPipeWorker start. thread={}.", (Object)Thread.currentThread().getName());
            while (ExtPipePlugin.this.alive) {
                try {
                    String sgName = this.waitForOperations();
                    if (sgName == null) continue;
                    Operation operation = null;
                    try {
                        operation = ExtPipePlugin.this.pipeOpManager.getOperation(sgName, this.getSgNextDataIndex(sgName), this.configuration.getOperationBatchSize());
                    }
                    catch (IOException e) {
                        continue;
                    }
                    if (operation == null || operation.getDataCount() <= 0L) continue;
                    if (!this.handleOperationWithRetry(sgName, operation)) {
                        logger.error("Failed to handle operation after " + this.configuration.getAttemptTimes() + " attempts: " + operation);
                    }
                    if (!this.flushWithRetry()) {
                        logger.error("Failed to flush operations after " + this.configuration.getAttemptTimes() + " attempts: startIndex=" + operation.getStartIndex() + ",endIndex=" + operation.getEndIndex());
                    }
                    this.nextIndex = operation.getEndIndex();
                    this.setSgNextDataIndex(sgName, this.nextIndex, this.nextIndex - 1L);
                    this.commitData(sgName, this.nextIndex - 1L);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    logger.error("Unexpected system exception", (Throwable)e);
                }
            }
            try {
                this.writer.close();
            }
            catch (IOException e) {
                ExtPipePlugin.this.handleExceptionsThrownByWriter("close", e);
                logger.info("Exception happened when closing the writer", (Throwable)e);
            }
            logger.info("ExternalPipeWorker exits. Thread={}", (Object)Thread.currentThread().getName());
            return null;
        }

        public ExternalPipeSinkWriterStatus getStatus() {
            return this.writer.getStatus();
        }

        private boolean handleOperationWithRetry(String sgName, Operation operation) {
            boolean succeed = false;
            int attemptTimes = this.configuration.getAttemptTimes();
            while (ExtPipePlugin.this.alive && attemptTimes > 0) {
                try {
                    this.pushOperationToExtPipe(sgName, operation);
                    succeed = true;
                    break;
                }
                catch (Exception e) {
                    logger.error("When handle operation {}, Exception", (Object)operation.getOperationType(), (Object)e);
                    ExtPipePlugin.this.handleExceptionsThrownByWriter(operation.getOperationTypeName(), e);
                    --attemptTimes;
                    try {
                        Thread.sleep(this.configuration.getBackOffInterval());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return succeed;
        }

        private void pushOperationToExtPipe(String sgName, Operation operation) throws IOException, IllegalArgumentException {
            if (operation instanceof InsertOperation) {
                this.handleInsertOperation(sgName, (InsertOperation)operation);
                return;
            }
            if (operation instanceof DeleteOperation) {
                this.handleDeleteOperation(sgName, (DeleteOperation)operation);
                return;
            }
            logger.error("pushOperationToExtPipe(), Unrecognized Operation: {}", (Object)operation);
            throw new IllegalArgumentException("pushOperationToExtPipe(), Unrecognized Operation:" + operation);
        }

        private void handleInsertOperation(String sgName, InsertOperation operation) throws IOException, IllegalArgumentException {
            for (Pair<MeasurementPath, List<TimeValuePair>> dataPair : operation.getDataList()) {
                MeasurementPath measurementPath = (MeasurementPath)((Object)dataPair.left);
                block10: for (TimeValuePair tvPair : (List)dataPair.right) {
                    if (tvPair == null) continue;
                    String[] path = measurementPath.getNodes();
                    long timestampInMs = tvPair.getTimestamp() / (long)ExtPipePlugin.this.timestampDivisor;
                    switch (tvPair.getValue().getDataType()) {
                        case BOOLEAN: {
                            this.writer.insertBoolean(sgName, path, timestampInMs, tvPair.getValue().getBoolean());
                            continue block10;
                        }
                        case INT32: {
                            this.writer.insertInt32(sgName, path, timestampInMs, tvPair.getValue().getInt());
                            continue block10;
                        }
                        case INT64: {
                            this.writer.insertInt64(sgName, path, timestampInMs, tvPair.getValue().getLong());
                            continue block10;
                        }
                        case FLOAT: {
                            this.writer.insertFloat(sgName, path, timestampInMs, tvPair.getValue().getFloat());
                            continue block10;
                        }
                        case DOUBLE: {
                            this.writer.insertDouble(sgName, path, timestampInMs, tvPair.getValue().getDouble());
                            continue block10;
                        }
                        case TEXT: {
                            this.writer.insertText(sgName, path, timestampInMs, tvPair.getValue().getStringValue());
                            continue block10;
                        }
                        case VECTOR: {
                            this.writer.insertVector(sgName, path, (DataType[])Arrays.stream(tvPair.getValue().getVector()).map(TsPrimitiveType::getDataType).map(type -> DataType.fromTsDataType((byte)type.serialize())).toArray(DataType[]::new), timestampInMs, (Object[])Arrays.stream(tvPair.getValue().getVector()).map(TsPrimitiveType::getValue).toArray(Object[]::new));
                            continue block10;
                        }
                    }
                    throw new IllegalArgumentException("Unrecognized data type " + tvPair.getValue().getDataType());
                }
            }
        }

        private void handleDeleteOperation(String sgName, DeleteOperation deleteOperation) throws IOException {
            this.writer.delete(sgName, deleteOperation.getDeletePathStr(), deleteOperation.getStartTime() / (long)ExtPipePlugin.this.timestampDivisor, deleteOperation.getEndTime() / (long)ExtPipePlugin.this.timestampDivisor);
        }

        private boolean flushWithRetry() {
            try {
                this.writer.flush();
            }
            catch (IOException e1) {
                logger.error("Exception happened when flushing operations", (Throwable)e1);
                ExtPipePlugin.this.handleExceptionsThrownByWriter("flush", e1);
                boolean succeed = false;
                for (int attemptTimes = 1; ExtPipePlugin.this.alive && attemptTimes < this.configuration.getAttemptTimes(); ++attemptTimes) {
                    try {
                        Thread.sleep(this.configuration.getBackOffInterval());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        this.writer.flush();
                        succeed = true;
                        break;
                    }
                    catch (Exception e2) {
                        ExtPipePlugin.this.handleExceptionsThrownByWriter("flush", e2);
                        continue;
                    }
                }
                return succeed;
            }
            return true;
        }
    }
}

