/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.reader.IAlignedPageReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class MemAlignedPageReader
implements IPageReader,
IAlignedPageReader {
    private final TsBlock tsBlock;
    private final AlignedChunkMetadata chunkMetadata;
    private Filter valueFilter;
    private TsBlockBuilder builder;

    public MemAlignedPageReader(TsBlock tsBlock, AlignedChunkMetadata chunkMetadata, Filter filter) {
        this.tsBlock = tsBlock;
        this.chunkMetadata = chunkMetadata;
        this.valueFilter = filter;
    }

    public BatchData getAllSatisfiedPageData() throws IOException {
        return super.getAllSatisfiedPageData();
    }

    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)TSDataType.VECTOR, (boolean)ascending, (boolean)false);
        for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
            Object firstNotNullObject = null;
            for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
                if (this.tsBlock.getColumn(column).isNull(row)) continue;
                firstNotNullObject = this.tsBlock.getColumn(column).getObject(row);
                break;
            }
            if (firstNotNullObject == null || this.valueFilter != null && !this.valueFilter.satisfy(this.tsBlock.getTimeByIndex(row), firstNotNullObject)) continue;
            TsPrimitiveType[] values = new TsPrimitiveType[this.tsBlock.getValueColumnCount()];
            for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
                if (this.tsBlock.getColumn(column) == null || this.tsBlock.getColumn(column).isNull(row)) continue;
                values[column] = this.tsBlock.getColumn(column).getTsPrimitiveType(row);
            }
            batchData.putVector(this.tsBlock.getTimeByIndex(row), values);
        }
        return batchData.flip();
    }

    public TsBlock getAllSatisfiedData() {
        Column valueColumn;
        int column;
        this.builder.reset();
        boolean[] satisfyInfo = new boolean[this.tsBlock.getPositionCount()];
        for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
            long time = this.tsBlock.getTimeByIndex(row);
            if (this.valueFilter != null && !this.valueFilter.satisfy(time, null)) continue;
            satisfyInfo[row] = true;
        }
        boolean[] hasValue = new boolean[this.tsBlock.getPositionCount()];
        for (column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            valueColumn = this.tsBlock.getColumn(column);
            for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                hasValue[row] = hasValue[row] || !valueColumn.isNull(row);
            }
        }
        for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
            if (!satisfyInfo[row] || !hasValue[row]) continue;
            this.builder.getTimeColumnBuilder().writeLong(this.tsBlock.getTimeByIndex(row));
            this.builder.declarePosition();
        }
        for (column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            valueColumn = this.tsBlock.getColumn(column);
            ColumnBuilder valueBuilder = this.builder.getColumnBuilder(column);
            for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                if (!satisfyInfo[row] || !hasValue[row]) continue;
                if (!valueColumn.isNull(row)) {
                    valueBuilder.write(valueColumn, row);
                    continue;
                }
                valueBuilder.appendNull();
            }
        }
        return this.builder.build();
    }

    public Statistics getStatistics() {
        return this.chunkMetadata.getStatistics();
    }

    public Statistics getStatistics(int index) {
        return this.chunkMetadata.getStatistics(index);
    }

    public Statistics getTimeStatistics() {
        return this.chunkMetadata.getTimeStatistics();
    }

    public void setFilter(Filter filter) {
        this.valueFilter = this.valueFilter == null ? filter : new AndFilter(this.valueFilter, filter);
    }

    public boolean isModified() {
        return false;
    }

    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
        this.builder = new TsBlockBuilder(dataTypes);
    }
}

