/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.groupby;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.executor.groupby.SlidingWindowGroupByExecutor;
import org.apache.iotdb.db.query.executor.groupby.impl.EmptyQueueSlidingWindowGroupByExecutor;
import org.apache.iotdb.db.query.executor.groupby.impl.MonotonicQueueSlidingWindowGroupByExecutor;
import org.apache.iotdb.db.query.executor.groupby.impl.NormalQueueSlidingWindowGroupByExecutor;
import org.apache.iotdb.db.query.executor.groupby.impl.SmoothQueueSlidingWindowGroupByExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class SlidingWindowGroupByExecutorFactory {
    private static final Map<TSDataType, Comparator<AggregateResult>> maxComparators = new HashMap<TSDataType, Comparator<AggregateResult>>();
    private static final Map<TSDataType, Comparator<AggregateResult>> minComparators = new HashMap<TSDataType, Comparator<AggregateResult>>();
    private static final Map<TSDataType, Comparator<AggregateResult>> extremeComparators = new HashMap<TSDataType, Comparator<AggregateResult>>();

    public static SlidingWindowGroupByExecutor getSlidingWindowGroupByExecutor(String aggrFuncName, TSDataType dataType, boolean ascending) {
        if (aggrFuncName == null) {
            throw new IllegalArgumentException("AggregateFunction Name must not be null");
        }
        switch (aggrFuncName.toLowerCase()) {
            case "sum": 
            case "avg": 
            case "count": {
                return new SmoothQueueSlidingWindowGroupByExecutor(dataType, aggrFuncName, ascending);
            }
            case "max_value": {
                return new MonotonicQueueSlidingWindowGroupByExecutor(dataType, aggrFuncName, ascending, maxComparators.get(dataType));
            }
            case "min_value": {
                return new MonotonicQueueSlidingWindowGroupByExecutor(dataType, aggrFuncName, ascending, minComparators.get(dataType));
            }
            case "extreme": {
                return new MonotonicQueueSlidingWindowGroupByExecutor(dataType, aggrFuncName, ascending, extremeComparators.get(dataType));
            }
            case "min_time": 
            case "first_value": {
                return !ascending ? new EmptyQueueSlidingWindowGroupByExecutor(dataType, aggrFuncName, ascending) : new NormalQueueSlidingWindowGroupByExecutor(dataType, aggrFuncName, ascending);
            }
            case "max_time": 
            case "last_value": {
                return !ascending ? new NormalQueueSlidingWindowGroupByExecutor(dataType, aggrFuncName, ascending) : new EmptyQueueSlidingWindowGroupByExecutor(dataType, aggrFuncName, ascending);
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation Type: " + aggrFuncName);
    }

    static {
        maxComparators.put(TSDataType.INT32, Comparator.comparingInt(AggregateResult::getIntValue));
        maxComparators.put(TSDataType.INT64, Comparator.comparingLong(AggregateResult::getLongValue));
        maxComparators.put(TSDataType.FLOAT, Comparator.comparing(AggregateResult::getFloatValue));
        maxComparators.put(TSDataType.DOUBLE, Comparator.comparingDouble(AggregateResult::getDoubleValue));
        minComparators.put(TSDataType.INT32, Comparator.comparingInt(AggregateResult::getIntValue).reversed());
        minComparators.put(TSDataType.INT64, Comparator.comparingLong(AggregateResult::getLongValue).reversed());
        minComparators.put(TSDataType.FLOAT, Comparator.comparing(AggregateResult::getFloatValue).reversed());
        minComparators.put(TSDataType.DOUBLE, Comparator.comparingDouble(AggregateResult::getDoubleValue).reversed());
        extremeComparators.put(TSDataType.INT32, Comparator.comparingInt(AggregateResult::getIntAbsValue).thenComparingInt(AggregateResult::getIntValue));
        extremeComparators.put(TSDataType.INT64, Comparator.comparingLong(AggregateResult::getLongAbsValue).thenComparingLong(AggregateResult::getLongValue));
        extremeComparators.put(TSDataType.FLOAT, Comparator.comparing(AggregateResult::getFloatAbsValue).thenComparing(AggregateResult::getFloatValue));
        extremeComparators.put(TSDataType.DOUBLE, Comparator.comparingDouble(AggregateResult::getDoubleAbsValue).thenComparingDouble(AggregateResult::getDoubleValue));
    }
}

