/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.index.common.IndexType;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateIndexPlan
extends PhysicalPlan {
    protected List<PartialPath> paths;
    private Map<String, String> props;
    private long time;
    private IndexType indexType;

    public CreateIndexPlan() {
        super(Operator.OperatorType.CREATE_INDEX);
        this.canBeSplit = false;
    }

    public CreateIndexPlan(List<PartialPath> paths, Map<String, String> props, long startTime, IndexType indexType) {
        super(Operator.OperatorType.CREATE_INDEX);
        this.paths = paths;
        this.props = props;
        this.time = startTime;
        this.indexType = indexType;
        this.canBeSplit = false;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_INDEX.ordinal());
        stream.write((byte)this.indexType.serialize());
        stream.writeLong(this.time);
        stream.writeInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(stream, path.getFullPath());
        }
        if (this.props != null && !this.props.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.props, (OutputStream)stream);
        } else {
            stream.write(0);
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.CREATE_INDEX.ordinal();
        buffer.put((byte)type);
        buffer.put((byte)this.indexType.serialize());
        buffer.putLong(this.time);
        buffer.putInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(buffer, path.getFullPath());
        }
        if (this.props != null && !this.props.isEmpty()) {
            buffer.put((byte)1);
            ReadWriteIOUtils.write(this.props, (ByteBuffer)buffer);
        } else {
            buffer.put((byte)0);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.indexType = IndexType.deserialize(buffer.get());
        this.time = buffer.getLong();
        int pathNum = buffer.getInt();
        this.paths = new ArrayList<PartialPath>();
        for (int i = 0; i < pathNum; ++i) {
            this.paths.add(new PartialPath(this.readString(buffer)));
        }
        if (buffer.get() == 1) {
            this.props = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
        this.index = buffer.getLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateIndexPlan that = (CreateIndexPlan)o;
        return Objects.equals(this.paths, that.paths) && Objects.equals(this.props, that.props) && this.time == that.time && Objects.equals((Object)this.indexType, (Object)that.indexType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paths, this.props, this.time, this.indexType});
    }

    public String toString() {
        return String.format("paths: %s, index type: %s, start time: %s, props: %s", new Object[]{this.paths, this.indexType, this.time, this.props});
    }
}

