/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class InsertRowsOfOneDeviceStatement
extends InsertBaseStatement {
    private List<InsertRowStatement> insertRowStatementList;

    public InsertRowsOfOneDeviceStatement() {
        this.statementType = StatementType.BATCH_INSERT_ONE_DEVICE;
    }

    @Override
    public boolean isEmpty() {
        return this.insertRowStatementList.isEmpty();
    }

    public List<InsertRowStatement> getInsertRowStatementList() {
        return this.insertRowStatementList;
    }

    public void setInsertRowStatementList(List<InsertRowStatement> insertRowStatementList) {
        this.insertRowStatementList = insertRowStatementList;
        if (insertRowStatementList == null || insertRowStatementList.size() == 0) {
            return;
        }
        this.devicePath = insertRowStatementList.get(0).getDevicePath();
        this.isAligned = insertRowStatementList.get((int)0).isAligned;
        HashMap<String, TSDataType> measurementsAndDataType = new HashMap<String, TSDataType>();
        for (InsertRowStatement insertRowStatement : insertRowStatementList) {
            List<String> measurements = Arrays.asList(insertRowStatement.getMeasurements());
            Map<String, TSDataType> subMap = measurements.stream().collect(Collectors.toMap(key -> key, key -> insertRowStatement.dataTypes[measurements.indexOf(key)]));
            measurementsAndDataType.putAll(subMap);
        }
        this.measurements = measurementsAndDataType.keySet().toArray(new String[0]);
        this.dataTypes = measurementsAndDataType.values().toArray(new TSDataType[0]);
    }

    public List<TTimePartitionSlot> getTimePartitionSlots() {
        HashSet<TTimePartitionSlot> timePartitionSlotSet = new HashSet<TTimePartitionSlot>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            timePartitionSlotSet.add(StorageEngineV2.getTimePartitionSlot(insertRowStatement.getTime()));
        }
        return new ArrayList<TTimePartitionSlot>(timePartitionSlotSet);
    }

    @Override
    public List<TEndPoint> collectRedirectInfo(DataPartition dataPartition) {
        return this.insertRowStatementList.get(this.insertRowStatementList.size() - 1).collectRedirectInfo(dataPartition);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRowsOfOneDevice(this, context);
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            PartialPath fullPath = this.devicePath.concatNode(m);
            ret.add(fullPath);
        }
        return ret;
    }
}

