/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.IPartitionRelatedNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeleteTimeSeriesNode
extends PlanNode
implements IPartitionRelatedNode {
    private final List<PartialPath> pathList;
    private TRegionReplicaSet regionReplicaSet;
    private List<PlanNode> children;

    public DeleteTimeSeriesNode(PlanNodeId id, List<PartialPath> pathList) {
        super(id);
        this.pathList = pathList;
        this.children = new ArrayList<PlanNode>();
    }

    public List<PartialPath> getPathList() {
        return this.pathList;
    }

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    @Override
    public PlanNode clone() {
        return new DeleteTimeSeriesNode(this.getPlanNodeId(), this.pathList);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeleteTimeseries(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DELETE_TIMESERIES.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.pathList.size(), (ByteBuffer)byteBuffer);
        for (PartialPath path : this.pathList) {
            path.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DELETE_TIMESERIES.serialize(stream);
        ReadWriteIOUtils.write((int)this.pathList.size(), (OutputStream)stream);
        for (PartialPath path : this.pathList) {
            path.serialize(stream);
        }
    }

    public static DeleteTimeSeriesNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>(size);
        for (int i = 0; i < size; ++i) {
            pathList.add((PartialPath)PathDeserializeUtil.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new DeleteTimeSeriesNode(planNodeId, pathList);
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    public String toString() {
        return String.format("DeleteTimeseriesNode-%s: %s. Region: %s", this.getPlanNodeId(), this.pathList, this.regionReplicaSet == null ? "Not Assigned" : this.regionReplicaSet.getRegionId());
    }
}

