/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PathsUsingTemplateScanNode
extends SchemaQueryScanNode {
    private int templateId;

    public PathsUsingTemplateScanNode(PlanNodeId id, int templateId) {
        super(id);
        this.templateId = templateId;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    @Override
    public PlanNode clone() {
        return new PathsUsingTemplateScanNode(this.getPlanNodeId(), this.templateId);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.showPathsUsingTemplateHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.PATHS_USING_TEMPLATE_SCAN.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.templateId, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.PATHS_USING_TEMPLATE_SCAN.serialize(stream);
        ReadWriteIOUtils.write((int)this.templateId, (OutputStream)stream);
    }

    public static PathsUsingTemplateScanNode deserialize(ByteBuffer buffer) {
        int templateId = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new PathsUsingTemplateScanNode(planNodeId, templateId);
    }
}

