/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.parser;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.enums.TriggerEvent;
import org.apache.iotdb.commons.trigger.enums.TriggerType;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SQLParserException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.mpp.common.filter.BasicFunctionFilter;
import org.apache.iotdb.db.mpp.common.filter.QueryFilter;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.InExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.component.FillComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.FillPolicy;
import org.apache.iotdb.db.mpp.plan.statement.component.FromComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByLevelComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.HavingCondition;
import org.apache.iotdb.db.mpp.plan.statement.component.OrderByComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultSetFormat;
import org.apache.iotdb.db.mpp.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;
import org.apache.iotdb.db.mpp.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.mpp.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.literal.BooleanLiteral;
import org.apache.iotdb.db.mpp.plan.statement.literal.DoubleLiteral;
import org.apache.iotdb.db.mpp.plan.statement.literal.Literal;
import org.apache.iotdb.db.mpp.plan.statement.literal.LongLiteral;
import org.apache.iotdb.db.mpp.plan.statement.literal.StringLiteral;
import org.apache.iotdb.db.mpp.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountLevelTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateFunctionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTriggerStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DropFunctionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DropTriggerStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowConfigNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowDataNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowFunctionsStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.UnSetTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathsUsingTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ClearCacheStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ExplainStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.FlushStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.LoadConfigurationStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.MergeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.SetSystemStatusStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ShowVersionStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.DropPipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.DropPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeSinkTypeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.StartPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.StopPipeStatement;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParser;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParserBaseVisitor;
import org.apache.iotdb.db.qp.utils.DatetimeUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.common.constant.TsFileConstant;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.Pair;

public class ASTVisitor
extends IoTDBSqlParserBaseVisitor<Statement> {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String DELETE_RANGE_ERROR_MSG = "For delete statement, where clause can only contain atomic expressions like : time > XXX, time <= XXX, or two atomic expressions connected by 'AND'";
    private static final String DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG = "For delete statement, where clause can only contain time expressions, value filter is not currently supported.";
    private static final Pattern leveledPathNodePattern = Pattern.compile("\\$\\{\\w+}");
    private ZoneId zoneId;
    private QueryStatement queryStatement;

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public Statement visitSingleStatement(IoTDBSqlParser.SingleStatementContext ctx) {
        Statement statement = (Statement)this.visit((ParseTree)ctx.statement());
        if (ctx.DEBUG() != null) {
            statement.setDebug(true);
        }
        return statement;
    }

    public Statement visitCreateNonAlignedTimeseries(IoTDBSqlParser.CreateNonAlignedTimeseriesContext ctx) {
        CreateTimeSeriesStatement createTimeSeriesStatement = new CreateTimeSeriesStatement();
        createTimeSeriesStatement.setPath(this.parseFullPath(ctx.fullPath()));
        if (ctx.attributeClauses() != null) {
            this.parseAttributeClauses(ctx.attributeClauses(), createTimeSeriesStatement);
        }
        return createTimeSeriesStatement;
    }

    public Statement visitCreateAlignedTimeseries(IoTDBSqlParser.CreateAlignedTimeseriesContext ctx) {
        CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement = new CreateAlignedTimeSeriesStatement();
        createAlignedTimeSeriesStatement.setDevicePath(this.parseFullPath(ctx.fullPath()));
        this.parseAlignedMeasurements(ctx.alignedMeasurements(), createAlignedTimeSeriesStatement);
        return createAlignedTimeSeriesStatement;
    }

    public void parseAlignedMeasurements(IoTDBSqlParser.AlignedMeasurementsContext ctx, CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement) {
        for (int i = 0; i < ctx.nodeNameWithoutWildcard().size(); ++i) {
            createAlignedTimeSeriesStatement.addMeasurement(this.parseNodeNameWithoutWildCard(ctx.nodeNameWithoutWildcard(i)));
            this.parseAttributeClauses(ctx.attributeClauses(i), createAlignedTimeSeriesStatement);
        }
    }

    public void parseAttributeClauses(IoTDBSqlParser.AttributeClausesContext ctx, CreateTimeSeriesStatement createTimeSeriesStatement) {
        if (ctx.aliasNodeName() != null) {
            createTimeSeriesStatement.setAlias(this.parseNodeName(ctx.aliasNodeName().nodeName()));
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (ctx.dataType != null) {
            if (ctx.attributeKey() != null && !this.parseAttributeKey(ctx.attributeKey()).equalsIgnoreCase("dataType")) {
                throw new SQLParserException("expecting datatype");
            }
            props.put("dataType".toLowerCase(), this.parseAttributeValue(ctx.dataType).toLowerCase());
        }
        List attributePairs = ctx.attributePair();
        if (ctx.attributePair(0) != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : attributePairs) {
                props.put(this.parseAttributeKey(attributePair.attributeKey()).toLowerCase(), this.parseAttributeValue(attributePair.attributeValue()).toLowerCase());
            }
        }
        createTimeSeriesStatement.setProps(props);
        this.checkPropsInCreateTimeSeries(createTimeSeriesStatement);
        if (ctx.tagClause() != null) {
            this.parseTagClause(ctx.tagClause(), createTimeSeriesStatement);
        }
        if (ctx.attributeClause() != null) {
            this.parseAttributeClause(ctx.attributeClause(), createTimeSeriesStatement);
        }
    }

    private void checkPropsInCreateTimeSeries(CreateTimeSeriesStatement createTimeSeriesStatement) {
        Map<String, String> props = createTimeSeriesStatement.getProps();
        if (props != null && props.containsKey("dataType".toLowerCase())) {
            String datatypeString = props.get("dataType".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesStatement.setDataType(TSDataType.valueOf((String)datatypeString));
                props.remove("dataType".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported datatype: %s", datatypeString));
            }
        }
        if (createTimeSeriesStatement.getDataType() == null) {
            throw new SemanticException("datatype must be declared");
        }
        IoTDBDescriptor ioTDBDescriptor = IoTDBDescriptor.getInstance();
        createTimeSeriesStatement.setEncoding(ioTDBDescriptor.getDefaultEncodingByType(createTimeSeriesStatement.getDataType()));
        if (props != null && props.containsKey("encoding".toLowerCase())) {
            String encodingString = props.get("encoding".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesStatement.setEncoding(TSEncoding.valueOf((String)encodingString));
                props.remove("encoding".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported encoding: %s", encodingString));
            }
        }
        createTimeSeriesStatement.setCompressor(TSFileDescriptor.getInstance().getConfig().getCompressor());
        if (props != null && props.containsKey("compression".toLowerCase())) {
            String compressionString = props.get("compression".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesStatement.setCompressor(CompressionType.valueOf((String)compressionString));
                props.remove("compression".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported compression: %s", compressionString));
            }
        }
        if (props != null && props.containsKey("compressor".toLowerCase())) {
            String compressorString = props.get("compressor".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesStatement.setCompressor(CompressionType.valueOf((String)compressorString));
                props.remove("compressor".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported compression: %s", compressorString));
            }
        }
        createTimeSeriesStatement.setProps(props);
    }

    public void parseAttributeClauses(IoTDBSqlParser.AttributeClausesContext ctx, CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement) {
        if (ctx.aliasNodeName() != null) {
            createAlignedTimeSeriesStatement.addAliasList(this.parseNodeName(ctx.aliasNodeName().nodeName()));
        } else {
            createAlignedTimeSeriesStatement.addAliasList(null);
        }
        TSDataType dataType = null;
        if (ctx.dataType != null) {
            if (ctx.attributeKey() != null && !this.parseAttributeKey(ctx.attributeKey()).equalsIgnoreCase("dataType")) {
                throw new SQLParserException("expecting datatype");
            }
            String dataTypeString = ctx.dataType.getText().toUpperCase();
            try {
                dataType = TSDataType.valueOf((String)dataTypeString);
                createAlignedTimeSeriesStatement.addDataType(dataType);
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported datatype: %s", dataTypeString));
            }
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (ctx.attributePair() != null) {
            for (int i = 0; i < ctx.attributePair().size(); ++i) {
                props.put(this.parseAttributeKey(ctx.attributePair(i).attributeKey()).toLowerCase(), this.parseAttributeValue(ctx.attributePair(i).attributeValue()));
            }
        }
        TSEncoding encoding = IoTDBDescriptor.getInstance().getDefaultEncodingByType(dataType);
        if (props.containsKey("encoding".toLowerCase())) {
            String encodingString = ((String)props.get("encoding".toLowerCase())).toUpperCase();
            try {
                encoding = TSEncoding.valueOf((String)encodingString);
                createAlignedTimeSeriesStatement.addEncoding(encoding);
                props.remove("encoding".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported encoding: %s", encodingString));
            }
        } else {
            createAlignedTimeSeriesStatement.addEncoding(encoding);
        }
        CompressionType compressor = TSFileDescriptor.getInstance().getConfig().getCompressor();
        if (props.containsKey("compressor".toLowerCase())) {
            String compressorString = ((String)props.get("compressor".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressorString);
                createAlignedTimeSeriesStatement.addCompressor(compressor);
                props.remove("compressor".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compressor: %s", compressorString));
            }
        } else if (props.containsKey("compression".toLowerCase())) {
            String compressionString = ((String)props.get("compression".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressionString);
                createAlignedTimeSeriesStatement.addCompressor(compressor);
                props.remove("compression".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compression: %s", compressionString));
            }
        } else {
            createAlignedTimeSeriesStatement.addCompressor(compressor);
        }
        if (props.size() > 0) {
            throw new SQLParserException("create aligned timeseries: property is not supported yet.");
        }
        if (ctx.tagClause() != null) {
            this.parseTagClause(ctx.tagClause(), createAlignedTimeSeriesStatement);
        } else {
            createAlignedTimeSeriesStatement.addTagsList(null);
        }
        if (ctx.attributeClause() != null) {
            this.parseAttributeClause(ctx.attributeClause(), createAlignedTimeSeriesStatement);
        } else {
            createAlignedTimeSeriesStatement.addAttributesList(null);
        }
    }

    public void parseTagClause(IoTDBSqlParser.TagClauseContext ctx, Statement statement) {
        Map<String, String> tags = this.extractMap(ctx.attributePair(), ctx.attributePair(0));
        if (statement instanceof CreateTimeSeriesStatement) {
            ((CreateTimeSeriesStatement)statement).setTags(tags);
        } else if (statement instanceof CreateAlignedTimeSeriesStatement) {
            ((CreateAlignedTimeSeriesStatement)statement).addTagsList(tags);
        } else if (statement instanceof AlterTimeSeriesStatement) {
            ((AlterTimeSeriesStatement)statement).setTagsMap(tags);
        }
    }

    public void parseAttributeClause(IoTDBSqlParser.AttributeClauseContext ctx, Statement statement) {
        Map<String, String> attributes = this.extractMap(ctx.attributePair(), ctx.attributePair(0));
        if (statement instanceof CreateTimeSeriesStatement) {
            ((CreateTimeSeriesStatement)statement).setAttributes(attributes);
        } else if (statement instanceof CreateAlignedTimeSeriesStatement) {
            ((CreateAlignedTimeSeriesStatement)statement).addAttributesList(attributes);
        } else if (statement instanceof AlterTimeSeriesStatement) {
            ((AlterTimeSeriesStatement)statement).setAttributesMap(attributes);
        }
    }

    public Statement visitAlterTimeseries(IoTDBSqlParser.AlterTimeseriesContext ctx) {
        AlterTimeSeriesStatement alterTimeSeriesStatement = new AlterTimeSeriesStatement();
        alterTimeSeriesStatement.setPath(this.parseFullPath(ctx.fullPath()));
        this.parseAlterClause(ctx.alterClause(), alterTimeSeriesStatement);
        return alterTimeSeriesStatement;
    }

    private void parseAlterClause(IoTDBSqlParser.AlterClauseContext ctx, AlterTimeSeriesStatement alterTimeSeriesStatement) {
        HashMap<String, String> alterMap = new HashMap<String, String>();
        if (ctx.RENAME() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.RENAME);
            alterMap.put(this.parseAttributeKey(ctx.beforeName), this.parseAttributeKey(ctx.currentName));
        } else if (ctx.SET() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.SET);
            this.setMap(ctx, alterMap);
        } else if (ctx.DROP() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.DROP);
            for (int i = 0; i < ctx.attributeKey().size(); ++i) {
                alterMap.put(this.parseAttributeKey((IoTDBSqlParser.AttributeKeyContext)ctx.attributeKey().get(i)), null);
            }
        } else if (ctx.TAGS() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.ADD_TAGS);
            this.setMap(ctx, alterMap);
        } else if (ctx.ATTRIBUTES() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.ADD_ATTRIBUTES);
            this.setMap(ctx, alterMap);
        } else {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.UPSERT);
            if (ctx.aliasClause() != null) {
                this.parseAliasClause(ctx.aliasClause(), alterTimeSeriesStatement);
            }
            if (ctx.tagClause() != null) {
                this.parseTagClause(ctx.tagClause(), alterTimeSeriesStatement);
            }
            if (ctx.attributeClause() != null) {
                this.parseAttributeClause(ctx.attributeClause(), alterTimeSeriesStatement);
            }
        }
        alterTimeSeriesStatement.setAlterMap(alterMap);
    }

    public void parseAliasClause(IoTDBSqlParser.AliasClauseContext ctx, AlterTimeSeriesStatement alterTimeSeriesStatement) {
        if (alterTimeSeriesStatement != null && ctx.ALIAS() != null) {
            alterTimeSeriesStatement.setAlias(this.parseAlias(ctx.alias()));
        }
    }

    public Statement visitDeleteTimeseries(IoTDBSqlParser.DeleteTimeseriesContext ctx) {
        DeleteTimeSeriesStatement deleteTimeSeriesStatement = new DeleteTimeSeriesStatement();
        ArrayList<PartialPath> partialPaths = new ArrayList<PartialPath>();
        for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
            partialPaths.add(this.parsePrefixPath(prefixPathContext));
        }
        deleteTimeSeriesStatement.setPartialPaths(partialPaths);
        return deleteTimeSeriesStatement;
    }

    public Statement visitShowTimeseries(IoTDBSqlParser.ShowTimeseriesContext ctx) {
        boolean orderByHeat = ctx.LATEST() != null;
        ShowTimeSeriesStatement showTimeSeriesStatement = ctx.prefixPath() != null ? new ShowTimeSeriesStatement(this.parsePrefixPath(ctx.prefixPath()), orderByHeat) : new ShowTimeSeriesStatement(new PartialPath(SQLConstant.getSingleRootArray()), orderByHeat);
        if (ctx.tagWhereClause() != null) {
            this.parseTagWhereClause(ctx.tagWhereClause(), showTimeSeriesStatement);
        }
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), showTimeSeriesStatement);
        }
        return showTimeSeriesStatement;
    }

    private void parseTagWhereClause(IoTDBSqlParser.TagWhereClauseContext ctx, Statement statement) {
        String key;
        IoTDBSqlParser.AttributeValueContext attributeValueContext;
        boolean isContains;
        if (ctx.containsExpression() != null) {
            isContains = true;
            attributeValueContext = ctx.containsExpression().attributeValue();
            key = this.parseAttributeKey(ctx.containsExpression().attributeKey());
        } else {
            isContains = false;
            attributeValueContext = ctx.attributePair().attributeValue();
            key = this.parseAttributeKey(ctx.attributePair().attributeKey());
        }
        String value = this.parseAttributeValue(attributeValueContext);
        if (statement instanceof ShowTimeSeriesStatement) {
            ((ShowTimeSeriesStatement)statement).setContains(isContains);
            ((ShowTimeSeriesStatement)statement).setKey(key);
            ((ShowTimeSeriesStatement)statement).setValue(value);
        } else if (statement instanceof CountTimeSeriesStatement) {
            ((CountTimeSeriesStatement)statement).setContains(isContains);
            ((CountTimeSeriesStatement)statement).setKey(key);
            ((CountTimeSeriesStatement)statement).setValue(value);
        } else if (statement instanceof CountLevelTimeSeriesStatement) {
            ((CountLevelTimeSeriesStatement)statement).setContains(isContains);
            ((CountLevelTimeSeriesStatement)statement).setKey(key);
            ((CountLevelTimeSeriesStatement)statement).setValue(value);
        }
    }

    public Statement visitShowStorageGroup(IoTDBSqlParser.ShowStorageGroupContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowStorageGroupStatement(this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowStorageGroupStatement(new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Statement visitShowDevices(IoTDBSqlParser.ShowDevicesContext ctx) {
        ShowDevicesStatement showDevicesStatement = ctx.prefixPath() != null ? new ShowDevicesStatement(this.parsePrefixPath(ctx.prefixPath())) : new ShowDevicesStatement(new PartialPath(SQLConstant.getSingleRootArray()));
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), showDevicesStatement);
        }
        if (ctx.WITH() != null) {
            showDevicesStatement.setSgCol(true);
        }
        return showDevicesStatement;
    }

    public Statement visitCountDevices(IoTDBSqlParser.CountDevicesContext ctx) {
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountDevicesStatement(path);
    }

    public Statement visitCountTimeseries(IoTDBSqlParser.CountTimeseriesContext ctx) {
        CountStatement statement;
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SQLConstant.getSingleRootArray());
        if (ctx.INTEGER_LITERAL() != null) {
            int level = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
            statement = new CountLevelTimeSeriesStatement(path, level);
        } else {
            statement = new CountTimeSeriesStatement(path);
        }
        if (ctx.tagWhereClause() != null) {
            this.parseTagWhereClause(ctx.tagWhereClause(), statement);
        }
        return statement;
    }

    public Statement visitCountNodes(IoTDBSqlParser.CountNodesContext ctx) {
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SQLConstant.getSingleRootArray());
        int level = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        return new CountNodesStatement(path, level);
    }

    public Statement visitCountStorageGroup(IoTDBSqlParser.CountStorageGroupContext ctx) {
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountStorageGroupStatement(path);
    }

    public Statement visitShowVersion(IoTDBSqlParser.ShowVersionContext ctx) {
        return new ShowVersionStatement();
    }

    public Statement visitCreateFunction(IoTDBSqlParser.CreateFunctionContext ctx) {
        return new CreateFunctionStatement(this.parseIdentifier(ctx.udfName.getText()), this.parseStringLiteral(ctx.className.getText()), this.parseUris(ctx.uri()));
    }

    private List<URI> parseUris(List<IoTDBSqlParser.UriContext> uriContexts) {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (uriContexts != null) {
            for (IoTDBSqlParser.UriContext uriContext : uriContexts) {
                String uriString = uriContext.getText();
                try {
                    uris.add(new URI(this.parseStringLiteral(uriString)));
                }
                catch (URISyntaxException e) {
                    throw new SemanticException(String.format("'%s' is not a legal URI.", uriString));
                }
            }
        }
        return uris;
    }

    public Statement visitDropFunction(IoTDBSqlParser.DropFunctionContext ctx) {
        return new DropFunctionStatement(this.parseIdentifier(ctx.udfName.getText()));
    }

    public Statement visitShowFunctions(IoTDBSqlParser.ShowFunctionsContext ctx) {
        return new ShowFunctionsStatement();
    }

    public Statement visitCreateTrigger(IoTDBSqlParser.CreateTriggerContext ctx) {
        String jarPath;
        boolean usingURI;
        if (ctx.triggerEventClause().DELETE() != null) {
            throw new SemanticException("Trigger does not support DELETE as TRIGGER_EVENT for now.");
        }
        if (ctx.triggerType() == null) {
            throw new SemanticException("Please specify trigger type: STATELESS or STATEFUL.");
        }
        if (ctx.jarLocation() == null) {
            throw new SemanticException("Please specify the location of jar.");
        }
        if (ctx.jarLocation().FILE() != null) {
            usingURI = false;
            jarPath = this.parseFilePath(ctx.jarLocation().fileName.getText());
        } else {
            usingURI = true;
            jarPath = this.parseFilePath(ctx.jarLocation().uri().getText());
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (ctx.triggerAttributeClause() != null) {
            for (IoTDBSqlParser.TriggerAttributeContext triggerAttributeContext : ctx.triggerAttributeClause().triggerAttribute()) {
                attributes.put(this.parseAttributeKey(triggerAttributeContext.key), this.parseAttributeValue(triggerAttributeContext.value));
            }
        }
        return new CreateTriggerStatement(this.parseIdentifier(ctx.triggerName.getText()), this.parseStringLiteral(ctx.className.getText()), jarPath, usingURI, ctx.triggerEventClause().BEFORE() != null ? TriggerEvent.BEFORE_INSERT : TriggerEvent.AFTER_INSERT, ctx.triggerType().STATELESS() != null ? TriggerType.STATELESS : TriggerType.STATEFUL, this.parsePrefixPath(ctx.prefixPath()), attributes);
    }

    public Statement visitDropTrigger(IoTDBSqlParser.DropTriggerContext ctx) {
        return new DropTriggerStatement(this.parseIdentifier(ctx.triggerName.getText()));
    }

    public Statement visitShowChildPaths(IoTDBSqlParser.ShowChildPathsContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowChildPathsStatement(this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowChildPathsStatement(new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Statement visitShowChildNodes(IoTDBSqlParser.ShowChildNodesContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowChildNodesStatement(this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowChildNodesStatement(new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Statement visitSelectStatement(IoTDBSqlParser.SelectStatementContext ctx) {
        if (ctx.intoClause() != null) {
            throw new SemanticException("The SELECT-INTO statement is not supported in the current version.");
        }
        this.queryStatement = new QueryStatement();
        this.parseSelectClause(ctx.selectClause());
        this.parseFromClause(ctx.fromClause());
        if (ctx.whereClause() != null) {
            WhereCondition whereCondition = this.parseWhereClause(ctx.whereClause());
            this.queryStatement.setWhereCondition(whereCondition);
        }
        if (ctx.specialClause() != null) {
            this.queryStatement = (QueryStatement)this.visit((ParseTree)ctx.specialClause());
        }
        return this.queryStatement;
    }

    public void parseSelectClause(IoTDBSqlParser.SelectClauseContext ctx) {
        SelectComponent selectComponent = new SelectComponent(this.zoneId);
        if (ctx.LAST() != null) {
            selectComponent.setHasLast(true);
        }
        HashMap<String, Expression> aliasToColumnMap = new HashMap<String, Expression>();
        for (IoTDBSqlParser.ResultColumnContext resultColumnContext : ctx.resultColumn()) {
            ResultColumn resultColumn = this.parseResultColumn(resultColumnContext);
            if (resultColumn.hasAlias()) {
                String alias = resultColumn.getAlias();
                if (aliasToColumnMap.containsKey(alias)) {
                    throw new SemanticException("duplicate alias in select clause");
                }
                aliasToColumnMap.put(alias, resultColumn.getExpression());
            }
            selectComponent.addResultColumn(resultColumn);
        }
        selectComponent.setAliasToColumnMap(aliasToColumnMap);
        this.queryStatement.setSelectComponent(selectComponent);
    }

    private ResultColumn parseResultColumn(IoTDBSqlParser.ResultColumnContext resultColumnContext) {
        Expression expression = this.parseExpression(resultColumnContext.expression(), false);
        if (expression.isConstantOperand()) {
            throw new SemanticException("Constant operand is not allowed: " + expression);
        }
        String alias = null;
        if (resultColumnContext.AS() != null) {
            alias = this.parseAlias(resultColumnContext.alias());
        }
        ResultColumn.ColumnType columnType = ExpressionAnalyzer.identifyOutputColumnType(expression, true);
        return new ResultColumn(expression, alias, columnType);
    }

    public void parseFromClause(IoTDBSqlParser.FromClauseContext ctx) {
        FromComponent fromComponent = new FromComponent();
        List prefixFromPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixFromPath : prefixFromPaths) {
            PartialPath path = this.parsePrefixPath(prefixFromPath);
            fromComponent.addPrefixPath(path);
        }
        this.queryStatement.setFromComponent(fromComponent);
    }

    public WhereCondition parseWhereClause(IoTDBSqlParser.WhereClauseContext ctx) {
        Expression predicate = this.parseExpression(ctx.expression(), ctx.expression().OPERATOR_NOT() == null);
        return new WhereCondition(predicate);
    }

    public Statement visitGroupByTimeStatement(IoTDBSqlParser.GroupByTimeStatementContext ctx) {
        this.parseGroupByTimeClause(ctx.groupByTimeClause());
        if (ctx.orderByClause() != null) {
            this.parseOrderByClause(ctx.orderByClause());
        }
        if (ctx.havingClause() != null) {
            this.parseHavingClause(ctx.havingClause());
        }
        if (ctx.specialLimit() != null) {
            return (Statement)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryStatement;
    }

    public Statement visitGroupByFillStatement(IoTDBSqlParser.GroupByFillStatementContext ctx) {
        this.parseGroupByTimeClause(ctx.groupByFillClause());
        if (ctx.orderByClause() != null) {
            this.parseOrderByClause(ctx.orderByClause());
        }
        if (ctx.havingClause() != null) {
            this.parseHavingClause(ctx.havingClause());
        }
        if (ctx.specialLimit() != null) {
            return (Statement)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryStatement;
    }

    private void parseGroupByTimeClause(IoTDBSqlParser.GroupByTimeClauseContext ctx) {
        GroupByTimeComponent groupByTimeComponent = new GroupByTimeComponent();
        this.parseTimeRange(ctx.timeRange(), groupByTimeComponent);
        groupByTimeComponent.setLeftCRightO(ctx.timeRange().LS_BRACKET() != null);
        groupByTimeComponent.setInterval(this.parseTimeIntervalOrSlidingStep(ctx.DURATION_LITERAL(0).getText(), true, groupByTimeComponent));
        if (groupByTimeComponent.getInterval() <= 0L) {
            throw new SemanticException("The second parameter time interval should be a positive integer.");
        }
        if (ctx.DURATION_LITERAL().size() == 2) {
            groupByTimeComponent.setSlidingStep(this.parseTimeIntervalOrSlidingStep(ctx.DURATION_LITERAL(1).getText(), false, groupByTimeComponent));
        } else {
            groupByTimeComponent.setSlidingStep(groupByTimeComponent.getInterval());
            groupByTimeComponent.setSlidingStepByMonth(groupByTimeComponent.isIntervalByMonth());
        }
        if (ctx.LEVEL() != null && ctx.INTEGER_LITERAL() != null) {
            GroupByLevelComponent groupByLevelComponent = new GroupByLevelComponent();
            int[] levels = new int[ctx.INTEGER_LITERAL().size()];
            for (int i = 0; i < ctx.INTEGER_LITERAL().size(); ++i) {
                levels[i] = Integer.parseInt(((TerminalNode)ctx.INTEGER_LITERAL().get(i)).getText());
            }
            groupByLevelComponent.setLevels(levels);
            this.queryStatement.setGroupByLevelComponent(groupByLevelComponent);
        }
        if (ctx.fillClause() != null) {
            this.parseFillClause(ctx.fillClause());
        }
        this.queryStatement.setGroupByTimeComponent(groupByTimeComponent);
    }

    private void parseGroupByTimeClause(IoTDBSqlParser.GroupByFillClauseContext ctx) {
        GroupByTimeComponent groupByTimeComponent = new GroupByTimeComponent();
        this.parseTimeRange(ctx.timeRange(), groupByTimeComponent);
        groupByTimeComponent.setLeftCRightO(ctx.timeRange().LS_BRACKET() != null);
        groupByTimeComponent.setInterval(this.parseTimeIntervalOrSlidingStep(ctx.DURATION_LITERAL(0).getText(), true, groupByTimeComponent));
        if (groupByTimeComponent.getInterval() <= 0L) {
            throw new SemanticException("The second parameter time interval should be a positive integer.");
        }
        if (ctx.DURATION_LITERAL().size() == 2) {
            groupByTimeComponent.setSlidingStep(this.parseTimeIntervalOrSlidingStep(ctx.DURATION_LITERAL(1).getText(), false, groupByTimeComponent));
        } else {
            groupByTimeComponent.setSlidingStep(groupByTimeComponent.getInterval());
            groupByTimeComponent.setSlidingStepByMonth(groupByTimeComponent.isIntervalByMonth());
        }
        if (ctx.fillClause() != null) {
            this.parseFillClause(ctx.fillClause());
        }
        this.queryStatement.setGroupByTimeComponent(groupByTimeComponent);
    }

    private void parseTimeRange(IoTDBSqlParser.TimeRangeContext timeRange, GroupByTimeComponent groupByClauseComponent) {
        long currentTime = DatetimeUtils.currentTime();
        long startTime = this.parseTimeValue(timeRange.timeValue(0), currentTime);
        long endTime = this.parseTimeValue(timeRange.timeValue(1), currentTime);
        groupByClauseComponent.setStartTime(startTime);
        groupByClauseComponent.setEndTime(endTime);
        if (startTime >= endTime) {
            throw new SemanticException("Start time should be smaller than endTime in GroupBy");
        }
    }

    private long parseTimeIntervalOrSlidingStep(String duration, boolean isParsingTimeInterval, GroupByTimeComponent groupByTimeComponent) {
        if (duration.toLowerCase().contains("mo")) {
            if (isParsingTimeInterval) {
                groupByTimeComponent.setIntervalByMonth(true);
            } else {
                groupByTimeComponent.setSlidingStepByMonth(true);
            }
        }
        return DatetimeUtils.convertDurationStrToLong(duration);
    }

    public Statement visitGroupByLevelStatement(IoTDBSqlParser.GroupByLevelStatementContext ctx) {
        this.parseGroupByLevelClause(ctx.groupByLevelClause());
        if (ctx.orderByClause() != null) {
            this.parseOrderByClause(ctx.orderByClause());
        }
        if (ctx.havingClause() != null) {
            this.parseHavingClause(ctx.havingClause());
        }
        if (ctx.specialLimit() != null) {
            return (Statement)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryStatement;
    }

    public void parseGroupByLevelClause(IoTDBSqlParser.GroupByLevelClauseContext ctx) {
        GroupByLevelComponent groupByLevelComponent = new GroupByLevelComponent();
        int[] levels = new int[ctx.INTEGER_LITERAL().size()];
        for (int i = 0; i < ctx.INTEGER_LITERAL().size(); ++i) {
            levels[i] = Integer.parseInt(((TerminalNode)ctx.INTEGER_LITERAL().get(i)).getText());
        }
        groupByLevelComponent.setLevels(levels);
        if (ctx.fillClause() != null) {
            this.parseFillClause(ctx.fillClause());
        }
        this.queryStatement.setGroupByLevelComponent(groupByLevelComponent);
    }

    public void parseHavingClause(IoTDBSqlParser.HavingClauseContext ctx) {
        Expression predicate = this.parseExpression(ctx.expression(), ctx.expression().OPERATOR_NOT() == null);
        this.queryStatement.setHavingCondition(new HavingCondition(predicate));
    }

    public Statement visitFillStatement(IoTDBSqlParser.FillStatementContext ctx) {
        this.parseFillClause(ctx.fillClause());
        if (ctx.orderByClause() != null) {
            this.parseOrderByClause(ctx.orderByClause());
        }
        if (ctx.specialLimit() != null) {
            return (Statement)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseFillClause(IoTDBSqlParser.FillClauseContext ctx) {
        FillComponent fillComponent = new FillComponent();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION_LITERAL().size() > 0) {
                throw new SemanticException("The specified fill time range is not supported.");
            }
            fillComponent.setFillPolicy(FillPolicy.LINEAR);
        } else if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION_LITERAL() != null) {
                throw new SemanticException("The specified fill time range is not supported.");
            }
            fillComponent.setFillPolicy(FillPolicy.PREVIOUS);
        } else if (ctx.specificValueClause() != null) {
            fillComponent.setFillPolicy(FillPolicy.VALUE);
            if (ctx.specificValueClause().constant() == null) throw new SemanticException("fill value cannot be null");
            Literal fillValue = this.parseLiteral(ctx.specificValueClause().constant());
            fillComponent.setFillValue(fillValue);
        } else {
            if (ctx.previousUntilLastClause() != null) {
                throw new SemanticException("PREVIOUSUNTILLAST fill is not supported yet.");
            }
            if (ctx.oldTypeClause() != null) {
                throw new SemanticException("The specified fill datatype is not supported.");
            }
        }
        this.queryStatement.setFillComponent(fillComponent);
    }

    private Literal parseLiteral(IoTDBSqlParser.ConstantContext constantContext) {
        String text = constantContext.getText();
        if (constantContext.BOOLEAN_LITERAL() != null) {
            return new BooleanLiteral(text);
        }
        if (constantContext.STRING_LITERAL() != null) {
            return new StringLiteral(this.parseStringLiteral(text));
        }
        if (constantContext.INTEGER_LITERAL() != null) {
            return new LongLiteral(text);
        }
        if (constantContext.realLiteral() != null) {
            return new DoubleLiteral(text);
        }
        if (constantContext.dateExpression() != null) {
            return new LongLiteral(this.parseDateExpression(constantContext.dateExpression()));
        }
        throw new SQLParserException("Unsupported constant operand: " + text);
    }

    public Statement visitSpecialLimitStatement(IoTDBSqlParser.SpecialLimitStatementContext ctx) {
        return (Statement)this.visit((ParseTree)ctx.specialLimit());
    }

    public Statement visitLimitStatement(IoTDBSqlParser.LimitStatementContext ctx) {
        this.parseLimitClause(ctx.limitClause(), this.queryStatement);
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause());
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryStatement;
    }

    private void parseLimitClause(IoTDBSqlParser.LimitClauseContext ctx, Statement statement) {
        int limit;
        try {
            limit = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SemanticException("Out of range. LIMIT <N>: N should be Int32.");
        }
        if (limit <= 0) {
            throw new SemanticException("LIMIT <N>: N should be greater than 0.");
        }
        if (statement instanceof ShowTimeSeriesStatement) {
            ((ShowTimeSeriesStatement)statement).setLimit(limit);
        } else if (statement instanceof ShowDevicesStatement) {
            ((ShowDevicesStatement)statement).setLimit(limit);
        } else {
            this.queryStatement.setRowLimit(limit);
        }
        if (ctx.offsetClause() != null) {
            this.parseOffsetClause(ctx.offsetClause(), statement);
        }
    }

    private void parseOffsetClause(IoTDBSqlParser.OffsetClauseContext ctx, Statement statement) {
        int offset;
        try {
            offset = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SemanticException("Out of range. OFFSET <OFFSETValue>: OFFSETValue should be Int32.");
        }
        if (offset < 0) {
            throw new SemanticException("OFFSET <OFFSETValue>: OFFSETValue should >= 0.");
        }
        if (statement instanceof ShowTimeSeriesStatement) {
            ((ShowTimeSeriesStatement)statement).setOffset(offset);
        } else if (statement instanceof ShowDevicesStatement) {
            ((ShowDevicesStatement)statement).setOffset(offset);
        } else {
            this.queryStatement.setRowOffset(offset);
        }
    }

    public Statement visitSlimitStatement(IoTDBSqlParser.SlimitStatementContext ctx) {
        this.parseSlimitClause(ctx.slimitClause());
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), this.queryStatement);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryStatement;
    }

    private void parseSlimitClause(IoTDBSqlParser.SlimitClauseContext ctx) {
        int slimit;
        try {
            slimit = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SemanticException("Out of range. SLIMIT <SN>: SN should be Int32.");
        }
        if (slimit <= 0) {
            throw new SemanticException("SLIMIT <SN>: SN should be greater than 0.");
        }
        this.queryStatement.setSeriesLimit(slimit);
        if (ctx.soffsetClause() != null) {
            this.parseSoffsetClause(ctx.soffsetClause());
        }
    }

    public void parseSoffsetClause(IoTDBSqlParser.SoffsetClauseContext ctx) {
        int soffset;
        try {
            soffset = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SemanticException("Out of range. SOFFSET <SOFFSETValue>: SOFFSETValue should be Int32.");
        }
        if (soffset < 0) {
            throw new SemanticException("SOFFSET <SOFFSETValue>: SOFFSETValue should >= 0.");
        }
        this.queryStatement.setSeriesOffset(soffset);
    }

    public Statement visitWithoutNullStatement(IoTDBSqlParser.WithoutNullStatementContext ctx) {
        this.parseWithoutNullClause(ctx.withoutNullClause());
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), this.queryStatement);
        }
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause());
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryStatement;
    }

    private void parseWithoutNullClause(IoTDBSqlParser.WithoutNullClauseContext ctx) {
        throw new SemanticException("WITHOUT NULL clause is not supported yet.");
    }

    public Statement visitOrderByTimeStatement(IoTDBSqlParser.OrderByTimeStatementContext ctx) {
        this.parseOrderByClause(ctx.orderByClause());
        if (ctx.specialLimit() != null) {
            return (Statement)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryStatement;
    }

    private void parseOrderByClause(IoTDBSqlParser.OrderByClauseContext ctx) {
        OrderByComponent orderByComponent = new OrderByComponent();
        HashSet<SortKey> sortKeySet = new HashSet<SortKey>();
        for (IoTDBSqlParser.OrderByAttributeClauseContext orderByAttributeClauseContext : ctx.orderByAttributeClause()) {
            SortItem sortItem = this.parseOrderByAttributeClause(orderByAttributeClauseContext);
            SortKey sortKey = sortItem.getSortKey();
            if (sortKeySet.contains((Object)sortKey)) {
                throw new SemanticException(String.format("ORDER BY: duplicate sort key '%s'", new Object[]{sortKey}));
            }
            sortKeySet.add(sortKey);
            orderByComponent.addSortItem(sortItem);
        }
        this.queryStatement.setOrderByComponent(orderByComponent);
    }

    private SortItem parseOrderByAttributeClause(IoTDBSqlParser.OrderByAttributeClauseContext ctx) {
        return new SortItem(SortKey.valueOf(ctx.sortKey().getText().toUpperCase()), ctx.DESC() != null ? Ordering.DESC : Ordering.ASC);
    }

    public Statement visitAlignByDeviceClauseOrDisableAlignStatement(IoTDBSqlParser.AlignByDeviceClauseOrDisableAlignStatementContext ctx) {
        this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        return this.queryStatement;
    }

    private void parseAlignByDeviceClauseOrDisableAlign(IoTDBSqlParser.AlignByDeviceClauseOrDisableAlignContext ctx) {
        if (ctx.alignByDeviceClause() != null) {
            this.queryStatement.setResultSetFormat(ResultSetFormat.ALIGN_BY_DEVICE);
        } else {
            this.queryStatement.setResultSetFormat(ResultSetFormat.DISABLE_ALIGN);
        }
    }

    public Statement visitInsertStatement(IoTDBSqlParser.InsertStatementContext ctx) {
        InsertStatement insertStatement = new InsertStatement();
        insertStatement.setDevice(this.parsePrefixPath(ctx.prefixPath()));
        boolean isTimeDefault = this.parseInsertColumnSpec(ctx.insertColumnsSpec(), insertStatement);
        this.parseInsertValuesSpec(ctx.insertValuesSpec(), insertStatement, isTimeDefault);
        insertStatement.setAligned(ctx.ALIGNED() != null);
        return insertStatement;
    }

    private boolean parseInsertColumnSpec(IoTDBSqlParser.InsertColumnsSpecContext ctx, InsertStatement insertStatement) {
        ArrayList<String> measurementList = new ArrayList<String>();
        for (IoTDBSqlParser.NodeNameWithoutWildcardContext measurementName : ctx.nodeNameWithoutWildcard()) {
            measurementList.add(this.parseNodeNameWithoutWildCard(measurementName));
        }
        insertStatement.setMeasurementList(measurementList.toArray(new String[0]));
        return ctx.TIME() == null && ctx.TIMESTAMP() == null;
    }

    private void parseInsertValuesSpec(IoTDBSqlParser.InsertValuesSpecContext ctx, InsertStatement insertStatement, boolean isTimeDefault) {
        List insertMultiValues = ctx.insertMultiValue();
        ArrayList<String[]> valuesList = new ArrayList<String[]>();
        long[] timeArray = new long[insertMultiValues.size()];
        for (int i = 0; i < insertMultiValues.size(); ++i) {
            long timestamp;
            ArrayList<String> valueList = new ArrayList<String>();
            if (((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue() != null) {
                if (isTimeDefault) {
                    if (insertMultiValues.size() != 1) {
                        throw new SemanticException("need timestamps when insert multi rows");
                    }
                    valueList.add(((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue().getText());
                    timestamp = DatetimeUtils.currentTime();
                } else {
                    timestamp = this.parseTimeValue(((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue(), DatetimeUtils.currentTime());
                }
            } else {
                if (!isTimeDefault) {
                    throw new SemanticException("the measurementList's size is not consistent with the valueList's size");
                }
                if (insertMultiValues.size() != 1) {
                    throw new SemanticException("need timestamps when insert multi rows");
                }
                timestamp = this.parseDateFormat("now()");
            }
            timeArray[i] = timestamp;
            List values = ((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).measurementValue();
            for (IoTDBSqlParser.MeasurementValueContext value : values) {
                for (IoTDBSqlParser.ConstantContext constant : value.constant()) {
                    if (constant.STRING_LITERAL() != null) {
                        valueList.add(this.parseStringLiteralInInsertValue(constant.getText()));
                        continue;
                    }
                    valueList.add(constant.getText());
                }
            }
            valuesList.add(valueList.toArray(new String[0]));
        }
        insertStatement.setTimes(timeArray);
        insertStatement.setValuesList(valuesList);
    }

    private PartialPath parseFullPath(IoTDBSqlParser.FullPathContext ctx) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutWildcard();
        String[] path = new String[nodeNamesWithoutStar.size() + 1];
        int i = 0;
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
        }
        for (IoTDBSqlParser.NodeNameWithoutWildcardContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            path[++i] = this.parseNodeNameWithoutWildCard(nodeNameWithoutStar);
        }
        return new PartialPath(path);
    }

    private PartialPath parseFullPathInExpression(IoTDBSqlParser.FullPathInExpressionContext ctx, boolean inWithoutNull) throws SQLParserException {
        List nodeNames = ctx.nodeName();
        int size = nodeNames.size();
        if (ctx.ROOT() != null) {
            if (!inWithoutNull) {
                throw new SQLParserException("Path can not start with root in select clause.");
            }
            ++size;
        }
        String[] path = new String[size];
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
            for (int i = 0; i < nodeNames.size(); ++i) {
                path[i + 1] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
            }
        } else {
            for (int i = 0; i < nodeNames.size(); ++i) {
                path[i] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
            }
        }
        return new PartialPath(path);
    }

    private PartialPath parsePrefixPath(IoTDBSqlParser.PrefixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
        }
        return new PartialPath(path);
    }

    private PartialPath parseSuffixPath(IoTDBSqlParser.SuffixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size()];
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
        }
        return new PartialPath(path);
    }

    private PartialPath convertConstantToPath(String src) throws IllegalPathException {
        return new PartialPath(src);
    }

    private String parseNodeName(IoTDBSqlParser.NodeNameContext ctx) {
        return this.parseNodeString(ctx.getText());
    }

    private String parseNodeNameWithoutWildCard(IoTDBSqlParser.NodeNameWithoutWildcardContext ctx) {
        return this.parseNodeString(ctx.getText());
    }

    private String parseNodeString(String nodeName) {
        if (nodeName.equals("*") || nodeName.equals("**")) {
            return nodeName;
        }
        if (nodeName.startsWith("`") && nodeName.endsWith("`")) {
            String unWrapped = nodeName.substring(1, nodeName.length() - 1);
            if (PathUtils.isRealNumber((String)unWrapped) || !TsFileConstant.IDENTIFIER_PATTERN.matcher(unWrapped).matches()) {
                return nodeName;
            }
            return unWrapped;
        }
        this.checkNodeName(nodeName);
        return nodeName;
    }

    private void checkNodeName(String src) {
        if (!TsFileConstant.NODE_NAME_PATTERN.matcher(src).matches()) {
            throw new SQLParserException(String.format("%s is illegal, unquoted node name can only consist of digits, characters and underscore, or start or end with wildcard", src));
        }
    }

    private void checkIdentifier(String src) {
        if (!TsFileConstant.IDENTIFIER_PATTERN.matcher(src).matches()) {
            throw new SQLParserException(String.format("%s is illegal, unquoted identifier can only consist of digits, characters and underscore", src));
        }
    }

    public long parseDateFormat(String timestampStr) throws SQLParserException {
        if (timestampStr == null || "".equals(timestampStr.trim())) {
            throw new SemanticException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return DatetimeUtils.currentTime();
        }
        try {
            return DatetimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    public long parseDateFormat(String timestampStr, long currentTime) throws SQLParserException {
        if (timestampStr == null || "".equals(timestampStr.trim())) {
            throw new SemanticException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return currentTime;
        }
        try {
            return DatetimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    private String parseStringLiteral(String src) {
        if (2 <= src.length()) {
            String unWrappedString = src.substring(1, src.length() - 1).replace("\\\"", "\"").replace("\\'", "'");
            if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
                String replaced = unWrappedString.replace("\"\"", "\"");
                return replaced.length() == 0 ? "" : replaced;
            }
            if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
                String replaced = unWrappedString.replace("''", "'");
                return replaced.length() == 0 ? "" : replaced;
            }
        }
        return src;
    }

    private String parseStringLiteralInInsertValue(String src) {
        if (2 <= src.length() && (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"' || src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'')) {
            return "'" + this.parseStringLiteral(src) + "'";
        }
        return src;
    }

    private String parseStringLiteralInLikeOrRegular(String src) {
        if (2 <= src.length()) {
            String unescapeString = StringEscapeUtils.unescapeJava((String)src.substring(1, src.length() - 1));
            if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
                String replaced = unescapeString.replace("\"\"", "\"");
                return replaced.length() == 0 ? "" : replaced;
            }
            if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
                String replaced = unescapeString.replace("''", "'");
                return replaced.length() == 0 ? "" : replaced;
            }
        }
        return src;
    }

    private String parseIdentifier(String src) {
        if (src.startsWith("`") && src.endsWith("`")) {
            return src.substring(1, src.length() - 1).replace("``", "`");
        }
        this.checkIdentifier(src);
        return src;
    }

    private String parseAlias(IoTDBSqlParser.AliasContext ctx) {
        String alias = ctx.constant() != null ? this.parseStringLiteral(ctx.constant().getText()) : this.parseIdentifier(ctx.identifier().getText());
        return alias;
    }

    public Statement visitCreateUser(IoTDBSqlParser.CreateUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.CREATE_USER);
        authorStatement.setUserName(this.parseIdentifier(ctx.userName.getText()));
        authorStatement.setPassWord(this.parseStringLiteral(ctx.password.getText()));
        return authorStatement;
    }

    public Statement visitCreateRole(IoTDBSqlParser.CreateRoleContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.CREATE_ROLE);
        authorStatement.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        return authorStatement;
    }

    public Statement visitAlterUser(IoTDBSqlParser.AlterUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.UPDATE_USER);
        authorStatement.setUserName(this.parseIdentifier(ctx.userName.getText()));
        authorStatement.setNewPassword(this.parseStringLiteral(ctx.password.getText()));
        return authorStatement;
    }

    public Statement visitGrantUser(IoTDBSqlParser.GrantUserContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.GRANT_USER);
        authorStatement.setUserName(this.parseIdentifier(ctx.userName.getText()));
        authorStatement.setPrivilegeList(privileges);
        authorStatement.setNodeNameList(nodeNameList);
        return authorStatement;
    }

    public Statement visitGrantRole(IoTDBSqlParser.GrantRoleContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.GRANT_ROLE);
        authorStatement.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        authorStatement.setPrivilegeList(privileges);
        authorStatement.setNodeNameList(nodeNameList);
        return authorStatement;
    }

    public Statement visitGrantRoleToUser(IoTDBSqlParser.GrantRoleToUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.GRANT_USER_ROLE);
        authorStatement.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        authorStatement.setUserName(this.parseIdentifier(ctx.userName.getText()));
        return authorStatement;
    }

    public Statement visitRevokeUser(IoTDBSqlParser.RevokeUserContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.REVOKE_USER);
        authorStatement.setUserName(this.parseIdentifier(ctx.userName.getText()));
        authorStatement.setPrivilegeList(privileges);
        authorStatement.setNodeNameList(nodeNameList);
        return authorStatement;
    }

    public Statement visitRevokeRole(IoTDBSqlParser.RevokeRoleContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.REVOKE_ROLE);
        authorStatement.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        authorStatement.setPrivilegeList(privileges);
        authorStatement.setNodeNameList(nodeNameList);
        return authorStatement;
    }

    private void checkGrantRevokePrivileges(String[] privileges, List<PartialPath> nodeNameList) {
        if (nodeNameList.isEmpty()) {
            nodeNameList.addAll(Collections.singletonList(new PartialPath(MetadataConstant.ALL_RESULT_NODES)));
            return;
        }
        boolean pathRelevant = true;
        String errorPrivilegeName = "";
        for (String privilege : privileges) {
            if (PrivilegeType.valueOf((String)privilege.toUpperCase()).isPathRelevant()) continue;
            pathRelevant = false;
            errorPrivilegeName = privilege.toUpperCase();
            break;
        }
        if (!(pathRelevant || nodeNameList.size() == 1 && nodeNameList.contains(new PartialPath(MetadataConstant.ALL_RESULT_NODES)))) {
            throw new SQLParserException(String.format("path independent privilege: [%s] can only be set on path: root.**", errorPrivilegeName));
        }
    }

    public Statement visitRevokeRoleFromUser(IoTDBSqlParser.RevokeRoleFromUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.REVOKE_USER_ROLE);
        authorStatement.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        authorStatement.setUserName(this.parseIdentifier(ctx.userName.getText()));
        return authorStatement;
    }

    public Statement visitDropUser(IoTDBSqlParser.DropUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.DROP_USER);
        authorStatement.setUserName(this.parseIdentifier(ctx.userName.getText()));
        return authorStatement;
    }

    public Statement visitDropRole(IoTDBSqlParser.DropRoleContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.DROP_ROLE);
        authorStatement.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        return authorStatement;
    }

    public Statement visitListUser(IoTDBSqlParser.ListUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.LIST_USER);
        if (ctx.roleName != null) {
            authorStatement.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        }
        return authorStatement;
    }

    public Statement visitListRole(IoTDBSqlParser.ListRoleContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.LIST_ROLE);
        if (ctx.userName != null) {
            authorStatement.setUserName(this.parseIdentifier(ctx.userName.getText()));
        }
        return authorStatement;
    }

    public Statement visitListPrivilegesUser(IoTDBSqlParser.ListPrivilegesUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        authorStatement.setUserName(this.parseIdentifier(ctx.userName.getText()));
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).collect(Collectors.toList());
        authorStatement.setNodeNameList(nodeNameList);
        return authorStatement;
    }

    public Statement visitListPrivilegesRole(IoTDBSqlParser.ListPrivilegesRoleContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        authorStatement.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).collect(Collectors.toList());
        authorStatement.setNodeNameList(nodeNameList);
        return authorStatement;
    }

    private String[] parsePrivilege(IoTDBSqlParser.PrivilegesContext ctx) {
        List privilegeList = ctx.privilegeValue();
        ArrayList<String> privileges = new ArrayList<String>();
        for (IoTDBSqlParser.PrivilegeValueContext privilegeValue : privilegeList) {
            privileges.add(privilegeValue.getText());
        }
        return privileges.toArray(new String[0]);
    }

    public Statement visitSetStorageGroup(IoTDBSqlParser.SetStorageGroupContext ctx) {
        SetStorageGroupStatement setStorageGroupStatement = new SetStorageGroupStatement();
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        setStorageGroupStatement.setStorageGroupPath(path);
        if (ctx.storageGroupAttributesClause() != null) {
            this.parseStorageGroupAttributesClause(setStorageGroupStatement, ctx.storageGroupAttributesClause());
        }
        return setStorageGroupStatement;
    }

    public Statement visitCreateStorageGroup(IoTDBSqlParser.CreateStorageGroupContext ctx) {
        SetStorageGroupStatement setStorageGroupStatement = new SetStorageGroupStatement();
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        setStorageGroupStatement.setStorageGroupPath(path);
        if (ctx.storageGroupAttributesClause() != null) {
            this.parseStorageGroupAttributesClause(setStorageGroupStatement, ctx.storageGroupAttributesClause());
        }
        return setStorageGroupStatement;
    }

    private void parseStorageGroupAttributesClause(SetStorageGroupStatement setStorageGroupStatement, IoTDBSqlParser.StorageGroupAttributesClauseContext ctx) {
        if (ctx.storageGroupAttributeClause().size() != 0) {
            throw new RuntimeException("Currently not support set ttl, schemaReplication factor, dataReplication factor, time partition interval to specific storage group.");
        }
        for (IoTDBSqlParser.StorageGroupAttributeClauseContext attribute : ctx.storageGroupAttributeClause()) {
            if (attribute.TTL() != null) {
                long ttl = Long.parseLong(attribute.INTEGER_LITERAL().getText());
                setStorageGroupStatement.setTtl(ttl);
                continue;
            }
            if (attribute.SCHEMA_REPLICATION_FACTOR() != null) {
                int schemaReplicationFactor = Integer.parseInt(attribute.INTEGER_LITERAL().getText());
                setStorageGroupStatement.setSchemaReplicationFactor(schemaReplicationFactor);
                continue;
            }
            if (attribute.DATA_REPLICATION_FACTOR() != null) {
                int dataReplicationFactor = Integer.parseInt(attribute.INTEGER_LITERAL().getText());
                setStorageGroupStatement.setDataReplicationFactor(dataReplicationFactor);
                continue;
            }
            if (attribute.TIME_PARTITION_INTERVAL() == null) continue;
            long timePartitionInterval = Long.parseLong(attribute.INTEGER_LITERAL().getText());
            setStorageGroupStatement.setTimePartitionInterval(timePartitionInterval);
        }
    }

    public Statement visitSetTTL(IoTDBSqlParser.SetTTLContext ctx) {
        SetTTLStatement setTTLStatement = new SetTTLStatement();
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        long ttl = Long.parseLong(ctx.INTEGER_LITERAL().getText());
        setTTLStatement.setStorageGroupPath(path);
        setTTLStatement.setTTL(ttl);
        return setTTLStatement;
    }

    public Statement visitUnsetTTL(IoTDBSqlParser.UnsetTTLContext ctx) {
        UnSetTTLStatement unSetTTLStatement = new UnSetTTLStatement();
        PartialPath partialPath = this.parsePrefixPath(ctx.prefixPath());
        unSetTTLStatement.setStorageGroupPath(partialPath);
        return unSetTTLStatement;
    }

    public Statement visitShowTTL(IoTDBSqlParser.ShowTTLContext ctx) {
        ShowTTLStatement showTTLStatement = new ShowTTLStatement();
        for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
            PartialPath partialPath = this.parsePrefixPath(prefixPathContext);
            showTTLStatement.addPathPatterns(partialPath);
        }
        return showTTLStatement;
    }

    public Statement visitShowAllTTL(IoTDBSqlParser.ShowAllTTLContext ctx) {
        ShowTTLStatement showTTLStatement = new ShowTTLStatement();
        showTTLStatement.setAll(true);
        return showTTLStatement;
    }

    public Statement visitShowCluster(IoTDBSqlParser.ShowClusterContext ctx) {
        ShowClusterStatement showClusterStatement = new ShowClusterStatement();
        return showClusterStatement;
    }

    public Statement visitDeleteStorageGroup(IoTDBSqlParser.DeleteStorageGroupContext ctx) {
        DeleteStorageGroupStatement deleteStorageGroupStatement = new DeleteStorageGroupStatement();
        List prefixPathContexts = ctx.prefixPath();
        ArrayList<String> paths = new ArrayList<String>();
        for (IoTDBSqlParser.PrefixPathContext prefixPathContext : prefixPathContexts) {
            paths.add(this.parsePrefixPath(prefixPathContext).getFullPath());
        }
        deleteStorageGroupStatement.setPrefixPath(paths);
        return deleteStorageGroupStatement;
    }

    public Statement visitExplain(IoTDBSqlParser.ExplainContext ctx) {
        QueryStatement queryStatement = (QueryStatement)this.visitSelectStatement(ctx.selectStatement());
        return new ExplainStatement(queryStatement);
    }

    public Statement visitDeleteStatement(IoTDBSqlParser.DeleteStatementContext ctx) {
        DeleteDataStatement statement = new DeleteDataStatement();
        List prefixPaths = ctx.prefixPath();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPaths) {
            pathList.add(this.parsePrefixPath(prefixPath));
        }
        statement.setPathList(pathList);
        if (ctx.whereClause() != null) {
            WhereCondition whereCondition = this.parseWhereClause(ctx.whereClause());
            TimeRange timeRange = this.parseDeleteTimeRange(whereCondition.getPredicate());
            statement.setTimeRange(timeRange);
        } else {
            statement.setTimeRange(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }
        return statement;
    }

    private TimeRange parseDeleteTimeRange(Expression predicate) {
        if (predicate instanceof LogicAndExpression) {
            TimeRange leftTimeRange = this.parseDeleteTimeRange(((LogicAndExpression)predicate).getLeftExpression());
            TimeRange rightTimeRange = this.parseDeleteTimeRange(((LogicAndExpression)predicate).getRightExpression());
            return new TimeRange(Math.max(leftTimeRange.getMin(), rightTimeRange.getMin()), Math.min(leftTimeRange.getMax(), rightTimeRange.getMax()));
        }
        if (predicate instanceof CompareBinaryExpression) {
            if (((CompareBinaryExpression)predicate).getLeftExpression() instanceof TimestampOperand) {
                return this.parseTimeRange(predicate.getExpressionType(), ((CompareBinaryExpression)predicate).getLeftExpression(), ((CompareBinaryExpression)predicate).getRightExpression());
            }
            return this.parseTimeRange(predicate.getExpressionType(), ((CompareBinaryExpression)predicate).getRightExpression(), ((CompareBinaryExpression)predicate).getLeftExpression());
        }
        throw new SemanticException(DELETE_RANGE_ERROR_MSG);
    }

    private TimeRange parseTimeRange(ExpressionType expressionType, Expression timeExpression, Expression valueExpression) {
        if (!(timeExpression instanceof TimestampOperand) || !(valueExpression instanceof ConstantOperand)) {
            throw new SemanticException(DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG);
        }
        if (((ConstantOperand)valueExpression).getDataType() != TSDataType.INT64) {
            throw new SemanticException("The datatype of timestamp should be LONG.");
        }
        long time = Long.parseLong(((ConstantOperand)valueExpression).getValueString());
        switch (expressionType) {
            case LESS_THAN: {
                return new TimeRange(Long.MIN_VALUE, time - 1L);
            }
            case LESS_EQUAL: {
                return new TimeRange(Long.MIN_VALUE, time);
            }
            case GREATER_THAN: {
                return new TimeRange(time + 1L, Long.MAX_VALUE);
            }
            case GREATER_EQUAL: {
                return new TimeRange(time, Long.MAX_VALUE);
            }
            case EQUAL_TO: {
                return new TimeRange(time, time);
            }
        }
        throw new SemanticException(DELETE_RANGE_ERROR_MSG);
    }

    public String parseFilePath(String src) {
        return src.substring(1, src.length() - 1);
    }

    private Expression parseExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull) {
        if (context.unaryInBracket != null) {
            return this.parseExpression(context.unaryInBracket, inWithoutNull);
        }
        if (context.expressionAfterUnaryOperator != null) {
            if (context.MINUS() != null) {
                return new NegationExpression(this.parseExpression(context.expressionAfterUnaryOperator, inWithoutNull));
            }
            if (context.OPERATOR_NOT() != null) {
                return new LogicNotExpression(this.parseExpression(context.expressionAfterUnaryOperator, inWithoutNull));
            }
            return this.parseExpression(context.expressionAfterUnaryOperator, inWithoutNull);
        }
        if (context.leftExpression != null && context.rightExpression != null) {
            Expression leftExpression = this.parseExpression(context.leftExpression, inWithoutNull);
            Expression rightExpression = this.parseExpression(context.rightExpression, inWithoutNull);
            if (context.STAR() != null) {
                return new MultiplicationExpression(leftExpression, rightExpression);
            }
            if (context.DIV() != null) {
                return new DivisionExpression(leftExpression, rightExpression);
            }
            if (context.MOD() != null) {
                return new ModuloExpression(leftExpression, rightExpression);
            }
            if (context.PLUS() != null) {
                return new AdditionExpression(leftExpression, rightExpression);
            }
            if (context.MINUS() != null) {
                return new SubtractionExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_GT() != null) {
                return new GreaterThanExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_GTE() != null) {
                return new GreaterEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_LT() != null) {
                return new LessThanExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_LTE() != null) {
                return new LessEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_DEQ() != null || context.OPERATOR_SEQ() != null) {
                return new EqualToExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_NEQ() != null) {
                return new NonEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_AND() != null) {
                return new LogicAndExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_OR() != null) {
                return new LogicOrExpression(leftExpression, rightExpression);
            }
            throw new UnsupportedOperationException();
        }
        if (context.unaryBeforeRegularOrLikeExpression != null) {
            if (context.REGEXP() != null) {
                return this.parseRegularExpression(context, inWithoutNull);
            }
            if (context.LIKE() != null) {
                return this.parseLikeExpression(context, inWithoutNull);
            }
            throw new UnsupportedOperationException();
        }
        if (context.unaryBeforeIsNullExpression != null) {
            return this.parseIsNullExpression(context, inWithoutNull);
        }
        if (context.firstExpression != null && context.secondExpression != null && context.thirdExpression != null) {
            Expression firstExpression = this.parseExpression(context.firstExpression, inWithoutNull);
            Expression secondExpression = this.parseExpression(context.secondExpression, inWithoutNull);
            Expression thirdExpression = this.parseExpression(context.thirdExpression, inWithoutNull);
            if (context.OPERATOR_BETWEEN() != null) {
                return new BetweenExpression(firstExpression, secondExpression, thirdExpression, context.OPERATOR_NOT() != null);
            }
            throw new UnsupportedOperationException();
        }
        if (context.unaryBeforeInExpression != null) {
            return this.parseInExpression(context, inWithoutNull);
        }
        if (context.functionName() != null) {
            return this.parseFunctionExpression(context, inWithoutNull);
        }
        if (context.fullPathInExpression() != null) {
            return new TimeSeriesOperand(this.parseFullPathInExpression(context.fullPathInExpression(), inWithoutNull));
        }
        if (context.time != null) {
            return new TimestampOperand();
        }
        if (context.constant() != null && !context.constant().isEmpty()) {
            return this.parseConstantOperand(context.constant(0));
        }
        throw new UnsupportedOperationException();
    }

    private Expression parseFunctionExpression(IoTDBSqlParser.ExpressionContext functionClause, boolean inWithoutNull) {
        FunctionExpression functionExpression = new FunctionExpression(this.parseIdentifier(functionClause.functionName().getText()));
        boolean hasNonPureConstantSubExpression = false;
        for (IoTDBSqlParser.ExpressionContext expression : functionClause.expression()) {
            Expression subexpression = this.parseExpression(expression, inWithoutNull);
            if (!subexpression.isConstantOperand()) {
                hasNonPureConstantSubExpression = true;
            }
            if (subexpression instanceof EqualToExpression && ((EqualToExpression)subexpression).getLeftExpression().isConstantOperand() && ((EqualToExpression)subexpression).getRightExpression().isConstantOperand()) {
                functionExpression.addAttribute(((ConstantOperand)((EqualToExpression)subexpression).getLeftExpression()).getValueString(), ((ConstantOperand)((EqualToExpression)subexpression).getRightExpression()).getValueString());
                continue;
            }
            functionExpression.addExpression(subexpression);
        }
        if (!hasNonPureConstantSubExpression) {
            throw new SemanticException("Invalid function expression, all the arguments are constant operands: " + functionClause.getText());
        }
        return functionExpression;
    }

    private Expression parseRegularExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull) {
        return new RegularExpression(this.parseExpression(context.unaryBeforeRegularOrLikeExpression, inWithoutNull), this.parseStringLiteralInLikeOrRegular(context.STRING_LITERAL().getText()));
    }

    private Expression parseLikeExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull) {
        return new LikeExpression(this.parseExpression(context.unaryBeforeRegularOrLikeExpression, inWithoutNull), this.parseStringLiteralInLikeOrRegular(context.STRING_LITERAL().getText()));
    }

    private Expression parseIsNullExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull) {
        return new IsNullExpression(this.parseExpression(context.unaryBeforeIsNullExpression, inWithoutNull), context.OPERATOR_NOT() != null);
    }

    private Expression parseInExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull) {
        Expression childExpression = this.parseExpression(context.unaryBeforeInExpression, inWithoutNull);
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        for (IoTDBSqlParser.ConstantContext constantContext : context.constant()) {
            values.add(this.parseConstant(constantContext));
        }
        return new InExpression(childExpression, context.OPERATOR_NOT() != null, values);
    }

    private String parseConstant(IoTDBSqlParser.ConstantContext constantContext) {
        String text = constantContext.getText();
        if (constantContext.BOOLEAN_LITERAL() != null || constantContext.INTEGER_LITERAL() != null || constantContext.realLiteral() != null) {
            return text;
        }
        if (constantContext.STRING_LITERAL() != null) {
            return this.parseStringLiteral(text);
        }
        if (constantContext.dateExpression() != null) {
            return String.valueOf(this.parseDateExpression(constantContext.dateExpression()));
        }
        throw new IllegalArgumentException("Unsupported constant operand: " + text);
    }

    private Expression parseConstantOperand(IoTDBSqlParser.ConstantContext constantContext) {
        String text = constantContext.getText();
        if (constantContext.BOOLEAN_LITERAL() != null) {
            return new ConstantOperand(TSDataType.BOOLEAN, text);
        }
        if (constantContext.STRING_LITERAL() != null) {
            return new ConstantOperand(TSDataType.TEXT, this.parseStringLiteral(text));
        }
        if (constantContext.INTEGER_LITERAL() != null) {
            return new ConstantOperand(TSDataType.INT64, text);
        }
        if (constantContext.realLiteral() != null) {
            return this.parseRealLiteral(text);
        }
        if (constantContext.dateExpression() != null) {
            return new ConstantOperand(TSDataType.INT64, String.valueOf(this.parseDateExpression(constantContext.dateExpression())));
        }
        throw new SQLParserException("Unsupported constant operand: " + text);
    }

    private Expression parseRealLiteral(String value) {
        return new ConstantOperand(CONFIG.getFloatingStringInferType().equals((Object)TSDataType.DOUBLE) ? TSDataType.DOUBLE : TSDataType.FLOAT, value);
    }

    private Long parseDateExpression(IoTDBSqlParser.DateExpressionContext ctx) {
        long time = this.parseDateFormat(ctx.getChild(0).getText());
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if ("+".equals(ctx.getChild(i).getText())) {
                time += DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    private Long parseDateExpression(IoTDBSqlParser.DateExpressionContext ctx, long currentTime) {
        long time = this.parseDateFormat(ctx.getChild(0).getText(), currentTime);
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if ("+".equals(ctx.getChild(i).getText())) {
                time += DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    private long parseTimeValue(IoTDBSqlParser.TimeValueContext ctx, long currentTime) {
        if (ctx.INTEGER_LITERAL() != null) {
            if (ctx.MINUS() != null) {
                return -Long.parseLong(ctx.INTEGER_LITERAL().getText());
            }
            return Long.parseLong(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.dateExpression() != null) {
            return this.parseDateExpression(ctx.dateExpression(), currentTime);
        }
        return this.parseDateFormat(ctx.datetimeLiteral().getText(), currentTime);
    }

    private void setMap(IoTDBSqlParser.AlterClauseContext ctx, Map<String, String> alterMap) {
        List tagsList = ctx.attributePair();
        if (ctx.attributePair(0) != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : tagsList) {
                String value = this.parseAttributeValue(attributePair.attributeValue());
                alterMap.put(this.parseAttributeKey(attributePair.attributeKey()), value);
            }
        }
    }

    private Map<String, String> extractMap(List<IoTDBSqlParser.AttributePairContext> attributePair2, IoTDBSqlParser.AttributePairContext attributePair3) {
        HashMap<String, String> tags = new HashMap<String, String>(attributePair2.size());
        if (attributePair3 != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : attributePair2) {
                tags.put(this.parseAttributeKey(attributePair.attributeKey()), this.parseAttributeValue(attributePair.attributeValue()));
            }
        }
        return tags;
    }

    private String parseAttributeKey(IoTDBSqlParser.AttributeKeyContext ctx) {
        if (ctx.constant() != null) {
            return this.parseStringLiteral(ctx.getText());
        }
        return this.parseIdentifier(ctx.getText());
    }

    private String parseAttributeValue(IoTDBSqlParser.AttributeValueContext ctx) {
        if (ctx.constant() != null) {
            return this.parseStringLiteral(ctx.getText());
        }
        return this.parseIdentifier(ctx.getText());
    }

    private Pair<Long, Long> calcOperatorInterval(QueryFilter queryFilter) {
        if (queryFilter.getSinglePath() != null && !"time".equals(queryFilter.getSinglePath().getMeasurement())) {
            throw new SemanticException(DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG);
        }
        long time = Long.parseLong(((BasicFunctionFilter)queryFilter).getValue());
        switch (queryFilter.getFilterType()) {
            case LESSTHAN: {
                return new Pair((Object)Long.MIN_VALUE, (Object)(time - 1L));
            }
            case LESSTHANOREQUALTO: {
                return new Pair((Object)Long.MIN_VALUE, (Object)time);
            }
            case GREATERTHAN: {
                return new Pair((Object)(time + 1L), (Object)Long.MAX_VALUE);
            }
            case GREATERTHANOREQUALTO: {
                return new Pair((Object)time, (Object)Long.MAX_VALUE);
            }
            case EQUAL: {
                return new Pair((Object)time, (Object)time);
            }
        }
        throw new SemanticException(DELETE_RANGE_ERROR_MSG);
    }

    public Statement visitMerge(IoTDBSqlParser.MergeContext ctx) {
        MergeStatement mergeStatement = new MergeStatement(StatementType.MERGE);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("MERGE ON CLUSTER is not supported in standalone mode");
        }
        mergeStatement.setOnCluster(ctx.LOCAL() == null);
        return mergeStatement;
    }

    public Statement visitFullMerge(IoTDBSqlParser.FullMergeContext ctx) {
        MergeStatement mergeStatement = new MergeStatement(StatementType.FULL_MERGE);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("FULL MERGE ON CLUSTER is not supported in standalone mode");
        }
        mergeStatement.setOnCluster(ctx.LOCAL() == null);
        return mergeStatement;
    }

    public Statement visitFlush(IoTDBSqlParser.FlushContext ctx) {
        FlushStatement flushStatement = new FlushStatement(StatementType.FLUSH);
        ArrayList<PartialPath> storageGroups = null;
        if (ctx.BOOLEAN_LITERAL() != null) {
            flushStatement.setSeq(Boolean.parseBoolean(ctx.BOOLEAN_LITERAL().getText()));
        }
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("FLUSH ON CLUSTER is not supported in standalone mode");
        }
        flushStatement.setOnCluster(ctx.LOCAL() == null);
        if (ctx.prefixPath(0) != null) {
            storageGroups = new ArrayList<PartialPath>();
            for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                storageGroups.add(this.parsePrefixPath(prefixPathContext));
            }
        }
        flushStatement.setStorageGroups(storageGroups);
        return flushStatement;
    }

    public Statement visitClearCache(IoTDBSqlParser.ClearCacheContext ctx) {
        ClearCacheStatement clearCacheStatement = new ClearCacheStatement(StatementType.CLEAR_CACHE);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("CLEAR CACHE ON CLUSTER is not supported in standalone mode");
        }
        clearCacheStatement.setOnCluster(ctx.LOCAL() == null);
        return clearCacheStatement;
    }

    public Statement visitLoadConfiguration(IoTDBSqlParser.LoadConfigurationContext ctx) {
        LoadConfigurationStatement loadConfigurationStatement = new LoadConfigurationStatement(StatementType.LOAD_CONFIGURATION);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("LOAD CONFIGURATION ON CLUSTER is not supported in standalone mode");
        }
        loadConfigurationStatement.setOnCluster(ctx.LOCAL() == null);
        return loadConfigurationStatement;
    }

    public Statement visitSetSystemStatus(IoTDBSqlParser.SetSystemStatusContext ctx) {
        SetSystemStatusStatement setSystemStatusStatement = new SetSystemStatusStatement();
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("SET SYSTEM STATUS ON CLUSTER is not supported in standalone mode");
        }
        setSystemStatusStatement.setOnCluster(ctx.LOCAL() == null);
        if (ctx.RUNNING() != null) {
            setSystemStatusStatement.setStatus(NodeStatus.Running);
        } else if (ctx.READONLY() != null) {
            setSystemStatusStatement.setStatus(NodeStatus.ReadOnly);
        } else if (ctx.ERROR() != null) {
            setSystemStatusStatement.setStatus(NodeStatus.Error);
        } else {
            throw new RuntimeException("Unknown system status in set system command.");
        }
        return setSystemStatusStatement;
    }

    public Statement visitShowRegion(IoTDBSqlParser.ShowRegionContext ctx) {
        ShowRegionStatement showRegionStatement = new ShowRegionStatement();
        if (ctx.DATA() != null) {
            showRegionStatement.setRegionType(TConsensusGroupType.DataRegion);
        } else if (ctx.SCHEMA() != null) {
            showRegionStatement.setRegionType(TConsensusGroupType.SchemaRegion);
        } else {
            showRegionStatement.setRegionType(null);
        }
        if (ctx.OF() != null) {
            ArrayList<PartialPath> storageGroups = null;
            if (ctx.prefixPath(0) != null) {
                storageGroups = new ArrayList<PartialPath>();
                for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                    storageGroups.add(this.parsePrefixPath(prefixPathContext));
                }
            }
            showRegionStatement.setStorageGroups(storageGroups);
        } else {
            showRegionStatement.setStorageGroups(null);
        }
        return showRegionStatement;
    }

    public Statement visitShowDataNodes(IoTDBSqlParser.ShowDataNodesContext ctx) {
        return new ShowDataNodesStatement();
    }

    public Statement visitShowConfigNodes(IoTDBSqlParser.ShowConfigNodesContext ctx) {
        return new ShowConfigNodesStatement();
    }

    public Statement visitCreateSchemaTemplate(IoTDBSqlParser.CreateSchemaTemplateContext ctx) {
        String name = this.parseIdentifier(this.parseIdentifier(ctx.templateName.getText()));
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> dataTypesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<TSEncoding>> encodingsList = new ArrayList<List<TSEncoding>>();
        ArrayList<List<CompressionType>> compressorsList = new ArrayList<List<CompressionType>>();
        if (ctx.ALIGNED() != null) {
            ArrayList<String> measurements = new ArrayList<String>();
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
            for (IoTDBSqlParser.TemplateMeasurementClauseContext templateClauseContext : ctx.templateMeasurementClause()) {
                measurements.add(this.parseNodeNameWithoutWildCard(templateClauseContext.nodeNameWithoutWildcard()));
                this.parseAttributeClause(templateClauseContext.attributeClauses(), dataTypes, encodings, compressors);
            }
            measurementsList.add(measurements);
            dataTypesList.add(dataTypes);
            encodingsList.add(encodings);
            compressorsList.add(compressors);
        } else {
            for (IoTDBSqlParser.TemplateMeasurementClauseContext templateClauseContext : ctx.templateMeasurementClause()) {
                ArrayList<String> measurements = new ArrayList<String>();
                ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
                ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
                ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
                measurements.add(this.parseNodeNameWithoutWildCard(templateClauseContext.nodeNameWithoutWildcard()));
                this.parseAttributeClause(templateClauseContext.attributeClauses(), dataTypes, encodings, compressors);
                measurementsList.add(measurements);
                dataTypesList.add(dataTypes);
                encodingsList.add(encodings);
                compressorsList.add(compressors);
            }
        }
        return new CreateSchemaTemplateStatement(name, measurementsList, dataTypesList, encodingsList, compressorsList);
    }

    void parseAttributeClause(IoTDBSqlParser.AttributeClausesContext ctx, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) {
        if (ctx.aliasNodeName() != null) {
            throw new SQLParserException("schema template: alias is not supported yet.");
        }
        TSDataType dataType = null;
        if (ctx.dataType != null) {
            if (ctx.attributeKey() != null && !this.parseAttributeKey(ctx.attributeKey()).equalsIgnoreCase("dataType")) {
                throw new SQLParserException("expecting datatype");
            }
            String dataTypeString = ctx.dataType.getText().toUpperCase();
            try {
                dataType = TSDataType.valueOf((String)dataTypeString);
                dataTypes.add(dataType);
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported datatype: %s", dataTypeString));
            }
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (ctx.attributePair() != null) {
            for (int i = 0; i < ctx.attributePair().size(); ++i) {
                props.put(this.parseAttributeKey(ctx.attributePair(i).attributeKey()).toLowerCase(), this.parseAttributeValue(ctx.attributePair(i).attributeValue()));
            }
        }
        TSEncoding encoding = IoTDBDescriptor.getInstance().getDefaultEncodingByType(dataType);
        if (props.containsKey("encoding".toLowerCase())) {
            String encodingString = ((String)props.get("encoding".toLowerCase())).toUpperCase();
            try {
                encoding = TSEncoding.valueOf((String)encodingString);
                encodings.add(encoding);
                props.remove("encoding".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported encoding: %s", encodingString));
            }
        } else {
            encodings.add(encoding);
        }
        CompressionType compressor = TSFileDescriptor.getInstance().getConfig().getCompressor();
        if (props.containsKey("compressor".toLowerCase())) {
            String compressorString = ((String)props.get("compressor".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressorString);
                compressors.add(compressor);
                props.remove("compressor".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compressor: %s", compressorString));
            }
        } else if (props.containsKey("compression".toLowerCase())) {
            String compressionString = ((String)props.get("compression".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressionString);
                compressors.add(compressor);
                props.remove("compression".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compression: %s", compressionString));
            }
        } else {
            compressors.add(compressor);
        }
        if (props.size() > 0) {
            throw new SQLParserException("schema template: property is not supported yet.");
        }
        if (ctx.tagClause() != null) {
            throw new SQLParserException("schema template: tag is not supported yet.");
        }
        if (ctx.attributeClause() != null) {
            throw new SQLParserException("schema template: attribute is not supported yet.");
        }
    }

    public Statement visitShowSchemaTemplates(IoTDBSqlParser.ShowSchemaTemplatesContext ctx) {
        return new ShowSchemaTemplateStatement();
    }

    public Statement visitShowNodesInSchemaTemplate(IoTDBSqlParser.ShowNodesInSchemaTemplateContext ctx) {
        String templateName = this.parseIdentifier(ctx.templateName.getText());
        return new ShowNodesInSchemaTemplateStatement(templateName);
    }

    public Statement visitSetSchemaTemplate(IoTDBSqlParser.SetSchemaTemplateContext ctx) {
        String templateName = this.parseIdentifier(ctx.templateName.getText());
        return new SetSchemaTemplateStatement(templateName, this.parsePrefixPath(ctx.prefixPath()));
    }

    public Statement visitShowPathsSetSchemaTemplate(IoTDBSqlParser.ShowPathsSetSchemaTemplateContext ctx) {
        String templateName = this.parseIdentifier(ctx.templateName.getText());
        return new ShowPathSetTemplateStatement(templateName);
    }

    public Statement visitCreateTimeseriesOfSchemaTemplate(IoTDBSqlParser.CreateTimeseriesOfSchemaTemplateContext ctx) {
        ActivateTemplateStatement statement = new ActivateTemplateStatement();
        statement.setPath(this.parsePrefixPath(ctx.prefixPath()));
        return statement;
    }

    public Statement visitShowPathsUsingSchemaTemplate(IoTDBSqlParser.ShowPathsUsingSchemaTemplateContext ctx) {
        return new ShowPathsUsingTemplateStatement(this.parseIdentifier(ctx.templateName.getText()));
    }

    public Map<String, String> parseSyncAttributeClauses(IoTDBSqlParser.SyncAttributeClausesContext ctx) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        List attributePairs = ctx.attributePair();
        if (ctx.attributePair(0) != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : attributePairs) {
                attributes.put(this.parseAttributeKey(attributePair.attributeKey()).toLowerCase(), this.parseAttributeValue(attributePair.attributeValue()).toLowerCase());
            }
        }
        return attributes;
    }

    private PartialPath parsePathFromExpression(Expression expression) {
        if (expression instanceof TimeSeriesOperand) {
            return ((TimeSeriesOperand)expression).getPath();
        }
        if (expression instanceof TimestampOperand) {
            return SQLConstant.TIME_PATH;
        }
        throw new IllegalArgumentException("Unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    private void parseSelectStatementForPipe(IoTDBSqlParser.SelectStatementContext ctx, CreatePipeStatement statement) throws SQLParserException {
        if (ctx.TRACING() != null || ctx.intoClause() != null || ctx.specialClause() != null) {
            throw new SQLParserException("Not support for this sql in pipe.");
        }
        IoTDBSqlParser.SelectClauseContext selectCtx = ctx.selectClause();
        if (selectCtx.LAST() != null || selectCtx.resultColumn().size() != 1) {
            throw new SQLParserException("Not support for this sql in pipe.");
        }
        IoTDBSqlParser.ResultColumnContext resultColumnCtx = selectCtx.resultColumn(0);
        if (resultColumnCtx.AS() != null || !"**".equals(resultColumnCtx.expression().getText())) {
            throw new SQLParserException("Not support for this sql in pipe.");
        }
        IoTDBSqlParser.FromClauseContext fromCtx = ctx.fromClause();
        if (fromCtx.prefixPath().size() != 1 || !"root".equals(fromCtx.prefixPath(0).getText())) {
            throw new SQLParserException("Not support for this sql in pipe.");
        }
        IoTDBSqlParser.WhereClauseContext whereCtx = ctx.whereClause();
        if (whereCtx != null) {
            Expression predicate = this.parseExpression(whereCtx.expression(), whereCtx.expression().OPERATOR_NOT() == null);
            if (!(predicate instanceof GreaterThanExpression) && !(predicate instanceof GreaterEqualExpression)) {
                throw new SQLParserException("Not support for this sql in pipe.");
            }
            Expression left = ((BinaryExpression)predicate).getLeftExpression();
            Expression right = ((BinaryExpression)predicate).getRightExpression();
            if (!SQLConstant.isReservedPath(this.parsePathFromExpression(left))) {
                throw new SQLParserException("Not support for this sql in pipe.");
            }
            if (!(right instanceof ConstantOperand)) {
                throw new SQLParserException("Not support for this sql in pipe.");
            }
            if (((ConstantOperand)right).getDataType() != TSDataType.INT64) {
                throw new SQLParserException("Not support for this sql in pipe.");
            }
            long startTime = Long.parseLong(((ConstantOperand)right).getValueString());
            statement.setStartTime(startTime);
        }
    }

    public Statement visitShowPipe(IoTDBSqlParser.ShowPipeContext ctx) {
        ShowPipeStatement showPipeStatement = new ShowPipeStatement();
        if (ctx.pipeName != null) {
            showPipeStatement.setPipeName(this.parseIdentifier(ctx.pipeName.getText()));
        }
        return showPipeStatement;
    }

    public Statement visitCreatePipe(IoTDBSqlParser.CreatePipeContext ctx) throws SQLParserException {
        CreatePipeStatement createPipeStatement = new CreatePipeStatement(StatementType.CREATE_PIPE);
        if (ctx.pipeName == null || ctx.pipeSinkName == null) {
            throw new SQLParserException("Not support for this sql in CREATEPIPE, please enter pipename or pipesinkname.");
        }
        createPipeStatement.setPipeName(this.parseIdentifier(ctx.pipeName.getText()));
        createPipeStatement.setPipeSinkName(this.parseIdentifier(ctx.pipeSinkName.getText()));
        if (ctx.selectStatement() != null) {
            this.parseSelectStatementForPipe(ctx.selectStatement(), createPipeStatement);
        }
        if (ctx.syncAttributeClauses() != null) {
            createPipeStatement.setPipeAttributes(this.parseSyncAttributeClauses(ctx.syncAttributeClauses()));
        } else {
            createPipeStatement.setPipeAttributes(new HashMap<String, String>());
        }
        return createPipeStatement;
    }

    public Statement visitStartPipe(IoTDBSqlParser.StartPipeContext ctx) {
        StartPipeStatement startPipeStatement = new StartPipeStatement(StatementType.START_PIPE);
        if (ctx.pipeName == null) {
            throw new SQLParserException("Not support for this sql in STARTPIPE, please enter pipename.");
        }
        startPipeStatement.setPipeName(this.parseIdentifier(ctx.pipeName.getText()));
        return startPipeStatement;
    }

    public Statement visitStopPipe(IoTDBSqlParser.StopPipeContext ctx) {
        StopPipeStatement stopPipeStatement = new StopPipeStatement(StatementType.STOP_PIPE);
        if (ctx.pipeName == null) {
            throw new SQLParserException("Not support for this sql in STOPPIPE, please enter pipename.");
        }
        stopPipeStatement.setPipeName(this.parseIdentifier(ctx.pipeName.getText()));
        return stopPipeStatement;
    }

    public Statement visitDropPipe(IoTDBSqlParser.DropPipeContext ctx) {
        DropPipeStatement dropPipeStatement = new DropPipeStatement(StatementType.DROP_PIPE);
        if (ctx.pipeName == null) {
            throw new SQLParserException("Not support for this sql in DROPPIPE, please enter pipename.");
        }
        dropPipeStatement.setPipeName(this.parseIdentifier(ctx.pipeName.getText()));
        return dropPipeStatement;
    }

    public Statement visitShowPipeSink(IoTDBSqlParser.ShowPipeSinkContext ctx) {
        ShowPipeSinkStatement showPipeSinkStatement = new ShowPipeSinkStatement();
        if (ctx.pipeSinkName != null) {
            showPipeSinkStatement.setPipeSinkName(this.parseIdentifier(ctx.pipeSinkName.getText()));
        }
        return showPipeSinkStatement;
    }

    public Statement visitShowPipeSinkType(IoTDBSqlParser.ShowPipeSinkTypeContext ctx) {
        ShowPipeSinkTypeStatement showPipeSinkTypeStatement = new ShowPipeSinkTypeStatement();
        return showPipeSinkTypeStatement;
    }

    public Statement visitCreatePipeSink(IoTDBSqlParser.CreatePipeSinkContext ctx) {
        CreatePipeSinkStatement createPipeSinkStatement = new CreatePipeSinkStatement(StatementType.CREATE_PIPESINK);
        if (ctx.pipeSinkName == null) {
            throw new SQLParserException("Not support for this sql in CREATEPIPESINK, please enter pipesinkname.");
        }
        createPipeSinkStatement.setPipeSinkName(this.parseIdentifier(ctx.pipeSinkName.getText()));
        if (ctx.pipeSinkType == null) {
            throw new SQLParserException("Not support for this sql in CREATEPIPESINK, please enter pipesinktype.");
        }
        createPipeSinkStatement.setPipeSinkType(this.parseIdentifier(ctx.pipeSinkType.getText()));
        if (ctx.syncAttributeClauses() != null) {
            createPipeSinkStatement.setAttributes(this.parseSyncAttributeClauses(ctx.syncAttributeClauses()));
        } else {
            createPipeSinkStatement.setAttributes(new HashMap<String, String>());
        }
        return createPipeSinkStatement;
    }

    public Statement visitDropPipeSink(IoTDBSqlParser.DropPipeSinkContext ctx) {
        DropPipeSinkStatement dropPipeSinkStatement = new DropPipeSinkStatement(StatementType.DROP_PIPESINK);
        if (ctx.pipeSinkName == null) {
            throw new SQLParserException("Not support for this sql in DROPPIPESINK, please enter pipesinkname.");
        }
        dropPipeSinkStatement.setPipeSinkName(this.parseIdentifier(ctx.pipeSinkName.getText()));
        return dropPipeSinkStatement;
    }
}

