/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class CountStorageGroupTask
implements IConfigTask {
    private CountStorageGroupStatement countStorageGroupStatement;

    public CountStorageGroupTask(CountStorageGroupStatement countStorageGroupStatement) {
        this.countStorageGroupStatement = countStorageGroupStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.countStorageGroup(this.countStorageGroupStatement);
    }

    public static void buildTSBlock(int storageGroupNum, SettableFuture<ConfigTaskResult> future) {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeInt(storageGroupNum);
        builder.declarePosition();
        ColumnHeader storageGroupColumnHeader = new ColumnHeader("count", TSDataType.INT32);
        DatasetHeader datasetHeader = new DatasetHeader(Collections.singletonList(storageGroupColumnHeader), true);
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

